/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NLD.parser;

import com.mapinfo.mapmarker.NLD.address.NLD_ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NLDParser
extends CGGEParser1 {
    private static final String REGEX_DIGIT = "\\d{4}";
    private static final String REGEX_CHAR = "[a-zA-Z]{2}";
    private static final String REGEX_EXTENDED_PC = "\\d{4}[a-zA-Z]{2}";
    private static final Pattern P_DIGIT = Pattern.compile("\\d{4}");
    private static final Pattern P_CHAR = Pattern.compile("[a-zA-Z]{2}");
    private static final Pattern P_EXTENDEDPC = Pattern.compile("\\d{4}[a-zA-Z]{2}");

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddress = super.parse(inputAddress, scorer);
        String hnr = (String)inputAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)hnr)) {
            for (ParsedAddress parsedAddr : parsedAddress) {
                if (parsedAddr.getAddressNumber() != null) continue;
                parsedAddr.setAddressNumber(this.parserAddressNumber(hnr));
            }
        }
        ParsedAddress address = parsedAddress[0];
        NLD_ParsedAddress localParsedAddress = new NLD_ParsedAddress(address.getCountry(), address.getLanguage());
        localParsedAddress.copy(address);
        boolean isSpecialRequest = this.detemineSpecialRequest(localParsedAddress);
        localParsedAddress.setSpecialSixDigitPCRequest(isSpecialRequest);
        parsedAddress[0] = localParsedAddress;
        List<PostCode> probablePcs = parsedAddress[0].getProbablePostcodes();
        if (probablePcs != null) {
            for (ParsedAddress parsedAddr : parsedAddress) {
                for (PostCode postCode : probablePcs) {
                    postCode.setWords(this.getAddressWords(this.getformattedPostCode(postCode.toString(), isSpecialRequest)));
                }
            }
        }
        if (!isSpecialRequest && parsedAddress[0].getField(FieldType.POST_CODE_FIELD_TYPE) != null) {
            AddressWord[] w = (AddressWord[])parsedAddress[0].getField(FieldType.POST_CODE_FIELD_TYPE);
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>();
            wordList.add(w[0]);
            parsedAddress[0].setField(FieldType.POST_CODE_FIELD_TYPE, wordList.toArray(new AddressWord[wordList.size()]));
        }
        return parsedAddress;
    }

    private boolean detemineSpecialRequest(NLD_ParsedAddress parsedAddress) {
        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        boolean flag = true;
        this.findExtendedPCInUserInput(parsedAddress);
        if (words != null) {
            int wordLength = words.length;
            for (int i = 0; i < wordLength; ++i) {
                if ("%".equals(words[i].getWord()) && i > 0) {
                    Matcher mExtendedPC = P_EXTENDEDPC.matcher(words[i - 1].getWord() + words[i + 1].getWord());
                    if (mExtendedPC.matches()) {
                        ++i;
                        continue;
                    }
                } else if (this.getThoroughfareTypeHandler().isThoroughfareType(words[i].getWord()) && i > 0) {
                    Matcher mExtendedPC1 = P_DIGIT.matcher(words[i - 1].getWord());
                    if (words[i].getWord().length() == 2 && mExtendedPC1.matches()) continue;
                    flag = false;
                    break;
                }
                if (!this.getParserTerms().isCommonWord(words[i].getWord()) && !this.getParserTerms().isAbbreviation(words[i].getWord()) && !this.getParserTerms().isDirectionalWord(words[i].getWord()) && !this.getParserTerms().isArticle(words[i].getWord())) continue;
                flag = false;
                break;
            }
            if (!flag) {
                List<AddressNumber> probableAddressNumbers = parsedAddress.getProbableAddressNumbers();
                if (!StringUtilities.isEmpty((String)parsedAddress.getExtended_pc_input()) && probableAddressNumbers != null && !probableAddressNumbers.isEmpty()) {
                    for (AddressNumber addrNum : probableAddressNumbers) {
                        if (!addrNum.isRange()) continue;
                        flag = true;
                        break;
                    }
                }
            }
            if (flag && !StringUtilities.isNumeric((String)words[0].getWord()) && !StringUtilities.hasNumeric((String)words[0].getWord())) {
                flag = false;
            }
        }
        return flag;
    }

    private void findExtendedPCInUserInput(NLD_ParsedAddress parsedAddress) {
        AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        AddressWord[] postWords = (AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
        AddressWord[] postAddressWords = (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        if (postWords != null) {
            this.checkForExtendedPostCodeInPostWords(postWords, parsedAddress);
        } else if (postAddressWords != null) {
            this.checkForExtendedPostCodeInPostWords(postAddressWords, parsedAddress);
        } else if (streetWords != null) {
            this.checkForExtendedPostCodeInStreetWords(streetWords, parsedAddress);
        }
    }

    private boolean checkForExtendedPostCodeInStreetWords(AddressWord[] words, NLD_ParsedAddress parsedAddress) {
        Matcher mDigit = null;
        Matcher mChar = null;
        Matcher mExtendedPC = null;
        boolean isExtendedPCInInput = false;
        int wordCount = words.length;
        for (int i = 0; i < wordCount; ++i) {
            String word = words[i].getWord();
            if (this.getThoroughfareTypeHandler().isThoroughfareType(word) || this.getParserTerms().isCommonWord(word) || this.getParserTerms().isAbbreviation(word) || this.getParserTerms().isDirectionalWord(word) || this.getParserTerms().isArticle(word)) continue;
            mDigit = P_DIGIT.matcher(word);
            mExtendedPC = P_EXTENDEDPC.matcher(word);
            if (mExtendedPC.matches()) {
                parsedAddress.setExtended_pc_input(word);
                isExtendedPCInInput = true;
                break;
            }
            if (!mDigit.matches() || i >= wordCount - 1) continue;
            String nextWord = words[i + 1].getWord();
            if (nextWord.equals("%")) {
                nextWord = words[i + 2].getWord();
            }
            if (!(mChar = P_CHAR.matcher(nextWord)).matches()) continue;
            parsedAddress.setExtended_pc_input(word + nextWord);
            isExtendedPCInInput = true;
            break;
        }
        return isExtendedPCInInput;
    }

    private boolean checkForExtendedPostCodeInPostWords(AddressWord[] words, NLD_ParsedAddress parsedAddress) {
        Matcher mDigit = null;
        Matcher mChar = null;
        Matcher mExtendedPC = null;
        boolean isExtendedPCInInput = false;
        int wordCount = words.length;
        for (int i = 0; i < wordCount; ++i) {
            String word = words[i].getWord();
            mDigit = P_DIGIT.matcher(word);
            mExtendedPC = P_EXTENDEDPC.matcher(word);
            if (mExtendedPC.matches()) {
                parsedAddress.setExtended_pc_input(word);
                isExtendedPCInInput = true;
                break;
            }
            if (!mDigit.matches() || i >= wordCount - 1) continue;
            String nextWord = words[i + 1].getWord();
            if (nextWord.equals("%")) {
                nextWord = words[i + 2].getWord();
            }
            if (!(mChar = P_CHAR.matcher(nextWord)).matches()) continue;
            parsedAddress.setExtended_pc_input(word + nextWord);
            isExtendedPCInInput = true;
            break;
        }
        return isExtendedPCInInput;
    }

    private String getformattedPostCode(String postcode, boolean isSpecialsixDigitCase) {
        if (!StringUtilities.isEmpty((String)postcode)) {
            int i;
            postcode = postcode.replaceAll("%", "");
            postcode = postcode.replaceAll(" ", "");
            StringBuffer postCodeBuffer = new StringBuffer(postcode);
            for (i = postCodeBuffer.length() - 1; i >= 0 && Character.isLetter(postCodeBuffer.charAt(i)); --i) {
            }
            ++i;
            if (isSpecialsixDigitCase) {
                postCodeBuffer.insert(i, "%");
            } else {
                postCodeBuffer.delete(i, postCodeBuffer.length());
            }
            return postCodeBuffer.toString();
        }
        return postcode;
    }

    @Override
    protected void addTypeSeparators(StringBuilder buffer) {
        int[] pos;
        int len = buffer.length();
        int startNdx = 0;
        boolean typeFound = false;
        while (len > 0 && (pos = super.getThoroughfareTypeHandler().findThoroughfareType(buffer.substring(startNdx, startNdx + len))) != null) {
            char ch;
            if (pos[0] > 0) {
                ch = buffer.charAt(startNdx + (pos[0] - 1));
                int postThoroughfareLength = pos[1] - pos[0];
                int start = startNdx + pos[0] - 5;
                int end = startNdx + pos[0] - 1;
                boolean isSpecialCase = this.isSpecialCase(buffer, ch, postThoroughfareLength, start, end);
                if (Character.isLetterOrDigit(ch) || isSpecialCase) {
                    String word;
                    boolean canInsert;
                    boolean bl = canInsert = !typeFound;
                    if (!canInsert) {
                        canInsert = pos[1] == buffer.length();
                        for (int i = pos[0]; i < buffer.length(); ++i) {
                            String chStr = "" + buffer.charAt(i);
                            if (!this.m_parserTerms.isDelimiter(chStr)) continue;
                            if ("%".equals(chStr)) break;
                            canInsert = true;
                            break;
                        }
                    }
                    if (canInsert && (this.m_parserTerms.isAbbreviatableWord(word = this.findWordAtPosition(buffer, startNdx + pos[0])) || this.m_parserTerms.isCommonWord(word))) {
                        canInsert = false;
                    }
                    if (canInsert) {
                        buffer.insert(startNdx + pos[0], "%");
                        typeFound = true;
                    }
                }
                len = pos[1] - pos[0] > 1 ? pos[0] + 1 : pos[0];
                continue;
            }
            if (pos[0] != 0 || pos[1] >= len - 1) break;
            ch = buffer.charAt(startNdx + pos[1]);
            if (Character.isLetterOrDigit(ch)) {
                boolean canInsert;
                boolean bl = canInsert = !typeFound;
                if (!canInsert) {
                    canInsert = pos[1] == buffer.length();
                    for (int i = pos[0]; i < buffer.length(); ++i) {
                        String chStr = "" + buffer.charAt(i);
                        if (!"%".equals(chStr) && !this.m_parserTerms.isDelimiter(chStr)) continue;
                        canInsert = false;
                        break;
                    }
                }
                if (canInsert) {
                    buffer.insert(startNdx + pos[1], "%");
                    typeFound = true;
                }
                startNdx = pos[1] + 1;
            } else {
                startNdx = pos[1];
            }
            len -= startNdx;
        }
    }

    private boolean isSpecialCase(StringBuilder buffer, char ch, int postThoroughfareLength, int start, int end) {
        return postThoroughfareLength == 2 && start >= 0 && end > 0 && StringUtilities.isNumeric((String)buffer.toString(), (int)start, (int)end) && Character.isSpaceChar(ch);
    }
}

