/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.converter;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class PRTCandidateConvertor
extends CGGECandidateConvertor {
    private static final String EXTENDED_POSTALCODE_PRECISIONCODE = "Z3";
    private static final String PARTIAL_POSTCODE_PRECISIONCODE = "Z1";
    private static final int EXTENDED_POSTALCODE_LENGTH = 8;

    @Override
    public CandidateAddress convertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        CandidateAddress candidateAddress = super.convertCandidate(scoringAddress, dataManager, formatter, constraints);
        return this.checkForZ3Precision(scoringAddress, candidateAddress);
    }

    private CandidateAddress checkForZ3Precision(InternalScoringAddress scoringAddress, CandidateAddress candidateAddress) {
        String value;
        AddressWord[] addressWords;
        InternalFieldValue ifv;
        String precisionCode = candidateAddress.getPrecisionCode();
        if (PARTIAL_POSTCODE_PRECISIONCODE.equalsIgnoreCase(precisionCode) && (ifv = (InternalFieldValue)scoringAddress.getFields().get(FieldType.POST_CODE_FIELD_TYPE)) != null && (addressWords = (AddressWord[])ifv.getFieldValue()) != null && addressWords.length > 0 && !StringUtilities.isEmpty((String)(value = addressWords[0].getWord())) && value.length() == 8) {
            HashMap addFields = candidateAddress.getAdditionalFields();
            addFields.put("RESULT_CODE", EXTENDED_POSTALCODE_PRECISIONCODE);
        }
        return candidateAddress;
    }
}

