/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.matcher;

import com.mapinfo.mapmarker.PRT.parser.PRT_Parser;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.List;
import java.util.Map;

public class PRTMatcher
extends CGGEMatcher1 {
    private static final int FULL_POSTALCODE_LENGTH = 8;

    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore postalScore = super.scorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer);
        CGGEHandler handler = CGGEHandler.getInstance(this.getDataSetInfo(), this.getCountry(), this.getLanguage());
        PRT_Parser parser = (PRT_Parser)handler.getParser();
        if (postalScore.m_value < 1.0 && parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE) != null) {
            String candidateFullPC = parser.getStringFromAddressWordArray((AddressWord[])((InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue());
            if (!MMUtils.isEmpty(candidateFullPC) && candidateFullPC.length() < 8) {
                AddressWord[] GF4 = (AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
                this.scorePostCode1(addr, postalScore, parser, GF4);
            }
        } else {
            List<PostCode> pcProbables;
            AddressWord[] aw = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
            if (null == aw && (pcProbables = parsedAddr.getProbablePostcodes()) != null) {
                for (PostCode pc : pcProbables) {
                    String inputPC = parser.getStringFromAddressWordArray(pc.getWords());
                    if (MMUtils.isEmpty(inputPC) || inputPC.length() >= 8) continue;
                    aw = pc.getWords();
                }
            }
            this.scorePostCode1(addr, postalScore, parser, aw);
        }
        return postalScore;
    }

    private void scorePostCode1(ScoringItem addr, FieldScore postalScore, PRT_Parser parser, AddressWord[] GF4) {
        String inputtedPC = parser.getInitialFourDigitPC(GF4);
        String candPC = parser.getInitialFourDigitPC((AddressWord[])((InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue());
        if (!MMUtils.isEmpty(inputtedPC) && !MMUtils.isEmpty(candPC) && inputtedPC.equals(candPC)) {
            postalScore.m_value = 1.0;
            postalScore.m_matched = true;
            postalScore.m_perfectInputWords = new IntArray(1, 0);
        }
    }

    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        this.scoreFieldsAtLevel(pAddr, scoringAddr, FieldType.FieldLevel.LEVEL_STREET, matchingOptions, scorer);
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (score != null && score.m_value > 0.95) {
            this.adjustScoreForMissingArticles(score);
        }
    }

    private void adjustScoreForMissingArticles(FieldScore fieldScore) {
        if (fieldScore != null && fieldScore.m_perfectCandWords != null && fieldScore.m_perfectCandWords.size() > 0) {
            int candWordCount;
            int n = candWordCount = fieldScore.m_candWords == null ? 0 : fieldScore.m_candWords.length;
            if (fieldScore.m_matchedCandWords.size() < candWordCount) {
                double missingArticleWeights = 0.0;
                for (int wordNdx = 0; wordNdx < candWordCount; ++wordNdx) {
                    AddressWord word = fieldScore.m_candWords[wordNdx];
                    Short attrib = word.getAttributes();
                    if (!CodedWord.isArticleWord(attrib) && !CodedWord.isCommonWord(attrib) || fieldScore.m_matchedCandWords.contains(wordNdx)) continue;
                    missingArticleWeights += (double)word.m_weight;
                }
                fieldScore.m_value += missingArticleWeights / 100.0 * 0.9;
            }
        }
    }
}

