/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.PRT.parser;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PRT_Parser
extends CGGEParser1 {
    private static final String PARTIAL_POSTALCODE_FORMAT = "\\b(\\d{4})\\b";
    private static final Pattern PARTIAL_POSTALCODE = Pattern.compile("\\b(\\d{4})\\b", 2);
    private static final int FULL_POSTALCODE_LENGTH = 8;

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (parsedAddresses != null && parsedAddresses.length > 0) {
            ParsedAddress parsedAddr = parsedAddresses[0];
            if (parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE) != null) {
                this.populatePartialPostCodeToGenericField(parsedAddr, (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE));
            } else {
                List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
                if (pcProbables != null) {
                    for (PostCode pc : pcProbables) {
                        this.populatePartialPostCodeToGenericField(parsedAddr, pc.getWords());
                    }
                }
            }
        }
        return parsedAddresses;
    }

    private void populatePartialPostCodeToGenericField(ParsedAddress parsedAddr, AddressWord[] pcWords) {
        String inputPC = this.getStringFromAddressWordArray(pcWords);
        if (!MMUtils.isEmpty(inputPC) && inputPC.length() == 8) {
            parsedAddr.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.getAddressWords(this.getInitialFourDigitPC(pcWords)));
        }
    }

    public String getInitialFourDigitPC(AddressWord[] pcAddressWordArray) {
        Matcher pcmatcher;
        String pcString = this.getStringFromAddressWordArray(pcAddressWordArray);
        if (!MMUtils.isEmpty(pcString) && (pcmatcher = PARTIAL_POSTALCODE.matcher(pcString)).find()) {
            pcString = pcmatcher.group(1);
        }
        return pcString;
    }

    public String getStringFromAddressWordArray(AddressWord[] pcAddressWordArray) {
        StringBuilder builder = new StringBuilder();
        if (pcAddressWordArray != null && pcAddressWordArray.length > 0) {
            for (AddressWord addressWord : pcAddressWordArray) {
                builder.append(addressWord.getCodedWord().getWord()).append(" ");
            }
        }
        return builder.toString().trim();
    }
}

