/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA;

import com.mapinfo.mapmarker.cgge.CGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class THA_TH_CandidateFilter
extends CGGECandidateFilter {
    @Override
    public void filterMultipleCloseCandidates(InternalCandidateList internalCandList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        this.checkCityAndStreetSameInCandSLInput(internalCandList, addr, options);
        super.filterMultipleCloseCandidates(internalCandList, addr, options);
    }

    protected void checkCityAndStreetSameInCandSLInput(InternalCandidateList internalCandidateList, ParsedAddress addr, GeocodeOptions options) {
        if (options.getGeocodeType() != 1 || internalCandidateList == null || !internalCandidateList.hasCandidates() || internalCandidateList.getNumberOfCloseMatches() < 2) {
            return;
        }
        List<InternalScoringAddress> candList = internalCandidateList.getCandidateList();
        AddressWord[] stwords = (AddressWord[])addr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        AddressWord[] lastLineWords = (AddressWord[])addr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        StringBuilder sb = null;
        if (this.doesParseHaveType(addr) && stwords != null && stwords.length > 0 && stwords.equals(lastLineWords)) {
            sb = new StringBuilder(stwords[0].getWord());
            for (int i = 1; i < stwords.length; ++i) {
                String str = stwords[i].getWord();
                sb.append(str);
                sb.append(" ");
            }
            int closeCount = internalCandidateList.getNumberOfCloseMatches();
            InternalScoringAddress scorAddr1 = candList.get(0);
            String streetStr = ((InternalFieldValue)scorAddr1.getField(FieldType.STREET_NAME_FIELD_TYPE)).toString().trim();
            if (((AddressWord[])((InternalFieldValue)scorAddr1.getField(FieldType.STREET_NAME_FIELD_TYPE)).getFieldValue()).length == 1 && scorAddr1.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null && ((AddressWord[])((InternalFieldValue)scorAddr1.getField(FieldType.AREA_NAME_3_FIELD_TYPE)).getFieldValue()).length == 1 && streetStr.equals(((InternalFieldValue)scorAddr1.getField(FieldType.AREA_NAME_3_FIELD_TYPE)).toString().trim())) {
                InternalScoringAddress scoringCand;
                int i;
                int goodpos = -1;
                double prevKeepPostalScore = 0.0;
                for (i = 1; i < closeCount; ++i) {
                    scoringCand = candList.get(i);
                    InternalFieldValue ifv = (InternalFieldValue)scoringCand.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    if (((AddressWord[])ifv.getFieldValue()).length <= 1 || !sb.toString().trim().contains(streetStr)) continue;
                    double curScore = scoringCand.getCombinedPostalScore();
                    if (curScore > prevKeepPostalScore) {
                        goodpos = i;
                    }
                    prevKeepPostalScore = curScore;
                }
                if (goodpos >= 0) {
                    for (i = 0; i < closeCount; ++i) {
                        scoringCand = candList.get(i);
                        if (i == goodpos) continue;
                        scoringCand.setCloseMatch(false);
                    }
                    internalCandidateList.setNumberOfCloseMatches(1);
                    LinkedList<InternalScoringAddress> sortedCands = new LinkedList<InternalScoringAddress>();
                    Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new CGGEInternalScoringAddressComparator());
                    for (int i2 = 0; i2 < candList.size(); ++i2) {
                        InternalScoringAddress scoringAddr = candList.get(i2);
                        int ndx = MMUtils.nextInsertPosition(sortedCands, scoringAddr, reverseComparator);
                        sortedCands.add(ndx, scoringAddr);
                    }
                    candList.clear();
                    internalCandidateList.setCandidateList(sortedCands);
                    internalCandidateList.setBestFetchedCandidate(sortedCands.get(0));
                    internalCandidateList.setNumberOfCloseMatches(1);
                }
            }
        }
    }

    private boolean doesParseHaveType(ParsedAddress pa) {
        AddressWord[] words;
        for (AddressWord wd : words = (AddressWord[])pa.getField(FieldType.STREET_NAME_FIELD_TYPE)) {
            if (!CodedWord.isThoroughfareTypeWord(wd.getAttributes())) continue;
            return true;
        }
        return false;
    }
}

