/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.List;

public class THAStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    public static int AREA_CASE_12 = 12;

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (this.m_areaSubTryCount == AREA_CASE_12) {
            ++this.m_areaSubTryCount;
        }
        return super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList);
    }

    @Override
    protected boolean generateStreetSubTriesForIntersection(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                this.m_searchWordList = this.filterSearchWords(this.getSearchableWords(this.filterSearchWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), true, 0), FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options), true, 0);
                return true;
            }
            case 1: {
                ++this.m_streetSubTryCount;
                this.m_searchWordList = this.getSearchableWords((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE), FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options);
                return true;
            }
        }
        return false;
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        String street;
        InternalCandidateList internalCandidateList = super.retrieveCandidates(dataManager, parsedAddress, areaList, searchWordList, options);
        List dataSetList = (List)options.get("allowed_datasets_list");
        if (internalCandidateList != null && ((DataSetInfo)dataSetList.get(0)).getName().toUpperCase().contains("STREET") && ((DataSetInfo)dataSetList.get(0)).getMetaData().getLanguage().equalsIgnoreCase("TH") && (street = (String)parsedAddress.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE)) != null) {
            StringBuilder sb = new StringBuilder();
            InternalCandidateList retainedCandidateList = new InternalCandidateList();
            boolean preFilter = false;
            int pos = street.indexOf("\u0e16\u0e19\u0e19");
            int pos2 = street.indexOf("\u0e0b\u0e2d\u0e22 ");
            if (pos2 > pos && pos >= 0) {
                int idx = pos2 + 4;
                while (street.charAt(idx) == ' ') {
                    ++idx;
                }
                if (Character.isDigit(street.charAt(idx))) {
                    while (idx < street.length() && Character.isDigit(street.charAt(idx))) {
                        sb.append(street.charAt(idx));
                        ++idx;
                    }
                    preFilter = true;
                }
                if (preFilter) {
                    String check1 = "\u0e16\u0e19\u0e19";
                    String check2 = "\u0e0b\u0e2d\u0e22 " + sb.toString();
                    List<InternalScoringAddress> candidateList = internalCandidateList.getCandidateList();
                    int candidateListSize = candidateList.size();
                    for (int index = 0; index < candidateListSize; ++index) {
                        InternalScoringAddress scorAddr = candidateList.get(index);
                        InternalFieldValue ifv = (InternalFieldValue)scorAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                        String streetStr = ifv.toString();
                        int t1pos = streetStr.indexOf(check1);
                        int t2pos = streetStr.indexOf(check2);
                        if (t2pos <= t1pos || t1pos < 0) continue;
                        retainedCandidateList.addCandidate(scorAddr);
                    }
                    return retainedCandidateList;
                }
            }
        }
        return internalCandidateList;
    }

    @Override
    public boolean doesBestCandidateHasPerfectField(InternalCandidateList candList, FieldType type) {
        if (candList != null && candList.getCandidateCount() > 0) {
            InternalScoringAddress candAddr = candList.getIndexedCandidate(0);
            FieldScore score = candAddr.getFieldScore(type);
            if (type == FieldType.STREET_NAME_FIELD_TYPE) {
                return this.isPerfectScore(score);
            }
            FieldScore scoreStreet = candAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            return this.isPerfectScore(score) && this.isPerfectScore(scoreStreet);
        }
        return false;
    }

    public boolean isPerfectScore(FieldScore score) {
        return score != null && score.m_value >= 1.0;
    }
}

