/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA.matcher;

import com.mapinfo.mapmarker.THA.matcher.THAMatcher_Utils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;

public class THAMatcher
extends CGGEMatcher1 {
    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        AddressWord streetWord;
        int i;
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        int throughfareIndex = 0;
        if (pAddr.isIntersectionCase()) {
            return;
        }
        int countCandSignificantWords = 0;
        AddressWord[] inpAddressWords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (null == ifv || null == inpAddressWords) {
            return;
        }
        AddressWord[] streetCandWords = (AddressWord[])ifv.getFieldValue();
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        for (i = 0; i < inpAddressWords.length; ++i) {
            AddressWord inpWords = inpAddressWords[i];
            short wordAttribs = inpWords.getAttributes();
            if (!CodedWord.isThoroughfareTypeWord(wordAttribs)) continue;
            throughfareIndex = i;
        }
        for (i = 0; i < streetCandWords.length; ++i) {
            streetWord = streetCandWords[i];
            String word = streetWord.getWord();
            if (!AddressWord.isSignificantWord(streetWord)) continue;
            ++countCandSignificantWords;
        }
        for (i = 0; i < streetCandWords.length; ++i) {
            streetWord = streetCandWords[i];
            String word = streetWord.getWord();
            for (int j = 0; j < inpAddressWords.length; ++j) {
                double stCutoff;
                AddressWord addressWord = inpAddressWords[j];
                if (!AddressWord.isSignificantWord(streetWord) || !AddressWord.isSignificantWord(addressWord) || !(scorer.scoreAddressWords(streetWord, addressWord) >= 1.0) || word.length() <= 6 || score == null || !(score.m_value < 0.2) || countCandSignificantWords > 2 || throughfareIndex != 0 && throughfareIndex <= j) continue;
                score.m_value = stCutoff = matchingOptions.getStreetFieldCutoff();
            }
        }
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        boolean closeMatch = super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
        if (closeMatch && !THAMatcher_Utils.isPlotGood(parsedAddr, scoringAddr)) {
            return false;
        }
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        FieldScore postcodeScore = scoringAddr.getFieldScore(FieldType.POST_CODE_FIELD_TYPE);
        FieldScore townScore = scoringAddr.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE);
        if (parsedAddr.isSeparateAreaFields() && townScore != null && townScore.m_value < 0.53) {
            closeMatch = false;
        }
        if (closeMatch && streetScore != null && streetScore.m_value < 0.95 && postcodeScore != null && postcodeScore.m_value < 0.95) {
            if (townScore == null) {
                closeMatch = false;
            } else if (townScore.m_value < 0.98) {
                closeMatch = false;
            }
        }
        if (closeMatch && streetScore != null && !parsedAddr.isIntersectionCase()) {
            if (streetScore.m_value > 0.84) {
                if (townScore == null) {
                    if (postcodeScore != null) {
                        if (postcodeScore.m_value < 1.0) {
                            closeMatch = false;
                        }
                    } else {
                        closeMatch = false;
                    }
                } else if (townScore.m_value > 0.95 && (postcodeScore == null || postcodeScore.m_value < 0.95) && townScore.m_value < 1.0) {
                    closeMatch = false;
                }
            } else if (!(townScore != null && townScore.m_value >= 1.0 && streetScore.m_value > 0.72 || postcodeScore != null && postcodeScore.m_value >= 1.0 && streetScore.m_value > 0.72)) {
                closeMatch = false;
            }
        }
        scoringAddr.setCloseMatch(closeMatch);
        return closeMatch;
    }
}

