/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.THA.parser;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class THAParserUtils {
    public static final FieldType plotNumber = FieldType.GENERIC_FIELD_3_FIELD_TYPE;
    public static Set<Character.UnicodeBlock> THAICharset = new HashSet<Character.UnicodeBlock>();

    public static void separatePlotAndHouse(InputAddress inAddr, ParsedAddress pa) {
        List<AddressNumber> probHnrs = pa.getProbableAddressNumbers();
        ArrayList<AddressNumber> newList = new ArrayList<AddressNumber>(1);
        if (probHnrs != null && probHnrs.size() > 0) {
            boolean skip = false;
            AddressNumber hnr = probHnrs.get(0);
            int[] posOfWord = hnr.getPositionInInputStreet();
            AddressWord[] streetWords = (AddressWord[])pa.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (posOfWord[0] > 0 || streetWords.length > 3 && streetWords[1].getWord().charAt(0) == ',' && CodedWord.isNumber(streetWords[2].getAttributes())) {
                skip = true;
            }
            if (!skip) {
                int firstTypePos = -1;
                int idx = 0;
                int cntr = 0;
                for (AddressWord wd : streetWords) {
                    if (CodedWord.isThoroughfareTypeWord(wd.getAttributes())) {
                        firstTypePos = idx;
                        break;
                    }
                    if (CodedWord.isNumber(wd.getAttributes()) || CodedWord.isDelimiter(wd.getAttributes())) {
                        ++cntr;
                    }
                    ++idx;
                }
                boolean isOrdinal = false;
                String str = streetWords[0].getWord().trim().toUpperCase();
                if (str.endsWith("ND") || str.endsWith("TH") || str.endsWith("RD")) {
                    isOrdinal = true;
                }
                if (streetWords.length > 1 && !isOrdinal && posOfWord[0] == 0 && (firstTypePos == -1 || firstTypePos > -1 && idx - cntr < 4)) {
                    int[] posArray = new int[]{-1, -1};
                    boolean hnrSpaceSeparated = false;
                    if (CodedWord.isNumber(streetWords[1].getAttributes())) {
                        hnrSpaceSeparated = true;
                    }
                    if (!hnrSpaceSeparated && hnr.getHnrNumber2() == 0 && hnr.getHnrNumber1() > 0) {
                        posArray[0] = 0;
                        posArray[1] = 1;
                        hnr.setPositionInInputStreet(posArray);
                        newList.add(hnr);
                    } else if (hnr.getHnrNumber1() > 0 && (hnrSpaceSeparated || hnr.getHnrNumber2() != 0)) {
                        posArray[0] = 1;
                        posArray[1] = 2;
                        int hn = hnrSpaceSeparated ? probHnrs.get(1).getHnrNumber1() : hnr.getHnrNumber2();
                        AddressNumber num = new AddressNumber(hn);
                        num.setPositionInInputStreet(posArray);
                        newList.add(num);
                        pa.setField(plotNumber, new AddressWord[]{new AddressWord(String.valueOf(hnr.getHnrNumber1()))});
                    }
                }
            }
            if (newList.isEmpty()) {
                pa.setProbableAddressNumbers(null);
            } else {
                pa.setProbableAddressNumbers(newList);
            }
        }
    }

    public static boolean isThaiLetterOrDigit(char ch) {
        return THAICharset.contains(Character.UnicodeBlock.of(ch)) || Character.isLetterOrDigit(ch);
    }

    static {
        THAICharset.add(Character.UnicodeBlock.THAI);
        THAICharset = Collections.unmodifiableSet(THAICharset);
    }
}

