/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.TUR.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import java.util.List;

public class TURStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private byte m_subtryCount;
    private static double m_minStreetSearchQuality = 0.8;

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        boolean isSubTryValid = false;
        switch (this.m_subtryCount) {
            case 0: {
                this.m_subtryCount = (byte)(this.m_subtryCount + 1);
                isSubTryValid = super.generateStreetSubTries(dataManager, parsedAddress, options, candidateList);
                if (parsedAddress.isIntersectionCase()) break;
                AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, false, 12);
                List<DictionaryAddressWord> addressWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, m_minStreetSearchQuality, options);
                this.setAddressSearchWordList(addressWords);
                List<DictionaryAddressWord> searchWordList = this.filterSearchWords(addressWords, true, 1792);
                this.setSearchWordList(searchWordList);
                break;
            }
            default: {
                isSubTryValid = super.generateStreetSubTries(dataManager, parsedAddress, options, candidateList);
            }
        }
        return isSubTryValid;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean caseFlag = super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList);
        List<DictionaryAreaTermItem> areaList = null;
        if (!caseFlag && this.m_areaSubTryCount > 27 && this.m_pcAreaList == null) {
            switch (this.m_areaSubTryCount) {
                case 28: {
                    ++this.m_areaSubTryCount;
                    if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                    AddressWord[] lookUpAreaWords = null;
                    lookUpAreaWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.7, dataManager, options);
                    caseFlag = true;
                    break;
                }
                default: {
                    caseFlag = false;
                }
            }
        }
        if (areaList != null && areaList.size() > 0) {
            this.setSearchAreaList(areaList);
            caseFlag = true;
        }
        return caseFlag;
    }
}

