/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.TWN.helper;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;

public class TWNStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private ICGGESoundex m_soundex;
    private ICGGEParser m_parser;

    private ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            CGGEHandler handler = CGGEHandler.getInstance(null, this.getCountry(), this.getLanguage());
            this.m_soundex = handler.getSoundex();
        }
        return this.m_soundex;
    }

    private ICGGEParser getParser() {
        if (this.m_parser == null) {
            CGGEHandler handler = CGGEHandler.getInstance(null, this.getCountry(), this.getLanguage());
            this.m_parser = handler.getParser();
        }
        return this.m_parser;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, int includeMask) {
        int wordsLen;
        AddressWord[] retAddressWords = null;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 0) {
            if (wordsLen == 1) {
                retAddressWords = AddressWordArray.clone(words);
            } else {
                ICGGEParser parser = this.getParser();
                ICGGESoundex soundex = this.getSoundex();
                boolean containsTypeSeparator = false;
                ArrayList<AddressWord> filteredWordList = new ArrayList<AddressWord>(wordsLen);
                int typeCount = 0;
                for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                    AddressWord addrWord = words[wordNdx];
                    if (!CodedWord.isThoroughfareTypeWord(addrWord.getAttributes())) continue;
                    ++typeCount;
                }
                boolean filterTypes = typeCount < 4 && (includeMask & 0x200) != 512;
                boolean filterCommonWord = (includeMask & 0x100) != 256;
                boolean filterArticles = (includeMask & 0x400) != 1024;
                boolean filterNumbers = (includeMask & 4) != 4;
                boolean filterNumerics = (includeMask & 8) != 8;
                for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                    boolean isNormalWord;
                    AddressWord addrWord = words[wordNdx];
                    short wordAttribs = addrWord.getAttributes();
                    boolean filter = true;
                    if (CodedWord.isDelimiter(wordAttribs)) {
                        if (!"%".equals(addrWord.getWord())) continue;
                        containsTypeSeparator = true;
                        continue;
                    }
                    boolean bl = isNormalWord = !CodedWord.isNumber(wordAttribs) && !CodedWord.isNumeric(wordAttribs) && !CodedWord.isProbableRomanNumeral(wordAttribs) && !CodedWord.isThoroughfareTypeWord(wordAttribs) && !CodedWord.isArticleWord(wordAttribs) && !CodedWord.isCommonWord(wordAttribs) && !MMUtils.containsDigits(addrWord.getWordChars());
                    if (isNormalWord) {
                        if (includeNormalWords) {
                            filter = false;
                        }
                    } else {
                        if (!filterNumbers && CodedWord.isNumber(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterNumerics && (CodedWord.isNumeric(wordAttribs) || CodedWord.isProbableRomanNumeral(wordAttribs) || MMUtils.containsDigits(addrWord.getWordChars()))) {
                            filter = false;
                        }
                        if (!filterTypes && CodedWord.isThoroughfareTypeWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterArticles && CodedWord.isArticleWord(wordAttribs)) {
                            filter = false;
                        }
                        if (!filterCommonWord && CodedWord.isCommonWord(wordAttribs)) {
                            filter = false;
                        }
                    }
                    if (filter) continue;
                    filteredWordList.add(addrWord);
                }
                if (containsTypeSeparator) {
                    StringBuilder builder = new StringBuilder();
                    for (int searchWordNdx = 1; searchWordNdx < wordsLen - 1; ++searchWordNdx) {
                        AddressWord searchWord = words[searchWordNdx];
                        if (!CodedWord.isDelimiter(searchWord.getAttributes()) || !"%".equals(searchWord.getWord())) continue;
                        builder.append(words[searchWordNdx - 1].getWord());
                        builder.append(words[searchWordNdx + 1].getWord());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                    }
                }
                if (combineAlphaNumeric) {
                    StringBuilder builder = new StringBuilder();
                    for (int wordNdx = 1; wordNdx < wordsLen; ++wordNdx) {
                        AddressWord preWord;
                        AddressWord word = words[wordNdx];
                        if (!CodedWord.isNumber(word.getAttributes()) || CodedWord.isNumber((preWord = words[wordNdx - 1]).getAttributes()) || CodedWord.isDelimiter(preWord.getAttributes())) continue;
                        builder.append(preWord.getWordChars());
                        builder.append(word.getWordChars());
                        filteredWordList.add(parser.convertToAddressWord(builder.toString(), soundex));
                        builder.delete(0, builder.length());
                        ++wordNdx;
                    }
                }
                if (filteredWordList.size() > 0) {
                    retAddressWords = filteredWordList.toArray(new AddressWord[filteredWordList.size()]);
                }
            }
        }
        return retAddressWords;
    }
}

