/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGEIntersectionHelper;
import com.mapinfo.mapmarker.cgge.ICGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.ICGGEHandlerLoader;
import com.mapinfo.mapmarker.cgge.ICGGEIntersectionHelper;
import com.mapinfo.mapmarker.cgge.IDataSetComponent;
import com.mapinfo.mapmarker.cgge.ISettableCGGEHandler;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.helper.ICGGEGeocodingHelper;
import com.mapinfo.mapmarker.cgge.licensing.CGGELicenseException;
import com.mapinfo.mapmarker.cgge.licensing.CGGELicenseFactory;
import com.mapinfo.mapmarker.cgge.licensing.ICGGELicense;
import com.mapinfo.mapmarker.cgge.matcher.ICGGEMatcher;
import com.mapinfo.mapmarker.cgge.nearbystreethandler.INearByStreet;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.CGGELicenseUtil;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.PropertiesUtil;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Properties;

public class CGGEHandlerPropertiesLoader
implements ICGGEHandlerLoader {
    public static final String KEY_PARSER_CLASS = "parser_class";
    public static final String KEY_SCORER_CLASS = "scorer_class";
    public static final String KEY_SOUNDEX_CLASS = "soundex_class";
    public static final String KEY_MATCHER_CLASS = "matcher_class";
    public static final String KEY_STREET_GEOCODER_HELPER_CLASS = "street_helper_class";
    public static final String KEY_POSTAL_GEOCODER_HELPER_CLASS = "postal_helper_class";
    public static final String KEY_GEOGRAPHIC_GEOCODER_HELPER_CLASS = "geographic_helper_class";
    public static final String KEY_POI_HELPER_CLASS = "poi_helper_class";
    public static final String KEY_CANDIDATE_CONVERTOR_CLASS = "candidate_convertor_class";
    public static final String KEY_CANDIDATE_FILTER_CLASS = "candidate_filter_class";
    public static final String KEY_LICENSE_CLASS = "license_class";
    public static final String KEY_PREFER_POSTAL_FALLBACK = "prefer_postal_fallback";
    private static final String KEY_DEFAULT_LANGUAGE = "country_default_language";
    public static final String KEY_INTERSECTION_HELPER_CLASS = "intersection_helper_class";
    private static final String KEY_NEARBY_STREETHANDLER_CLASS = "nearby_streethandler_class";
    private String m_propertiesFileName;
    private DataSetInfo m_dataSetInfo;
    private static final String KEY_HANDLER_VERSION = "version";
    private static final int DEFAULT_HANDLER_VERSION = 1;

    public CGGEHandlerPropertiesLoader(DataSetInfo dataSetInfo, String propFileName) throws CGGEInternalException {
        if (StringUtilities.isEmpty((String)propFileName)) {
            throw new CGGEInternalException("Properties file name cannot be empty");
        }
        this.m_propertiesFileName = propFileName;
        this.m_dataSetInfo = dataSetInfo;
    }

    @Override
    public void init(String country, String language, ISettableCGGEHandler myHandler) throws CGGEInternalException {
        String defaultLang;
        Properties prop = CGGEResourceBundle.getBundle(this.m_propertiesFileName, language);
        String component = KEY_PARSER_CLASS;
        ClassLoader currentClassLoader = MMUtils.getCurrentClassLoader(prop.getProperty(component));
        try {
            ICGGEParser parser = (ICGGEParser)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            ((IDataSetComponent)((Object)parser)).setDataSetInfo(this.m_dataSetInfo);
            parser.init(country, language);
            myHandler.setParser(parser);
            component = KEY_SCORER_CLASS;
            ICGGEScorer scorer = (ICGGEScorer)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            scorer.init(country, language);
            myHandler.setScorer(scorer);
            component = KEY_SOUNDEX_CLASS;
            ICGGESoundex soundex = (ICGGESoundex)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            ((IDataSetComponent)((Object)soundex)).setDataSetInfo(this.m_dataSetInfo);
            soundex.init(country, language);
            myHandler.setSoundex(soundex);
            component = KEY_MATCHER_CLASS;
            ICGGEMatcher matcher = (ICGGEMatcher)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            ((IDataSetComponent)((Object)matcher)).setDataSetInfo(this.m_dataSetInfo);
            matcher.init(country, language);
            myHandler.setMatcher(matcher);
            component = KEY_CANDIDATE_CONVERTOR_CLASS;
            ICGGECandidateConvertor candidateConvertor = (ICGGECandidateConvertor)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            ((IDataSetComponent)((Object)candidateConvertor)).setDataSetInfo(this.m_dataSetInfo);
            candidateConvertor.init(country, language);
            myHandler.setCandidateConvertor(candidateConvertor);
            component = KEY_CANDIDATE_FILTER_CLASS;
            ICGGECandidateFilter candFilter = (ICGGECandidateFilter)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
            ((IDataSetComponent)((Object)candFilter)).setDataSetInfo(this.m_dataSetInfo);
            candFilter.init(country, language);
            myHandler.setCandidateFilter(candFilter);
            component = KEY_NEARBY_STREETHANDLER_CLASS;
            if (prop.getProperty(component) != null) {
                INearByStreet nearByStreetHandler = (INearByStreet)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
                myHandler.setNearByStreetHandle(nearByStreetHandler);
            }
        }
        catch (Exception e) {
            throw new CGGEInternalException("Error initializing component " + component, e);
        }
        String clz = null;
        try {
            ICGGEIntersectionHelper helper;
            component = KEY_STREET_GEOCODER_HELPER_CLASS;
            clz = prop.getProperty(component);
            if (clz != null) {
                myHandler.setStreetGeocodeHelperClass(this.getClass(clz));
            }
            if ((clz = prop.getProperty(component = KEY_POSTAL_GEOCODER_HELPER_CLASS)) != null) {
                myHandler.setPostalGeocodeHelperClass(this.getClass(clz));
            }
            if ((clz = prop.getProperty(component = KEY_GEOGRAPHIC_GEOCODER_HELPER_CLASS)) != null) {
                myHandler.setGeographicGeocodeHelperClass(this.getClass(clz));
            }
            if ((clz = prop.getProperty(component = KEY_POI_HELPER_CLASS)) != null) {
                myHandler.setPoiGeocoderHelperClass(this.getClass(clz));
            }
            if ((clz = prop.getProperty(component = KEY_INTERSECTION_HELPER_CLASS)) != null) {
                helper = (ICGGEIntersectionHelper)Class.forName(prop.getProperty(component), true, currentClassLoader).newInstance();
                helper.init(country, language);
                myHandler.setIntersectionHelper(helper);
            } else {
                helper = new CGGEIntersectionHelper();
                helper.init(country, language);
                myHandler.setIntersectionHelper(helper);
            }
        }
        catch (Exception e) {
            throw new CGGEInternalException("Error initialising helper class " + component + ": " + clz, e);
        }
        if (prop.containsKey(KEY_LICENSE_CLASS)) {
            try {
                ICGGELicense license = CGGELicenseFactory.getInstance().getLicense(prop.getProperty(KEY_LICENSE_CLASS));
                String[] licenseConfigs = CGGELicenseUtil.derivelicenseConfingNames(country);
                license.init(licenseConfigs[0], licenseConfigs[1], country);
                myHandler.setLicense(license);
            }
            catch (CGGELicenseException e) {
                throw new CGGEInternalException("Error initialising license class", (Throwable)((Object)e));
            }
        }
        if (prop.containsKey(KEY_PREFER_POSTAL_FALLBACK)) {
            myHandler.setPreferPostalFallback(Boolean.getBoolean(prop.getProperty(KEY_PREFER_POSTAL_FALLBACK, "true")));
        } else {
            myHandler.setPreferPostalFallback(true);
        }
        if (prop.containsKey(KEY_DEFAULT_LANGUAGE) && !StringUtilities.isEmpty((String)(defaultLang = prop.getProperty(KEY_DEFAULT_LANGUAGE)))) {
            myHandler.setCountryDefaultLanguage(defaultLang);
        }
        myHandler.setVersion(PropertiesUtil.getIntegerPropertyValue(prop, KEY_HANDLER_VERSION, 1));
    }

    private Class<ICGGEGeocodingHelper> getClass(String className) throws ClassNotFoundException {
        return Class.forName(className, true, MMUtils.getCurrentClassLoader(className));
    }
}

