/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.IDataSetComponent;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Enumeration;
import java.util.Properties;

public class DatasetInfoComponent
implements IDataSetComponent {
    private DataSetInfo dataSetInfo;

    @Override
    public DataSetInfo getDataSetInfo() {
        return this.dataSetInfo;
    }

    @Override
    public void setDataSetInfo(DataSetInfo datasetInfo) {
        this.dataSetInfo = datasetInfo;
    }

    protected Properties getConfiguration(String country, String language, String componentName) {
        String typeName = this.dataSetInfo == null ? null : MMUtils.getGeocodeTypeName(this.dataSetInfo.getGeocodeType());
        return this.getConfiguration(country, language, componentName, typeName);
    }

    protected Properties getConfiguration(String country, String language, String componentName, String typeName) {
        String dataSetName = this.dataSetInfo == null ? null : this.dataSetInfo.getName();
        return this.getConfiguration(country, language, componentName, typeName, dataSetName);
    }

    protected Properties getConfiguration(String country, String language, String componentName, String typeName, String dataSetName) {
        Properties prop;
        Properties props = null;
        try {
            props = CGGEResourceBundle.getBundle(country, componentName, dataSetName, language, typeName);
        }
        catch (CGGEInternalException e) {
            throw new CGGERuntimeException(e);
        }
        if (props == null) {
            props = new Properties();
        }
        if (null != this.dataSetInfo && this.dataSetInfo.getDataSetConfiguration() != null && (prop = this.dataSetInfo.getDataSetConfiguration()) != null) {
            Enumeration<?> e = prop.propertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.startsWith(componentName)) continue;
                String value = prop.getProperty(key);
                props.put(key.substring(key.indexOf(".") + 1), value);
            }
        }
        return props;
    }
}

