/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.cgge.CGGEGeocodeResult;
import com.mapinfo.mapmarker.cgge.CGGEGeocoder;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MM_DataGeographyInfo;
import com.mapinfo.mapmarker.cgge.MM_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.convertor.ICGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.IDataDictionary;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.licensing.CGGELicenseException;
import com.mapinfo.mapmarker.cgge.licensing.ICGGELicense;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.core.FatalHandlerException;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.custom.ICustomGeocoder;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class MMGeocoder
implements IGeocoder {
    private CGGEGeocoder m_geocoder;
    private Address m_inAddr;
    private CGGEGeocodeResult m_result;
    private IGeocodeConstraints m_constraints;
    protected static final String KEY_IS_POSTAL_GEOCODING = "key_is_postal_geocoding";
    private static String m_localStrings = "com.mapinfo.mapmarker.GeocodableAddressStrings";
    private ResourceBundle m_errorBundle;
    private String m_country;
    private ICGGELicense m_license;
    private boolean bPreferPostalFallback = true;
    static String WORLD_GEOCODER_COUNTRY_KEY = "XWG";

    public MMGeocoder(Address address, IGeocodeConstraints constraints) {
        this(address, address.getCountry(), constraints);
    }

    public MMGeocoder(Address address, String countryCode, IGeocodeConstraints constraints) {
        this.m_inAddr = address;
        this.m_country = countryCode;
        this.m_result = null;
        this.m_geocoder = null;
        this.m_constraints = constraints;
    }

    public void init() throws GeocodableAddressCreationException {
        try {
            this.m_geocoder = new CGGEGeocoder(this.m_country);
        }
        catch (CGGEInternalException eiOrigToThrow) {
            try {
                this.m_country = WORLD_GEOCODER_COUNTRY_KEY;
                this.m_geocoder = new CGGEGeocoder(this.m_country);
            }
            catch (CGGEInternalException eiDontThrowMe) {
                throw new GeocodableAddressCreationException(2306, (Throwable)eiOrigToThrow);
            }
        }
        try {
            this.m_license = CGGEHandler.getInstance(null, this.m_country, null).getLicense();
        }
        catch (CGGERuntimeException e) {
            throw new GeocodableAddressCreationException(2200);
        }
        try {
            this.bPreferPostalFallback = CGGEHandler.getInstance(null, this.m_country, null).getPreferPostalFallback();
        }
        catch (CGGERuntimeException cGGERuntimeException) {
            // empty catch block
        }
    }

    public CGGEGeocoder getCGGEGeocoder() {
        return this.m_geocoder;
    }

    private void checkGeocoder() throws FatalHandlerException {
        if (this.m_geocoder == null) {
            throw new FatalHandlerException(2500);
        }
        if (this.m_inAddr == null) {
            throw new FatalHandlerException(2500);
        }
    }

    public boolean preferPostalFallBack() {
        return true;
    }

    public CandidateAddress getIndexedCandidate(int candIndex, IConstraints preferences) throws MapMarkerInternalException {
        if (this.m_result != null && this.m_geocoder != null) {
            try {
                InternalScoringAddress internalAddr = this.m_geocoder.getIndexedCandidate(candIndex);
                CGGEHandler handler = CGGEHandler.getInstance(internalAddr.getDataSetInfo(), internalAddr.getCountry(), internalAddr.getLanguage());
                ICGGECandidateConvertor convertor = handler.getCandidateConvertor();
                GeocodeOptions options = new GeocodeOptions(preferences);
                CandidateAddress candAddr = convertor.covertCandidate(internalAddr, this.m_geocoder.getDataManager(), options);
                if (options.getProperty("DO_S3_FOR_THIS_CAND") != null) {
                    this.getPostalGeometry(options, candAddr);
                    options.remove("DO_S3_FOR_THIS_CAND");
                }
                return candAddr;
            }
            catch (Throwable t) {
                throw new MMGeneralGeocoderException(2308, t);
            }
        }
        return null;
    }

    protected void getPostalGeometry(GeocodeOptions options, CandidateAddress candAddr) throws Exception {
        CGGEGeocoder geocoder = new CGGEGeocoder(this.m_country);
        InputAddress newInput = new InputAddress(null, candAddr.getPostCode1());
        geocoder.setInputAddress(newInput);
        CGGEGeocodeResult result = geocoder.geocodePostal(options);
        int numCans = 0;
        if (result != null) {
            numCans = result.getNumberOfCandidates();
        }
        CandidateAddress postalCand = null;
        if (numCans > 0) {
            InternalScoringAddress internalAddr = geocoder.getIndexedCandidate(0);
            CGGEHandler handler = CGGEHandler.getInstance(internalAddr.getDataSetInfo(), internalAddr.getCountry(), internalAddr.getLanguage());
            ICGGECandidateConvertor convertor = handler.getCandidateConvertor();
            postalCand = convertor.covertCandidate(internalAddr, geocoder.getDataManager(), options);
        }
        if (postalCand == null || postalCand.getLocationPoint() == null) {
            candAddr.setLocationPrecision(0);
            candAddr.getAdditionalFields().put("RESULT_CODE", InternalCandidateAddress.buildPrecisionCodeFromCandidate((CandidateAddress)candAddr));
            return;
        }
        candAddr.setCoordSysString(postalCand.getCoordSysString());
        candAddr.setLocation(postalCand.getLocationPoint());
        if (Boolean.valueOf(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue()) {
            if (Boolean.valueOf(options.getProperty("DO_S3_FOR_THIS_CAND", "false")).booleanValue()) {
                candAddr.getAdditionalFields().put("RESULT_CODE", "B2");
            } else {
                candAddr.getAdditionalFields().put("RESULT_CODE", postalCand.getPrecisionCode());
            }
        }
    }

    public void setErrorBundle(ResourceBundle bundle) {
        this.m_errorBundle = bundle;
    }

    public IConstraints convertConstraints(IConstraints constraints) {
        return constraints;
    }

    public void prepareAndParse(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        constraints.setGeocodeType(geocodeType);
    }

    private GeocodeOptions createGeocodeOptionsWithDefaults(IConstraints constraints) {
        GeocodeOptions options = new GeocodeOptions(constraints);
        options.setPreferPostalFallback(this.bPreferPostalFallback);
        return options;
    }

    public GeocodeResult geocode(IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        this.checkGeocoder();
        this.checkSupportedType(0);
        this.isEngineLicensed();
        InputAddress inputAddr = this.getInputAddress(this.m_inAddr);
        this.m_geocoder.setInputAddress(inputAddr);
        GeocodeOptions options = this.createGeocodeOptionsWithDefaults(constraints);
        GeocodeResult geocodeResult = new GeocodeResult();
        geocodeResult.setDataAvailable(true);
        try {
            this.m_result = this.m_geocoder.geocode(options);
            if (this.m_result != null) {
                if (options.containsKey("S4_INPUT_HOUSE_NUMBER")) {
                    constraints.setCustomString("S4_INPUT_HOUSE_NUMBER", options.getProperty("S4_INPUT_HOUSE_NUMBER"));
                }
                geocodeResult = new GeocodeResult();
                geocodeResult.setDataAvailable(true);
                geocodeResult.setIntersectionStatus(false);
                geocodeResult.setNumberCandidates(this.m_result.getNumberOfCandidates());
                geocodeResult.setNumberCloseCandidates(this.m_result.getNumberOfCloseCandidates());
                geocodeResult.setParsedInput(this.m_result.getParsedInput());
                return geocodeResult;
            }
        }
        catch (CGGEInternalException ex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ex);
        }
        catch (IOException ioex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ioex);
        }
        catch (DataFetchException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        catch (DataNotInitialisedException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        return geocodeResult;
    }

    private void checkSupportedType(int geocodeType) throws MMGeneralGeocoderException {
        IDataManager dm = this.m_geocoder.getDataManager();
        int dictCount = dm.getDictionaryCount();
        int dataType = 0;
        switch (geocodeType) {
            case 0: {
                dataType = 1;
                break;
            }
            case 1: {
                dataType = 2;
                break;
            }
            case 4: {
                dataType = 3;
                break;
            }
            case 2: {
                dataType = 4;
                break;
            }
            default: {
                dataType = 0;
            }
        }
        boolean isGeocodeTypeSupported = this.checksupportedTypeinDictionaries(dm, dictCount, dataType);
        if (!isGeocodeTypeSupported && geocodeType == 0) {
            dataType = 4;
            isGeocodeTypeSupported = this.checksupportedTypeinDictionaries(dm, dictCount, dataType);
        }
        if (isGeocodeTypeSupported) {
            return;
        }
        if (geocodeType == 0 && WORLD_GEOCODER_COUNTRY_KEY.equalsIgnoreCase(this.m_country)) {
            return;
        }
        throw new MMGeneralGeocoderException(2307);
    }

    private boolean checksupportedTypeinDictionaries(IDataManager dm, int dictCount, int dataType) {
        for (int dictNdx = 0; dictNdx < dictCount; ++dictNdx) {
            if (!dm.doesDictionarySupportsGeocodeType(dictNdx + 1, dataType)) continue;
            return true;
        }
        return false;
    }

    private boolean isEngineLicensed() throws CGGELicenseException {
        return this.m_license != null ? this.m_license.isEngineLicensed() : true;
    }

    private InputAddress getInputAddress(Address inAddr) {
        InputAddress inputAddress = null;
        if (inAddr != null) {
            inputAddress = new InputAddress();
            inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, this.m_inAddr.getMainAddress());
            inputAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, this.m_inAddr.getPostAddress());
            inputAddress.setField(FieldType.POST_CODE_FIELD_TYPE, this.m_inAddr.getPostCode1());
            inputAddress.setField(FieldType.AREA_NAME_4_FIELD_TYPE, this.m_inAddr.getAreaName4());
            inputAddress.setField(FieldType.AREA_NAME_3_FIELD_TYPE, this.m_inAddr.getAreaName3());
            inputAddress.setField(FieldType.AREA_NAME_2_FIELD_TYPE, this.m_inAddr.getAreaName2());
            inputAddress.setField(FieldType.AREA_NAME_1_FIELD_TYPE, this.m_inAddr.getAreaName1());
            inputAddress.setField(FieldType.PLACE_NAME_FIELD_TYPE, this.m_inAddr.getPlaceName());
            inputAddress.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.m_inAddr.getGenericField1());
            inputAddress.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, this.m_inAddr.getGenericField2());
            inputAddress.setField(FieldType.GENERIC_FIELD_3_FIELD_TYPE, this.m_inAddr.getGenericField3());
            inputAddress.setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.m_inAddr.getGenericField4());
            inputAddress.setField(FieldType.COUNTRY_FIELD_TYPE, this.m_inAddr.getCountry());
            inputAddress.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, this.m_inAddr.getAddressNumber());
        }
        return inputAddress;
    }

    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        this.checkGeocoder();
        this.checkSupportedType(1);
        this.isEngineLicensed();
        InputAddress inputAddr = this.getInputAddress(this.m_inAddr);
        this.m_geocoder.setInputAddress(inputAddr);
        GeocodeOptions options = new GeocodeOptions(constraints);
        GeocodeResult geocodeResult = new GeocodeResult();
        geocodeResult.setDataAvailable(true);
        try {
            this.m_result = this.m_geocoder.geocodePostal(options);
            if (this.m_result != null) {
                geocodeResult = new GeocodeResult();
                geocodeResult.setDataAvailable(true);
                geocodeResult.setIntersectionStatus(false);
                geocodeResult.setNumberCandidates(this.m_result.getNumberOfCandidates());
                geocodeResult.setNumberCloseCandidates(this.m_result.getNumberOfCloseCandidates());
                return geocodeResult;
            }
        }
        catch (CGGEInternalException ex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ex);
        }
        catch (IOException ioex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ioex);
        }
        catch (DataFetchException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        catch (DataNotInitialisedException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        return geocodeResult;
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        this.checkGeocoder();
        this.checkSupportedType(4);
        this.isEngineLicensed();
        InputAddress inputAddr = this.getInputAddress(this.m_inAddr);
        this.m_geocoder.setInputAddress(inputAddr);
        GeocodeOptions options = new GeocodeOptions(constraints);
        GeocodeResult geocodeResult = new GeocodeResult();
        geocodeResult.setDataAvailable(true);
        try {
            this.m_result = this.m_geocoder.geocodeGeographic(options);
            if (this.m_result != null) {
                geocodeResult = new GeocodeResult();
                geocodeResult.setDataAvailable(true);
                geocodeResult.setIntersectionStatus(false);
                geocodeResult.setNumberCandidates(this.m_result.getNumberOfCandidates());
                geocodeResult.setNumberCloseCandidates(this.m_result.getNumberOfCloseCandidates());
                return geocodeResult;
            }
        }
        catch (CGGEInternalException ex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ex);
        }
        catch (IOException ioex) {
            throw new MMGeneralGeocoderException(2308, (Throwable)ioex);
        }
        catch (DataFetchException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        catch (DataNotInitialisedException e) {
            throw new MMGeneralGeocoderException(2308, (Throwable)e);
        }
        return geocodeResult;
    }

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(geocodeType, constraints);
        }
        if (!constraints.getHandler().isGeocodeCustomSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        ICustomGeocoder geo = constraints.getHandler().getCustomGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodeCustom(geocodeType, constraints);
    }

    public GeocodeResult standardize(IConstraints constraints) throws MapMarkerInternalException {
        throw new MMGeneralGeocoderException(2307);
    }

    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        throw new MMGeneralGeocoderException(2307);
    }

    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        return this.getIndexedCandidate(candIndex, preferences);
    }

    public ICountryGeographyInfo getCountryGeographyInfo() {
        IDataManager dm;
        CountryGeographyInfoImpl cgi = new CountryGeographyInfoImpl(this.m_country);
        if (this.m_geocoder != null && (dm = this.m_geocoder.getDataManager()) != null) {
            int dictCount = dm.getDictionaryCount();
            for (int dictNdx = 0; dictNdx < dictCount; ++dictNdx) {
                IDataDictionary dd = dm.getDictionaryAt(dictNdx);
                MM_DictionaryGeographyInfo dictGeoInfo = new MM_DictionaryGeographyInfo(this.m_country);
                dictGeoInfo.setDictionaryPath(dd.getDictionaryPath());
                dictGeoInfo.setDictionaryNumber(dd.getDictionaryNumber() + 1);
                List<Integer> geocodeTypes = dd.getSupportedGeocodeTypes();
                if (geocodeTypes != null) {
                    Iterator<Integer> typeIt = geocodeTypes.iterator();
                    while (typeIt.hasNext()) {
                        MM_DataGeographyInfo dataInfo = new MM_DataGeographyInfo(this.m_country, typeIt.next());
                        dictGeoInfo.addInfo(dataInfo);
                    }
                }
                dictGeoInfo.setIsUserDictionary(dd.isUserDictionary());
                cgi.addDictionaryGeographicInfo((IDictionaryGeographyInfo)dictGeoInfo);
            }
        }
        return cgi;
    }
}

