/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.IDataSetComponent;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.utils.parsedinput.GenericInputParserUtil;
import com.mapinfo.mapmarker.common.ParsedInputAddress;
import com.mapinfo.mapmarker.common.ParsedInputAddressUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.Set;

public class ParsedInputAddressBuilder {
    private final InputAddress inputAddress;
    private final String country;
    private final Set<ICGGEParser> parserSet;

    ParsedInputAddressBuilder(InputAddress inputAddress, String country, Set<ICGGEParser> parserSet) throws CGGEInternalException {
        this.inputAddress = inputAddress;
        this.country = country;
        if (parserSet == null || parserSet.isEmpty()) {
            throw new CGGEInternalException("ParsedInputAddressBuilder cannot be initialized without a valid parser.");
        }
        this.parserSet = parserSet;
    }

    ParsedInputAddress buildParsedInputAddress(InternalCandidateList candList) {
        return this.calculateParsedInputAddress(candList, false);
    }

    ParsedInputAddress buildParsedInputAddressForHNROnly(InternalCandidateList candList) {
        if (!candList.hasCandidates()) {
            return null;
        }
        return this.calculateParsedInputAddress(candList, true);
    }

    private ParsedInputAddress calculateParsedInputAddress(InternalCandidateList candList, boolean determineHNROnly) {
        ParsedInputAddress pia = this.calculatePIAFromCandidateList(candList, determineHNROnly);
        if (pia != null) {
            return pia;
        }
        ICGGEParser parser = this.getBestPossibleParser();
        CGGEHandler handler = CGGEHandler.getInstance(((IDataSetComponent)((Object)parser)).getDataSetInfo(), this.country, parser.getLanguage());
        ParsedAddress[] parsedAddressArray = parser.parse(this.inputAddress, handler.getScorer());
        GenericInputParserUtil util = new GenericInputParserUtil(parser, parsedAddressArray[0], handler.getCandidateConvertor().getLanguage(), parsedAddressArray[0].getProbableAddressNumbers(), determineHNROnly);
        return util.parseInputAddress(null, this.inputAddress);
    }

    private ParsedInputAddress calculatePIAFromCandidateList(InternalCandidateList candList, boolean determineHNROnly) {
        InternalScoringAddress cand = candList.hasCandidates() ? candList.getIndexedCandidate(0) : candList.getBestFetchedCandidate();
        return cand != null ? this.calculatePIAFromCandidate(cand, determineHNROnly) : null;
    }

    private ParsedInputAddress calculatePIAFromCandidate(InternalScoringAddress cand, boolean determineHNROnly) {
        CGGEHandler handler = CGGEHandler.getInstance(cand.getDataSetInfo(), this.country, cand.getLanguage());
        ParsedAddress parsedAddress = cand.getParsedAddress();
        GenericInputParserUtil util = new GenericInputParserUtil(handler.getParser(), parsedAddress, cand.getLanguage(), parsedAddress.getProbableAddressNumbers(), determineHNROnly);
        return util.parseInputAddress(cand, this.inputAddress);
    }

    protected ICGGEParser getBestPossibleParser() {
        ICGGEParser parser2 = null;
        ICGGEParser en_parser = null;
        boolean properParserFound = false;
        for (ICGGEParser parser2 : this.parserSet) {
            ICGGEThoroughfareTypeHandler thoroughFareTypeHandler;
            int[] startEnd;
            if ("en".equalsIgnoreCase(parser2.getLanguage())) {
                en_parser = parser2;
            }
            if ((startEnd = (thoroughFareTypeHandler = parser2.getThoroughfareTypeHandler()).findThoroughfareType((String)this.inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE))) == null) continue;
            properParserFound = true;
            break;
        }
        if (en_parser != null && !properParserFound) {
            parser2 = en_parser;
        }
        return parser2;
    }

    String getInputHNR(ParsedInputAddress parsedInputAddress) {
        boolean skip = false;
        String hn = parsedInputAddress.getAddressNumber();
        String mainaddr = parsedInputAddress.getMainAddress();
        if (hn != null) {
            String val;
            StringWithTokens toks1;
            int pos;
            String inMain = (String)this.inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            String inMainUpper = null;
            if (inMain != null) {
                inMainUpper = ParsedInputAddressUtils.upperCase((String)inMain);
            }
            boolean hnMoreThanOnceInMain = false;
            boolean hnInMainAddr = false;
            if (inMain != null) {
                boolean bl = hnMoreThanOnceInMain = inMain.trim().indexOf(hn) != inMain.trim().lastIndexOf(hn);
            }
            if (mainaddr != null) {
                hnInMainAddr = mainaddr.indexOf(hn) > -1;
            }
            StringBuilder srchstr = new StringBuilder(hn + " ");
            boolean specialCase1 = false;
            boolean specialCase2 = false;
            boolean specialCase3 = false;
            if (parsedInputAddress.getGenericField1() != null && parsedInputAddress.getGenericField1().startsWith(".") && mainaddr != null && mainaddr.indexOf(" ") > 0 && mainaddr.startsWith(srchstr.toString())) {
                specialCase1 = true;
            }
            if (!specialCase1 && mainaddr != null && mainaddr.contains(srchstr.toString()) && (pos = (toks1 = new StringWithTokens(mainaddr)).getFirstToken().indexOf(hn)) > 0 && (val = toks1.getFirstToken().substring(pos, toks1.getFirstToken().length())).equals(hn)) {
                specialCase2 = true;
            }
            if (!specialCase1 && !specialCase2 && inMainUpper != null && inMainUpper.contains("BOX ")) {
                StringWithTokens toks = new StringWithTokens(inMainUpper);
                for (int i = 0; i < toks.size(); ++i) {
                    String tok = toks.getToken(i);
                    if (!tok.equals("BOX") || i + 1 >= toks.size() || !StringUtilities.isNumeric((String)toks.getToken(i + 1))) continue;
                    specialCase3 = true;
                }
            }
            if (mainaddr != null && inMain != null && hnInMainAddr && !hnMoreThanOnceInMain || specialCase1 || specialCase2 || specialCase3) {
                skip = true;
            }
            hn = StringUtilities.removePunctuationCharsFromStart((String)hn);
        }
        return hn != null && !skip ? hn : null;
    }
}

