/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class AreaTerm
implements Comparable<AreaTerm> {
    public static final int BINARY_SIZE = 6;
    protected int m_offset;
    protected FieldType m_termType;
    protected AddressWord[] m_areaWords;
    protected AreaTerm[] m_altTerms;

    public int getOffset() {
        return this.m_offset;
    }

    public FieldType getTermType() {
        return this.m_termType;
    }

    public AreaTerm[] getAlternateTerms() {
        return this.m_altTerms;
    }

    public void setAlternateTerms(AreaTerm[] altTerms) {
        this.m_altTerms = altTerms;
    }

    public void setOffset(int i) {
        this.m_offset = i;
    }

    public void setTermType(FieldType t) {
        this.m_termType = t;
    }

    public static AreaTerm read(ByteBuffer buf, IDictionaryMetaData metaData) {
        FieldType fieldType;
        AreaTerm term = new AreaTerm();
        term.m_offset = buf.getInt();
        short typeValue = buf.getShort();
        term.m_termType = fieldType = metaData.getFieldType(typeValue);
        return term;
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.m_offset);
        out.writeShort(this.m_termType.getKey());
    }

    public String toString() {
        return "" + this.m_offset + '-' + this.m_termType + " ";
    }

    public boolean equals(Object obj) {
        return obj instanceof AreaTerm ? this.compareTo((AreaTerm)obj) == 0 : false;
    }

    public int hashCode() {
        int value = 17;
        value = 31 * value + this.m_offset;
        value = 31 * value + (this.m_termType == null ? 0 : this.m_termType.getKey());
        value = 31 * value + (this.m_altTerms == null ? 0 : Arrays.hashCode(this.m_altTerms));
        return value;
    }

    @Override
    public int compareTo(AreaTerm other) {
        int altCount2;
        int altCount1;
        if (this == other) {
            return 0;
        }
        int comp = this.m_offset - other.m_offset;
        if (comp == 0 && (comp = this.m_termType.compare(this.m_termType, other.m_termType)) == 0 && (comp = (altCount1 = this.m_altTerms == null ? 0 : this.m_altTerms.length) - (altCount2 = other.m_altTerms == null ? 0 : other.m_altTerms.length)) == 0 && altCount1 > 0) {
            for (int altNdx = 0; altNdx < altCount1 && (comp = this.m_altTerms[altNdx].compareTo(other.m_altTerms[altNdx])) == 0; ++altNdx) {
            }
        }
        return comp;
    }

    public AddressWord[] getAreaWords() {
        return this.m_areaWords;
    }

    public void setAreaWords(AddressWord[] words) {
        this.m_areaWords = words;
    }
}

