/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldType
implements Comparator<FieldType>,
Comparable<FieldType> {
    public static final int MAX_ID_SUPPORTED = 255;
    public static final int CUSTOM_ID_START = 29;
    public static final int CUSTOM_ID_END = 200;
    public static boolean useHashCodeKludge;
    public static final int KEY_UNKNOWN = 0;
    public static final int KEY_UNIT_PLACE_NAME = 1;
    public static final int KEY_UNIT_INFO = 2;
    public static final int KEY_RANGE_PLACE_NAME = 3;
    public static final int KEY_ADDRESS_NUMBER = 4;
    public static final int KEY_ADDRESS_NUMBER_FROM = 5;
    public static final int KEY_ADDRESS_NUMBER_TO = 6;
    public static final int KEY_PLACE_NAME = 7;
    public static final int KEY_STREET_NAME = 8;
    public static final int KEY_PRE_ADDRESS = 9;
    public static final int KEY_POST_ADDRESS = 10;
    public static final int KEY_PRE_DIRECTIONAL = 11;
    public static final int KEY_POST_DIRECTIONAL = 12;
    public static final int KEY_PRE_THOROUGHFARE = 13;
    public static final int KEY_POST_THOROUGHFARE = 14;
    public static final int KEY_POST_CODE = 15;
    public static final int KEY_AREA_NAME_1 = 16;
    public static final int KEY_AREA_NAME_2 = 17;
    public static final int KEY_AREA_NAME_3 = 18;
    public static final int KEY_AREA_NAME_4 = 19;
    public static final int KEY_GENERIC_FIELD_1 = 24;
    public static final int KEY_GENERIC_FIELD_2 = 25;
    public static final int KEY_GENERIC_FIELD_3 = 26;
    public static final int KEY_GENERIC_FIELD_4 = 27;
    public static final int KEY_COUNTRY = 28;
    public static final int KEY_POST_CODE_EX = 201;
    public static final int KEY_RANK = 202;
    private int m_hashCode;
    private int m_key;
    private FieldLevel m_level;
    private String m_fieldName;
    private static final String UNKNOWN_PLACE_NAME_FIELD = "unknown";
    private static final String UNIT_PLACE_NAME_FIELD = "unit_place_name";
    private static final String UNIT_INFO_FIELD = "unit_info";
    private static final String RANGE_PLACE_NAME_FIELD = "range_place_name";
    private static final String ADDRESS_NUMBER_FIELD = "address_number";
    private static final String ADDRESS_NUMBER_FROM_FIELD = "address_number_from";
    private static final String ADDRESS_NUMBER_TO_FIELD = "address_number_to";
    private static final String PLACE_NAME_FIELD = "place_name";
    private static final String STREET_NAME_FIELD = "street_name";
    private static final String PRE_ADDRESS_FIELD = "pre_address";
    private static final String POST_ADDRESS_FIELD = "post_address";
    private static final String PRE_DIRECTIONAL_FIELD = "pre_directional";
    private static final String POST_DIRECTIONAL_FIELD = "post_directional";
    private static final String PRE_THOROUGHFARE_FIELD = "pre_thoroughfare";
    private static final String POST_THOROUGHFARE_FIELD = "post_thoroughfare";
    private static final String AREA_NAME_1_FIELD = "area_name_1";
    private static final String AREA_NAME_2_FIELD = "area_name_2";
    private static final String AREA_NAME_3_FIELD = "area_name_3";
    private static final String AREA_NAME_4_FIELD = "area_name_4";
    private static final String GENERIC_FIELD_1_FIELD = "generic_field_1";
    private static final String GENERIC_FIELD_2_FIELD = "generic_field_2";
    private static final String GENERIC_FIELD_3_FIELD = "generic_field_3";
    private static final String GENERIC_FIELD_4_FIELD = "generic_field_4";
    private static final String POST_CODE_FIELD = "post_code";
    private static final String POST_CODE_EX_FIELD = "post_code_ex";
    private static final String COUNTRY_FIELD = "country";
    private static final String RANK_FIELD = "rank";
    public static final FieldType UNKNOWN_FIELD_TYPE;
    public static final FieldType UNIT_PLACE_NAME_FIELD_TYPE;
    public static final FieldType UNIT_INFO_FIELD_TYPE;
    public static final FieldType RANGE_PLACE_NAME_FIELD_TYPE;
    public static final FieldType ADDRESS_NUMBER_FIELD_TYPE;
    public static final FieldType ADDRESS_NUMBER_FROM_FIELD_TYPE;
    public static final FieldType ADDRESS_NUMBER_TO_FIELD_TYPE;
    public static final FieldType PLACE_NAME_FIELD_TYPE;
    public static final FieldType STREET_NAME_FIELD_TYPE;
    public static final FieldType PRE_ADDRESS_FIELD_TYPE;
    public static final FieldType POST_ADDRESS_FIELD_TYPE;
    public static final FieldType PRE_DIRECTIONAL_FIELD_TYPE;
    public static final FieldType POST_DIRECTIONAL_FIELD_TYPE;
    public static final FieldType PRE_THOROUGHFARE_FIELD_TYPE;
    public static final FieldType POST_THOROUGHFARE_FIELD_TYPE;
    public static final FieldType AREA_NAME_1_FIELD_TYPE;
    public static final FieldType AREA_NAME_2_FIELD_TYPE;
    public static final FieldType AREA_NAME_3_FIELD_TYPE;
    public static final FieldType AREA_NAME_4_FIELD_TYPE;
    public static final FieldType GENERIC_FIELD_1_FIELD_TYPE;
    public static final FieldType GENERIC_FIELD_2_FIELD_TYPE;
    public static final FieldType GENERIC_FIELD_3_FIELD_TYPE;
    public static final FieldType GENERIC_FIELD_4_FIELD_TYPE;
    public static final FieldType POST_CODE_FIELD_TYPE;
    public static final FieldType POST_CODE_EX_FIELD_TYPE;
    public static final FieldType COUNTRY_FIELD_TYPE;
    public static final FieldType RANK_FIELD_TYPE;
    private static ArrayList<FieldType> m_predefinedTypes;
    private static Map<Integer, FieldType> definedFields;

    private void computeHashCode() {
        this.m_hashCode = 7;
        this.m_hashCode = 31 * this.m_hashCode + this.m_key;
        if (useHashCodeKludge) {
            this.m_hashCode ^= this.m_hashCode >>> 12 ^ this.m_hashCode >>> 7 ^ this.m_hashCode >>> 4;
        }
    }

    public FieldType(int key, FieldLevel level, String fieldName) {
        if (fieldName == null || fieldName.trim().length() == 0) {
            throw new IllegalArgumentException("Field name cannot be empty or null");
        }
        this.m_key = key;
        this.m_level = level;
        this.m_fieldName = fieldName;
        this.computeHashCode();
    }

    public static FieldType[] getPredefinedFieldTypes() {
        FieldType[] types = new FieldType[m_predefinedTypes.size()];
        m_predefinedTypes.toArray(types);
        return types;
    }

    public static List<FieldType> getPredefinedFieldTypes(FieldLevel level) {
        ArrayList<FieldType> retList = null;
        if (m_predefinedTypes != null) {
            Iterator<FieldType> it = m_predefinedTypes.iterator();
            retList = new ArrayList<FieldType>(m_predefinedTypes.size() / 2);
            while (it.hasNext()) {
                FieldType type = it.next();
                if (type.m_level != level) continue;
                retList.add(type);
            }
        }
        if (retList != null && retList.size() > 0) {
            return retList;
        }
        return null;
    }

    public int getKey() {
        return this.m_key;
    }

    public FieldLevel getLevel() {
        return this.m_level;
    }

    public String getName() {
        return this.m_fieldName;
    }

    public static String getPredefinedName(int typeIndex) {
        String name = UNKNOWN_PLACE_NAME_FIELD;
        for (FieldType ft : m_predefinedTypes) {
            if (ft.m_key != typeIndex) continue;
            name = ft.m_fieldName;
            break;
        }
        return name;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    @Override
    public boolean equals(Object fieldType) {
        boolean isEqual = false;
        FieldType temp = (FieldType)fieldType;
        boolean bl = isEqual = this.m_key == temp.m_key;
        if (!isEqual) {
            return isEqual;
        }
        boolean bl2 = isEqual = this.m_level == temp.m_level;
        if (!isEqual) {
            return isEqual;
        }
        return this.m_fieldName.equals(temp.m_fieldName);
    }

    @Override
    public int compare(FieldType f1, FieldType f2) {
        if (f1 == f2) {
            return 0;
        }
        return f1.getKey() - f2.getKey();
    }

    public String toString() {
        return this.m_fieldName;
    }

    public static boolean isPredefinedType(FieldType type) {
        return Collections.binarySearch(m_predefinedTypes, type, UNKNOWN_FIELD_TYPE) > -1;
    }

    public static boolean isPredefinedType(int typeID) {
        return definedFields.keySet().contains(typeID);
    }

    public static FieldType getPredefinedField(int typeID) {
        return definedFields.get(typeID);
    }

    @Override
    public int compareTo(FieldType f) {
        return this == f ? 0 : this.getKey() - f.getKey();
    }

    public String getExternalName() {
        return FieldType.getExternalName(this.m_fieldName);
    }

    public static String getExternalName(String name) {
        if (name == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(name);
        sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        Pattern p = Pattern.compile("(_\\w)");
        Matcher m = p.matcher(sb);
        ArrayList<Integer> delList = new ArrayList<Integer>();
        while (m.find()) {
            String group = m.group();
            sb.setCharAt(m.start() + 1, Character.toUpperCase(group.charAt(1)));
            delList.add(m.start());
        }
        Collections.reverse(delList);
        Iterator iterator = delList.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            sb.deleteCharAt(i);
        }
        return sb.toString();
    }

    static {
        try {
            Double v = Double.parseDouble(System.getProperty("java.version").substring(0, 3));
            useHashCodeKludge = v > 1.7;
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_predefinedTypes = new ArrayList();
        definedFields = new HashMap<Integer, FieldType>();
        UNKNOWN_FIELD_TYPE = new FieldType(0, FieldLevel.LEVEL_UNKNOWN, UNKNOWN_PLACE_NAME_FIELD);
        UNIT_PLACE_NAME_FIELD_TYPE = new FieldType(1, FieldLevel.LEVEL_UNIT, UNIT_PLACE_NAME_FIELD);
        UNIT_INFO_FIELD_TYPE = new FieldType(2, FieldLevel.LEVEL_UNIT, UNIT_INFO_FIELD);
        RANGE_PLACE_NAME_FIELD_TYPE = new FieldType(3, FieldLevel.LEVEL_RANGE, RANGE_PLACE_NAME_FIELD);
        ADDRESS_NUMBER_FIELD_TYPE = new FieldType(4, FieldLevel.LEVEL_RANGE, ADDRESS_NUMBER_FIELD);
        ADDRESS_NUMBER_FROM_FIELD_TYPE = new FieldType(5, FieldLevel.LEVEL_RANGE, ADDRESS_NUMBER_FROM_FIELD);
        ADDRESS_NUMBER_TO_FIELD_TYPE = new FieldType(6, FieldLevel.LEVEL_RANGE, ADDRESS_NUMBER_TO_FIELD);
        PLACE_NAME_FIELD_TYPE = new FieldType(7, FieldLevel.LEVEL_STREET, PLACE_NAME_FIELD);
        STREET_NAME_FIELD_TYPE = new FieldType(8, FieldLevel.LEVEL_STREET, STREET_NAME_FIELD);
        PRE_ADDRESS_FIELD_TYPE = new FieldType(9, FieldLevel.LEVEL_STREET, PRE_ADDRESS_FIELD);
        POST_ADDRESS_FIELD_TYPE = new FieldType(10, FieldLevel.LEVEL_STREET, POST_ADDRESS_FIELD);
        PRE_DIRECTIONAL_FIELD_TYPE = new FieldType(11, FieldLevel.LEVEL_STREET, PRE_DIRECTIONAL_FIELD);
        POST_DIRECTIONAL_FIELD_TYPE = new FieldType(12, FieldLevel.LEVEL_STREET, POST_DIRECTIONAL_FIELD);
        PRE_THOROUGHFARE_FIELD_TYPE = new FieldType(13, FieldLevel.LEVEL_STREET, PRE_THOROUGHFARE_FIELD);
        POST_THOROUGHFARE_FIELD_TYPE = new FieldType(14, FieldLevel.LEVEL_STREET, POST_THOROUGHFARE_FIELD);
        POST_CODE_FIELD_TYPE = new FieldType(15, FieldLevel.LEVEL_POSTAL, POST_CODE_FIELD);
        POST_CODE_EX_FIELD_TYPE = new FieldType(201, FieldLevel.LEVEL_POSTAL, POST_CODE_EX_FIELD);
        AREA_NAME_1_FIELD_TYPE = new FieldType(16, FieldLevel.LEVEL_POSTAL, AREA_NAME_1_FIELD);
        AREA_NAME_2_FIELD_TYPE = new FieldType(17, FieldLevel.LEVEL_POSTAL, AREA_NAME_2_FIELD);
        AREA_NAME_3_FIELD_TYPE = new FieldType(18, FieldLevel.LEVEL_POSTAL, AREA_NAME_3_FIELD);
        AREA_NAME_4_FIELD_TYPE = new FieldType(19, FieldLevel.LEVEL_POSTAL, AREA_NAME_4_FIELD);
        GENERIC_FIELD_1_FIELD_TYPE = new FieldType(24, FieldLevel.LEVEL_POSTAL, GENERIC_FIELD_1_FIELD);
        GENERIC_FIELD_2_FIELD_TYPE = new FieldType(25, FieldLevel.LEVEL_POSTAL, GENERIC_FIELD_2_FIELD);
        GENERIC_FIELD_3_FIELD_TYPE = new FieldType(26, FieldLevel.LEVEL_POSTAL, GENERIC_FIELD_3_FIELD);
        GENERIC_FIELD_4_FIELD_TYPE = new FieldType(27, FieldLevel.LEVEL_POSTAL, GENERIC_FIELD_4_FIELD);
        COUNTRY_FIELD_TYPE = new FieldType(28, FieldLevel.LEVEL_POSTAL, COUNTRY_FIELD);
        RANK_FIELD_TYPE = new FieldType(202, FieldLevel.LEVEL_POSTAL, RANK_FIELD);
        m_predefinedTypes.add(UNKNOWN_FIELD_TYPE);
        m_predefinedTypes.add(UNIT_PLACE_NAME_FIELD_TYPE);
        m_predefinedTypes.add(UNIT_INFO_FIELD_TYPE);
        m_predefinedTypes.add(RANGE_PLACE_NAME_FIELD_TYPE);
        m_predefinedTypes.add(ADDRESS_NUMBER_FIELD_TYPE);
        m_predefinedTypes.add(ADDRESS_NUMBER_FROM_FIELD_TYPE);
        m_predefinedTypes.add(ADDRESS_NUMBER_TO_FIELD_TYPE);
        m_predefinedTypes.add(PLACE_NAME_FIELD_TYPE);
        m_predefinedTypes.add(STREET_NAME_FIELD_TYPE);
        m_predefinedTypes.add(PRE_ADDRESS_FIELD_TYPE);
        m_predefinedTypes.add(POST_ADDRESS_FIELD_TYPE);
        m_predefinedTypes.add(PRE_DIRECTIONAL_FIELD_TYPE);
        m_predefinedTypes.add(POST_DIRECTIONAL_FIELD_TYPE);
        m_predefinedTypes.add(PRE_THOROUGHFARE_FIELD_TYPE);
        m_predefinedTypes.add(POST_THOROUGHFARE_FIELD_TYPE);
        m_predefinedTypes.add(POST_CODE_FIELD_TYPE);
        m_predefinedTypes.add(POST_CODE_EX_FIELD_TYPE);
        m_predefinedTypes.add(AREA_NAME_1_FIELD_TYPE);
        m_predefinedTypes.add(AREA_NAME_2_FIELD_TYPE);
        m_predefinedTypes.add(AREA_NAME_3_FIELD_TYPE);
        m_predefinedTypes.add(AREA_NAME_4_FIELD_TYPE);
        m_predefinedTypes.add(GENERIC_FIELD_1_FIELD_TYPE);
        m_predefinedTypes.add(GENERIC_FIELD_2_FIELD_TYPE);
        m_predefinedTypes.add(GENERIC_FIELD_3_FIELD_TYPE);
        m_predefinedTypes.add(GENERIC_FIELD_4_FIELD_TYPE);
        m_predefinedTypes.add(COUNTRY_FIELD_TYPE);
        m_predefinedTypes.add(RANK_FIELD_TYPE);
        m_predefinedTypes.trimToSize();
        Collections.sort(m_predefinedTypes, UNKNOWN_FIELD_TYPE);
        for (FieldType type : m_predefinedTypes) {
            definedFields.put(type.getKey(), type);
        }
    }

    public static enum FieldLevel {
        LEVEL_UNKNOWN(0),
        LEVEL_UNIT(1),
        LEVEL_RANGE(2),
        LEVEL_STREET(3),
        LEVEL_POSTAL(4);

        private int levelValue;

        private FieldLevel(int value) {
            this.levelValue = value;
        }

        public int getLevelAsInt() {
            return this.levelValue;
        }

        public static FieldLevel getLevelAsEnum(int level) {
            FieldLevel level_value = null;
            switch (level) {
                case 0: {
                    level_value = LEVEL_UNKNOWN;
                    break;
                }
                case 1: {
                    level_value = LEVEL_UNIT;
                    break;
                }
                case 2: {
                    level_value = LEVEL_RANGE;
                    break;
                }
                case 3: {
                    level_value = LEVEL_STREET;
                    break;
                }
                case 4: {
                    level_value = LEVEL_POSTAL;
                }
            }
            return level_value;
        }
    }
}

