/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalScoringAddress
extends ScoringItem {
    private InternalScoringRange[] m_ranges;
    private double m_combinedPostalScore;
    private double m_combinedStreetScore;
    private int m_dictionaryUsagePriority;
    private List<AddressWord> m_searchWords;
    private InternalScoringAddress secondaryStreetAddress;
    private ParsedAddress parsedAddress;
    private boolean m_ignoreRangeLevel;
    private Map<String, Object> m_additionalInfoMap = Collections.emptyMap();
    private boolean S3CheckedStatus;
    private boolean S3;
    private boolean S8;
    private int adjustedEndValForHnr;

    public InternalScoringAddress getSecondaryStreetAddress() {
        return this.secondaryStreetAddress;
    }

    public void setSecondaryStreetAddress(InternalScoringAddress secondaryStreetAddress) {
        this.secondaryStreetAddress = secondaryStreetAddress;
    }

    protected InternalScoringAddress() {
    }

    public InternalScoringAddress(InternalStreetAddress address) {
        this.copy(address);
        this.setInternalAddress(address);
        int rangeCount = address.getRangeCount();
        if (rangeCount > 0) {
            this.m_ranges = new InternalScoringRange[rangeCount];
            List<InternalRangeAddress> internalRangeList = address.getRangeList();
            for (int i = 0; i < rangeCount; ++i) {
                this.m_ranges[i] = new InternalScoringRange(internalRangeList.get(i));
            }
        }
    }

    public int getDictionaryUsagePriority() {
        return this.m_dictionaryUsagePriority;
    }

    public void setDictionaryUsagePriority(int priority) {
        this.m_dictionaryUsagePriority = priority;
    }

    public int getAddressType() {
        return this.getInternalAddress().getAddressType();
    }

    public int getRangeCount() {
        return this.m_ranges == null ? 0 : this.m_ranges.length;
    }

    public InternalScoringRange getRangeAt(int ndx) {
        if (ndx < 0 || ndx >= this.getRangeCount()) {
            throw new IndexOutOfBoundsException("Range count is " + this.getRangeCount());
        }
        return this.m_ranges[ndx];
    }

    public InternalScoringRange[] getRanges() {
        return this.m_ranges;
    }

    public void setRanges(InternalScoringRange[] ranges) {
        this.m_ranges = ranges;
    }

    public InternalScoringRange getMatchedRange() {
        InternalScoringRange range;
        if (this.getRangeCount() > 0 && (range = this.getRangeAt(0)).isCloseMatch()) {
            return range;
        }
        return null;
    }

    public void setCombinedPostalScore(double score) {
        this.m_combinedPostalScore = score;
    }

    public double getCombinedPostalScore() {
        return this.m_combinedPostalScore;
    }

    public void setCombinedStreetScore(double score) {
        this.m_combinedStreetScore = score;
    }

    public double getCombinedStreetScore() {
        return this.m_combinedStreetScore;
    }

    public InternalStreetAddress getInternalStreetAddress() {
        return (InternalStreetAddress)this.getInternalAddress();
    }

    public String getCountry() {
        InternalStreetAddress internalAddress = (InternalStreetAddress)this.getInternalAddress();
        return internalAddress == null ? null : internalAddress.getCountry();
    }

    public String getLanguage() {
        InternalStreetAddress internalAddress = (InternalStreetAddress)this.getInternalAddress();
        return internalAddress == null ? null : internalAddress.getLanguage();
    }

    public int getDictionaryNumber() {
        return this.getInternalAddress().getDictionaryNumber();
    }

    public long getAdditionalFieldsOffset() {
        AdditionalFields addFields;
        InternalStreetAddress internalAddress = (InternalStreetAddress)this.getInternalAddress();
        if (internalAddress != null && (addFields = internalAddress.getAdditionalFields()) != null) {
            return addFields.getOffset();
        }
        return -1L;
    }

    public void addSearchWord(AddressWord word) {
        if (this.m_searchWords == null) {
            this.m_searchWords = new ArrayList<AddressWord>(5);
        }
        this.m_searchWords.add(word);
    }

    public List<AddressWord> getSearchWords() {
        return this.m_searchWords;
    }

    public void setParsedAddress(ParsedAddress pAddr) {
        this.parsedAddress = pAddr;
    }

    public ParsedAddress getParsedAddress() {
        return this.parsedAddress;
    }

    public void setIsS3(boolean flag) {
        this.S3 = flag;
    }

    public boolean isS3() {
        return this.S3;
    }

    public void setS3CheckedStatus(boolean flag) {
        this.S3CheckedStatus = flag;
    }

    public boolean getS3CheckedStatus() {
        return this.S3CheckedStatus;
    }

    public void setIsS8(boolean flag) {
        this.S8 = flag;
    }

    public boolean isS8() {
        return this.S8;
    }

    public void setAdjustedEndValForHnr(int val) {
        this.adjustedEndValForHnr = val;
    }

    public int getAdjustedEndValForHnr() {
        return this.adjustedEndValForHnr;
    }

    @Override
    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append(lineSeparator);
        builder.append(lineSeparator);
        builder.append(this.getClass().getSimpleName());
        builder.append(lineSeparator);
        builder.append("internalAddress: ");
        builder.append(this.getInternalAddress() == null ? "none" : this.getInternalAddress());
        builder.append(lineSeparator);
        builder.append("searchWords: ");
        if (this.getSearchWords() != null) {
            for (AddressWord word : this.getSearchWords()) {
                builder.append(word.toString());
                builder.append(lineSeparator);
            }
        } else {
            builder.append("none");
            builder.append(lineSeparator);
        }
        return builder.toString();
    }

    public boolean getIgnoreRangeLevel() {
        return this.m_ignoreRangeLevel;
    }

    public void setIgnoreRangeLevel(boolean flag) {
        this.m_ignoreRangeLevel = flag;
    }

    public void setAdditionalInfo(String key, Object info) {
        if (this.m_additionalInfoMap == Collections.EMPTY_MAP) {
            this.m_additionalInfoMap = new HashMap<String, Object>();
        }
        this.m_additionalInfoMap.put(key, info);
    }

    public <T> T getAdditionalInfo(String key) {
        return (T)this.m_additionalInfoMap.get(key);
    }
}

