/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import java.util.Arrays;
import java.util.Comparator;

public final class UnitInfo
implements Comparator {
    public static final short TYPE_NONE = -1;
    private static final int MASK_HAS_UNIT_NUMBER = 3;
    private static final int MASK_HAS_UNIT_TYPE = 4;
    private static final int MASK_HAS_UNIT_POBOX = 8;
    private static final int MASK_HAS_SUFFIX = 16;
    private static final int MASK_HAS_UNIT_PREFIX = 32;
    private static final int MASK_HAS_UNIT_PREFIX_NUMERIC = 64;
    private static final int MASK_IS_MASK = 128;
    private static final double PREFIX_WORD_WEIGHT = 0.15;
    private static final double PREFIX_NUMERIC_WEIGHT = 0.3;
    private static final double TYPE_WEIGHT = 0.15;
    private static final double NUMBER_WEIGHT = 0.35;
    private static final double SUFFIX_WEIGHT = 0.05;
    private int[] m_poBoxBytes;
    private AddressNumber m_unitNumber;
    private int m_prefixWordIndex;
    private int m_prefixNumeric;
    private short m_unitType;
    private String m_unitSuffix;
    private int[] m_positionInInputAdd;

    public UnitInfo() {
        this.m_unitNumber = null;
        this.m_unitType = (short)-1;
        this.m_prefixWordIndex = -1;
        this.m_unitSuffix = null;
    }

    public UnitInfo(int prefixWordIndex, int prefixNumeric, short unitType, AddressNumber unitNumber, String unitSuffix) {
        this.m_prefixWordIndex = prefixWordIndex;
        this.m_prefixNumeric = prefixNumeric;
        this.m_unitType = unitType;
        this.m_unitNumber = unitNumber;
        this.m_unitSuffix = unitSuffix;
    }

    public AddressNumber getUnitNumber() {
        return this.m_unitNumber;
    }

    public void setUnitNumber(AddressNumber n) {
        this.m_unitNumber = n;
    }

    public boolean isSimpleAddressNumber() {
        return this.m_unitType == -1 && this.m_prefixNumeric < 1 && this.m_prefixWordIndex < 0 && this.m_unitSuffix == null;
    }

    public boolean hasSuffix() {
        return this.m_unitSuffix != null;
    }

    public boolean hasPrefix() {
        return this.m_prefixNumeric > 0 || this.m_prefixWordIndex > -1;
    }

    public boolean isPOBoxPresent() {
        return this.m_poBoxBytes != null;
    }

    public double score(UnitInfo that, ICGGEScorer scorer) {
        return 0.0;
    }

    public short getUnitType() {
        return this.m_unitType;
    }

    public void setUnitType(short type) {
        this.m_unitType = type;
    }

    public String getUnitInfoString(ICGGEParser parser) {
        StringBuffer buf = new StringBuffer(15);
        if (this.m_prefixNumeric > 0) {
            int lastDigit = this.m_prefixNumeric % 10;
            buf.append(this.m_prefixNumeric);
            switch (lastDigit) {
                case 1: {
                    buf.append("st");
                    break;
                }
                case 2: {
                    buf.append("nd");
                    break;
                }
                case 3: {
                    buf.append("rd");
                    break;
                }
                default: {
                    buf.append("th");
                }
            }
            buf.append(' ');
        }
        if (this.m_prefixWordIndex > -1) {
            buf.append(parser.getParserTerms().getUnitPrefixWord(this.m_prefixWordIndex));
            buf.append(' ');
        }
        String unitTypeWord = null;
        if (this.m_unitType >= 0) {
            unitTypeWord = parser.getParserTerms().getUnitWord(this.m_unitType);
        }
        if (unitTypeWord != null) {
            buf.append(unitTypeWord);
            buf.append(' ');
        }
        if (this.m_unitNumber != null) {
            buf.append(this.m_unitNumber.toString());
        }
        if (this.m_unitSuffix != null) {
            if (buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
            }
            buf.append(this.m_unitSuffix);
        }
        return buf.toString();
    }

    public String getPoBox() {
        if (this.m_poBoxBytes != null) {
            byte[] bytes = new byte[this.m_poBoxBytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                bytes[i] = (byte)this.m_poBoxBytes[i];
            }
            return new String(bytes);
        }
        return null;
    }

    public void setPoBox(String poBox) {
        if (poBox != null) {
            this.m_poBoxBytes = new int[poBox.length()];
            for (int i = 0; i < this.m_poBoxBytes.length; ++i) {
                this.m_poBoxBytes[i] = (byte)poBox.charAt(i);
            }
        } else {
            this.m_poBoxBytes = null;
        }
    }

    public int compare(Object o1, Object o2) {
        UnitInfo u1 = (UnitInfo)o1;
        UnitInfo u2 = (UnitInfo)o2;
        int diff = u1.m_unitType - u2.m_unitType;
        if (diff == 0) {
            if (u1.m_unitNumber != null && u2.m_unitNumber != null) {
                diff = u1.m_unitNumber.compare(u1.m_unitNumber, u2.m_unitNumber);
            } else {
                if (u1.m_unitNumber != null) {
                    return 1;
                }
                if (u2.m_unitNumber != null) {
                    return -1;
                }
            }
            if (diff == 0 && (diff = u1.m_prefixNumeric - u2.m_prefixNumeric) == 0 && (diff = u1.m_prefixWordIndex - u2.m_prefixWordIndex) == 0) {
                if (u1.m_unitSuffix != null && u2.m_unitSuffix != null) {
                    diff = u1.m_unitSuffix.compareTo(u2.m_unitSuffix);
                } else {
                    if (u1.m_unitSuffix != null) {
                        return 1;
                    }
                    if (u2.m_unitSuffix != null) {
                        return -1;
                    }
                }
                if (u1.m_poBoxBytes != null && u2.m_poBoxBytes != null) {
                    diff = u1.m_poBoxBytes.length - u2.m_poBoxBytes.length;
                    if (diff == 0) {
                        for (int i = 0; i < u1.m_poBoxBytes.length; ++i) {
                            diff = u1.m_poBoxBytes[i] - u2.m_poBoxBytes[i];
                            if (diff == 0) continue;
                            return diff;
                        }
                    }
                } else {
                    if (u1.m_poBoxBytes != null) {
                        return 1;
                    }
                    if (u2.m_poBoxBytes != null) {
                        return -1;
                    }
                }
            }
        }
        return diff;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof UnitInfo)) {
            return false;
        }
        return this.compare(this, obj) == 0;
    }

    public int hashCode() {
        int value = 17;
        value = 31 * value + this.m_unitType;
        value = 31 * value + (this.m_unitNumber == null ? 0 : this.m_unitNumber.hashCode());
        value = 31 * value + this.m_prefixNumeric;
        value = 31 * value + this.m_prefixWordIndex;
        value = 31 * value + (this.m_unitSuffix == null ? 0 : this.m_unitSuffix.hashCode());
        value = 31 * value + (this.m_poBoxBytes == null ? 0 : Arrays.hashCode(this.m_poBoxBytes));
        return value;
    }

    public int getPrefixWordIndex() {
        return this.m_prefixWordIndex;
    }

    public void setPrefixWordIndex(int prefixWordIndex) {
        this.m_prefixWordIndex = prefixWordIndex;
    }

    public int getPrefixNumeric() {
        return this.m_prefixNumeric;
    }

    public void setPrefixNumeric(int prefixNumeric) {
        this.m_prefixNumeric = prefixNumeric;
    }

    public int[] getPositionInInputStreet() {
        return this.m_positionInInputAdd;
    }

    public void setPositionInInputStreet(int[] pos) {
        this.m_positionInInputAdd = pos;
    }
}

