/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.address;

import com.mapinfo.mapmarker.cgge.address.AddressWord;

public class WordAlternate {
    private AddressWord m_altWord;
    private AddressWord[] m_altWords;
    private ALT_TYPE m_type;

    public WordAlternate(AddressWord altWord, ALT_TYPE type) {
        if (altWord == null) {
            throw new NullPointerException("Alternate word cannot be null");
        }
        if (type == ALT_TYPE.MULTI_WORD_ABBREVIATION) {
            throw new IllegalArgumentException("Type cannot be Multi Word Abbreviation");
        }
        this.m_altWord = altWord;
        this.m_type = type;
    }

    public WordAlternate(AddressWord[] altWords) {
        if (altWords == null) {
            throw new NullPointerException("Alternate word cannot be null");
        }
        this.m_altWords = altWords;
        this.m_type = ALT_TYPE.MULTI_WORD_ABBREVIATION;
    }

    public AddressWord getAltWord() {
        if (this.m_type != ALT_TYPE.MULTI_WORD_ABBREVIATION) {
            return this.m_altWord;
        }
        return null;
    }

    public AddressWord[] getAltWords() {
        if (this.m_type == ALT_TYPE.MULTI_WORD_ABBREVIATION) {
            return this.m_altWords;
        }
        return null;
    }

    public ALT_TYPE getAltType() {
        return this.m_type;
    }

    public static enum ALT_TYPE {
        SINGLE_WORD_ABBREVIATION,
        MULTI_WORD_ABBREVIATION,
        TYPE_NUMER,
        THOROUGHFARE_TYPE;

    }
}

