/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.dp.AddressHandle;
import com.mapinfo.mapmarker.cgge.dp.AddressTableLookup;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.AreaNameDictionary;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataVersionInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler;
import com.mapinfo.mapmarker.cgge.dp.WordDictionary;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AddressDictionary {
    private WordDictionary m_wordDictionary = null;
    private final AddressTableLookup m_addressLookupTable;
    private AreaNameDictionary m_areaDictionary;
    private ICGGEDataStream m_additionalFileStream;
    private Properties m_dataSetConfiguration;
    private InternalAddressIOHandler m_addrIOHandler;

    AddressDictionary(AddressTableLookup addrTableLookup) {
        this.m_addressLookupTable = addrTableLookup;
    }

    static AddressDictionary getAddressDictionaryInstance(String dataPath) throws Exception {
        AddressTableLookup addressTableLookup = AddressTableLookup.getInstance(dataPath + ".adi");
        IDictionaryMetaData metadata = addressTableLookup.getMetaData();
        AddressDictionary addrDictionary = null;
        addrDictionary = new AddressDictionary(addressTableLookup);
        addrDictionary.loadCustomConfigurations(metadata, dataPath);
        return addrDictionary;
    }

    public IDictionaryMetaData getMetaData() {
        return this.m_addressLookupTable.getMetaData();
    }

    public InternalAddressIOHandler getAdressIOHander() {
        return this.m_addrIOHandler;
    }

    void loadCustomConfigurations(IDictionaryMetaData metadata, String dataPath) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        File file;
        if (metadata.isUserDictionary() && (file = new File(dataPath + ".cnf")).exists()) {
            this.m_dataSetConfiguration = new Properties();
            this.m_dataSetConfiguration.load(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
        }
    }

    protected boolean loadDictionary(String dataName, CGGEHandler handler) throws Exception {
        this.loadWordDictionary(handler, dataName);
        this.loadAreaNameDictionary(handler, dataName);
        this.loadMainDictionary(handler, dataName);
        this.initAddressIOHandler(dataName);
        return true;
    }

    private void loadAreaNameDictionary(CGGEHandler handler, String dataName) throws CGGEDataIntializationException, Exception {
        this.m_areaDictionary = new AreaNameDictionary();
        if (!this.m_areaDictionary.loadDictionary(dataName, this.getWordDictionary(), handler, this.getMetaData())) {
            throw new CGGEDataIntializationException("Error loading Area Name Dictionary");
        }
    }

    void loadWordDictionary(CGGEHandler handler, String dataPath) throws Exception {
        this.m_wordDictionary = new WordDictionary();
        this.m_wordDictionary.loadDictionary(dataPath + ".adw", handler);
    }

    void loadMainDictionary(CGGEHandler handler, String dataPath) throws Exception {
        this.m_addressLookupTable.loadMainAddressTable(dataPath + ".adr");
        try {
            this.m_additionalFileStream = DataStreamFactory.getDataStream(dataPath + ".afs");
        }
        catch (FileNotFoundException e) {
            this.m_additionalFileStream = null;
        }
    }

    private void initAddressIOHandler(String dataName) throws Exception {
        this.m_addrIOHandler = InternalAddressIOHandler.getInstance(this.getMetaData().getVersion());
    }

    void setAddressIOHandler(InternalAddressIOHandler ioHandler) {
        this.m_addrIOHandler = ioHandler;
    }

    protected List<AddressWord> getMatchingWords(AddressWord addrWord, ICGGEScorer scorer, double minQuality) throws DataNotInitialisedException {
        List<AddressWord> tempWords = this.m_wordDictionary.getMatchingWords(addrWord, scorer, minQuality);
        return tempWords != null && tempWords.size() > 0 ? tempWords : null;
    }

    public final AddressHandle findAddressHandleForSAC(int sac) throws CGGEInternalException {
        AddressHandle handle = this.m_addressLookupTable.getAddressHandleForSAC(sac, this);
        return handle;
    }

    public final CodedWord getCodedWord(long wordCode) throws DataNotInitialisedException {
        return this.m_wordDictionary.getCodedWord(wordCode);
    }

    public final DataVersionInfo getDataVersionInfo() {
        return this.m_addressLookupTable.getDataVersionInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void readAdditionalFields(InternalAddress addr) throws IOException {
        long fileOffset;
        AdditionalFields additionalFields;
        ICGGEDataStream dataStream = this.getAdditionalFileStream();
        if (dataStream != null && (additionalFields = addr.getAdditionalFields()) != null && (fileOffset = additionalFields.getOffset()) > -1L) {
            fileOffset = this.adjustOffset(additionalFields.getOffset(), addr.getAreaMetaData());
            Map<FieldType, String> addFieldMap = null;
            ICGGEDataStream iCGGEDataStream = dataStream;
            synchronized (iCGGEDataStream) {
                dataStream.seek(fileOffset);
                addFieldMap = this.getAdressIOHander().readAdditionalFields((DataInput)dataStream, this.getMetaData());
            }
            additionalFields.addAdditionalFields(addFieldMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DirectPosition> getGeometry(InternalAddress internalAddress) throws IOException {
        long coordOffset;
        ICGGEDataStream dataStream = this.getAdditionalFileStream();
        if (dataStream != null && (coordOffset = internalAddress.getCoordinateOffset()) > -1L) {
            AreaMetaData areaMetaData = internalAddress.getAreaMetaData();
            coordOffset = this.adjustOffset(coordOffset, areaMetaData);
            ICGGEDataStream iCGGEDataStream = dataStream;
            synchronized (iCGGEDataStream) {
                dataStream.seek(coordOffset);
                return this.getAdressIOHander().readGeometry(dataStream, areaMetaData);
            }
        }
        return null;
    }

    ICGGEDataStream getAdditionalFileStream() {
        return this.m_additionalFileStream;
    }

    private long adjustOffset(long offset, AreaMetaData areaMetaData) {
        return areaMetaData.getFileOffsetAdjust() + offset;
    }

    public final WordDictionary getWordDictionary() {
        return this.m_wordDictionary;
    }

    protected AddressTableLookup getAddressLookupTable() {
        return this.m_addressLookupTable;
    }

    public AreaNameDictionary getAreaNameDictionary() {
        return this.m_areaDictionary;
    }

    public Properties getDataSetConfiguration() {
        return this.m_dataSetConfiguration;
    }
}

