/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.AreaTerm;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.dp.AddressDictionary;
import com.mapinfo.mapmarker.cgge.dp.AddressHandleWords;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.AreaNameDictionary;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.ISAFileIndexEntry;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AddressHandle {
    private int m_size;
    private IntArray m_sacs;
    private boolean m_addressDataPartOfHandle;
    private ISAFileIndexEntry m_indexEntry;
    private AddressHandleWords m_handleWords;
    private long m_areaTermStartPosition;
    private long m_addressStartPosition;
    private AreaTerm[] m_areaTerms;
    private InternalStreetAddress[] m_addresses;
    private long[] m_addressOffsets;
    private AddressDictionary m_addressDictionary;
    private AreaNameDictionary m_areaNameDictionary;
    private RandomAccessFile m_file;
    private ByteBuffer m_byteBuffer;
    private ByteBuffer m_addressByteBuffer;
    private ByteBuffer m_offsetByteBuffer;
    private ByteBuffer m_areaTermByteBuffer;
    private IDictionaryMetaData m_metData;
    private AreaMetaData m_areaMetaData;
    private int m_dictNdx;
    private static final Object m_lock = new Object();

    public AddressHandle(ISAFileIndexEntry indexEntry, IDictionaryMetaData metaData) {
        this.m_indexEntry = indexEntry;
        this.m_metData = metaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void read(RandomAccessFile file) throws CGGEInternalException {
        this.m_file = file;
        if (this.m_indexEntry == null) {
            throw new CGGEInternalException("Index invalid or not set");
        }
        long dataOffset = this.m_indexEntry.getDataOffset();
        this.m_size = (int)this.m_indexEntry.getDataSize();
        this.m_sacs = this.m_indexEntry.getSacs();
        try {
            this.m_byteBuffer = null;
            Object object = m_lock;
            synchronized (object) {
                file.seek(dataOffset);
                this.readAreaMetaData(file);
                int bytesUsed = (int)(file.getFilePointer() - dataOffset);
                this.m_byteBuffer = ByteBuffer.allocate(this.m_size - bytesUsed);
                file.getChannel().read(this.m_byteBuffer);
                dataOffset += (long)bytesUsed;
            }
            this.m_byteBuffer.rewind();
            int numberOfAddressOffsets = this.m_byteBuffer.getInt();
            this.m_handleWords = new AddressHandleWords(this.m_metData);
            this.m_handleWords.setAddressCount(numberOfAddressOffsets);
            this.m_byteBuffer.position((int)(this.m_indexEntry.getCodedWordsStartOffset() - dataOffset));
            this.m_handleWords.read(this.m_byteBuffer);
            this.m_byteBuffer.position((int)(this.m_indexEntry.getAreaTermsStartOffset() - dataOffset));
            int numberOfAreaTerms = this.m_byteBuffer.getInt();
            this.m_areaTerms = new AreaTerm[numberOfAreaTerms];
            this.m_areaTermStartPosition = this.m_byteBuffer.position();
            long addressOffsetStartsOffset = this.m_indexEntry.getAddressOffsetsStartOffset();
            this.m_byteBuffer.position((int)(addressOffsetStartsOffset - dataOffset));
            long fileAddressStartPosition = addressOffsetStartsOffset;
            if (numberOfAddressOffsets > 0) {
                this.m_addressOffsets = new long[numberOfAddressOffsets];
                this.m_offsetByteBuffer = this.m_byteBuffer.slice();
                fileAddressStartPosition += (long)(numberOfAddressOffsets * 4);
            }
            this.m_addressDataPartOfHandle = this.m_byteBuffer.get() == 1;
            ++fileAddressStartPosition;
            this.m_addressStartPosition = this.m_byteBuffer.position();
            this.m_byteBuffer.rewind();
            this.m_byteBuffer.position((int)this.m_areaTermStartPosition);
            this.m_areaTermByteBuffer = this.m_byteBuffer.slice();
            if (this.m_addressDataPartOfHandle) {
                this.m_byteBuffer.position((int)this.m_addressStartPosition);
                this.m_addressByteBuffer = this.m_byteBuffer.slice();
            }
            this.m_addressStartPosition = fileAddressStartPosition;
            this.m_addresses = new InternalStreetAddress[numberOfAddressOffsets];
        }
        catch (Exception e) {
            throw new CGGEInternalException(e);
        }
    }

    private void readAreaMetaData(DataInput in) throws IOException {
        AreaMetaData areaMetaData = this.getAddressDictionary().getAdressIOHander().readAreaMetaData(this.m_metData, in);
        if (areaMetaData == InternalAddressIOHandler.EMPTY_AREA_META_DATA) {
            areaMetaData = new AreaMetaData();
            areaMetaData.setCoordDecimalPrecision(this.m_metData.getCoordDecimalPrecision());
        }
        this.m_areaMetaData = areaMetaData;
    }

    private final CodedWord getCodedWordAt(int ndx) throws DataNotInitialisedException {
        long wordCode = this.m_handleWords.getWordCodeAt(ndx);
        return this.m_addressDictionary.getCodedWord(wordCode);
    }

    private final AreaTerm getAreaTermAt(int ndx) throws DataNotInitialisedException {
        AreaTerm term = this.m_areaTerms[ndx];
        if (term == null) {
            this.m_areaTermByteBuffer.position(ndx * 6);
            term = AreaTerm.read(this.m_areaTermByteBuffer, this.m_metData);
            term.setAreaWords(this.m_areaNameDictionary.getAreaWords(term.getOffset()));
            this.m_areaTerms[ndx] = term;
        }
        return term;
    }

    private final void setProperCodedWordsFromNdxs(Address<InternalFieldValue> address, ICGGEParser parser, ICGGESoundex soundex) throws DataNotInitialisedException {
        Collection<InternalFieldValue> addrWordList = address.getFields().values();
        if (addrWordList != null) {
            for (InternalFieldValue fv : addrWordList) {
                this.convertWordNdxToAddressWord((AddressWord[])fv.getFieldValue(), parser, soundex);
                AddressWord[][] altWords = (AddressWord[][])fv.getAlternateValues();
                int altCount = altWords == null ? 0 : altWords.length;
                for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                    this.convertWordNdxToAddressWord(altWords[altNdx], parser, soundex);
                }
            }
        }
    }

    private final void convertWordNdxToAddressWord(AddressWord[] addrWords, ICGGEParser parser, ICGGESoundex soundex) throws DataNotInitialisedException {
        int wordSize = addrWords == null ? 0 : addrWords.length;
        for (int i = 0; i < wordSize; ++i) {
            AddressWord word = addrWords[i];
            int wordNdx = (Integer)word.getData();
            CodedWord codedWord = this.getCodedWordAt(wordNdx);
            word.setCodedWord(codedWord);
            word.setData(null);
            parser.assignAlternateWord(word, soundex);
        }
    }

    private final void setProperAreaFieldFromNdxs(InternalStreetAddress address) throws DataNotInitialisedException {
        List<Integer> termNdxList = address.getAreaTermIndexes();
        if (termNdxList != null) {
            int areaSize = termNdxList.size();
            AreaTerm curTerm = null;
            ArrayList<AreaTerm> altTerms = null;
            for (int termNdx = 0; termNdx < areaSize; ++termNdx) {
                AreaTerm term = this.getAreaTermAt(termNdxList.get(termNdx));
                termNdxList.set(termNdx, term.getOffset());
                if (term.getTermType().getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                if (curTerm != null && curTerm.getTermType() == term.getTermType()) {
                    if (altTerms == null) {
                        altTerms = new ArrayList<AreaTerm>(5);
                    }
                    altTerms.add(term);
                    continue;
                }
                if (curTerm != null) {
                    int altCount;
                    InternalFieldValue fv = new InternalFieldValue(curTerm.getAreaWords());
                    address.setField(curTerm.getTermType(), fv);
                    int n = altCount = altTerms == null ? 0 : altTerms.size();
                    if (altCount > 0) {
                        AddressWord[][] altWords = new AddressWord[altCount][];
                        for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                            altWords[altNdx] = ((AreaTerm)altTerms.get(altNdx)).getAreaWords();
                        }
                        fv.setAlternateValues((T[])altWords);
                        altTerms.clear();
                    }
                }
                curTerm = term;
            }
            if (curTerm != null) {
                InternalFieldValue fv = new InternalFieldValue(curTerm.getAreaWords());
                address.setField(curTerm.getTermType(), fv);
                int altCount = altTerms == null ? 0 : altTerms.size();
                AddressWord[][] altWords = new AddressWord[altCount][];
                for (int altNdx = 0; altNdx < altCount; ++altNdx) {
                    altWords[altNdx] = ((AreaTerm)altTerms.get(altNdx)).getAreaWords();
                }
                fv.setAlternateValues((T[])altWords);
            }
        }
    }

    private long getAddressOffset(int addrNdx) {
        if (this.m_addressOffsets[addrNdx] == 0L) {
            this.m_offsetByteBuffer.position(addrNdx * 4);
            this.m_addressOffsets[addrNdx] = this.m_indexEntry.getAddressOffsetsStartOffset() + (long)this.m_offsetByteBuffer.getInt();
        }
        return this.m_addressOffsets[addrNdx];
    }

    protected final InternalStreetAddress getAddressAtIndex(int ndx, ICGGEParser parser, ICGGESoundex soundex, DataSetInfo dataSetInfo) throws CGGEInternalException {
        InternalStreetAddress address = this.m_addresses[ndx];
        try {
            if (address == null) {
                ICGGEDataInput dataInput = this.getAddressDataInput(ndx);
                this.m_addresses[ndx] = address = this.readAddress(dataInput, dataSetInfo, this.getAddressOffset(ndx), parser, soundex);
            }
        }
        catch (Exception e) {
            throw new CGGEInternalException(e);
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICGGEDataInput getAddressDataInput(int ndx) throws IOException {
        long addressOffset = this.getAddressOffset(ndx);
        int size = (int)((ndx < this.m_addressOffsets.length - 1 ? this.getAddressOffset(ndx + 1) : this.m_indexEntry.getHandleAddressEndOffset()) - addressOffset);
        byte[] dataBytes = new byte[size];
        if (this.m_addressDataPartOfHandle) {
            this.m_addressByteBuffer.get(dataBytes, (int)(addressOffset - this.m_addressStartPosition), size).array();
        } else {
            Object object = m_lock;
            synchronized (object) {
                this.m_file.seek(addressOffset);
                this.m_file.read(dataBytes);
            }
        }
        return DataStreamFactory.getInputDataStream(dataBytes);
    }

    private InternalStreetAddress readAddress(ICGGEDataInput addressBuffer, DataSetInfo dataSetInfo, long offset, ICGGEParser parser, ICGGESoundex soundex) throws IOException, DataNotInitialisedException {
        InternalStreetAddress address = new InternalStreetAddress();
        InternalAddressIOHandler addrIOHander = this.getAddressDictionary().getAdressIOHander();
        addrIOHander.read(address, addressBuffer, this.m_metData);
        address.setOffset(offset);
        address.setDataSetInfo(dataSetInfo);
        this.setProperCodedWordsFromNdxs(address, parser, soundex);
        this.setProperAreaFieldFromNdxs(address);
        List<InternalRangeAddress> rangeList = address.getRangeList();
        int rangeListSize = rangeList == null ? 0 : rangeList.size();
        for (int j = 0; j < rangeListSize; ++j) {
            InternalRangeAddress range = rangeList.get(j);
            range.setDataSetInfo(dataSetInfo);
            range.setAreaMetaData(this.m_areaMetaData);
            this.setProperCodedWordsFromNdxs(range, parser, soundex);
            List<InternalUnitAddress> unitList = range.getUnits();
            int unitListSize = unitList == null ? 0 : unitList.size();
            for (int k = 0; k < unitListSize; ++k) {
                InternalUnitAddress unit = unitList.get(k);
                unit.setDataSetInfo(dataSetInfo);
                unit.setAreaMetaData(this.m_areaMetaData);
                this.setProperCodedWordsFromNdxs(unit, parser, soundex);
            }
        }
        address.setCountry(this.m_metData.getCountry());
        address.setLanguage(this.m_metData.getLanguage());
        address.setAreaMetaData(this.m_areaMetaData);
        return address;
    }

    public AddressDictionary getAddressDictionary() {
        return this.m_addressDictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalStreetAddress getAddressAtOffset(long addressStartOffset, int addressSize, ICGGEParser parser, ICGGESoundex soundex, DataSetInfo dataSetInfo) throws CGGEInternalException {
        try {
            byte[] bytes = new byte[addressSize];
            Object object = m_lock;
            synchronized (object) {
                this.m_file.seek(addressStartOffset);
                this.m_file.read(bytes);
            }
            return this.readAddress(DataStreamFactory.getInputDataStream(bytes), dataSetInfo, addressStartOffset, parser, soundex);
        }
        catch (Exception e) {
            throw new CGGEInternalException(e);
        }
    }

    protected final int[] findAddressIndexesFromWords(AddressWord word) throws CGGEInternalException, IOException {
        long wordCode = word.getCodedWord().getWordCode();
        IntArray addressNdxs = this.m_handleWords.getAddressOffsets(word.m_wordType, wordCode);
        if (addressNdxs != null) {
            return addressNdxs.asArray();
        }
        return null;
    }

    public IntArray getSacs() {
        return this.m_sacs;
    }

    public void setSacs(IntArray sacs) {
        this.m_sacs = sacs;
    }

    public void setAddressDictionary(AddressDictionary dictionary) {
        this.m_addressDictionary = dictionary;
    }

    public AreaNameDictionary getAreaNameDictionary() {
        return this.m_areaNameDictionary;
    }

    public void setAreaNameDictionary(AreaNameDictionary dictionary) {
        this.m_areaNameDictionary = dictionary;
    }

    public long getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
    }

    public String getCountry() {
        return this.m_metData.getLanguage();
    }

    public void setDictionary(int dict) {
        this.m_dictNdx = dict;
    }

    public int getDictionary() {
        return this.m_dictNdx;
    }
}

