/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.IOUtil;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.DummyDataOutput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class AddressHandleWords {
    private WordToFieldTypeList m_wordToTypeItems = new WordToFieldTypeList(100);
    private Comparator<WordToFieldType> m_comparator = new WordToFieldType(-1L);
    private ByteBuffer m_buf;
    private int m_startOffset;
    private int m_addressCount;
    private boolean m_isReading;
    private IDictionaryMetaData m_metaData;
    public boolean m_useLongWordCodes;

    public AddressHandleWords(IDictionaryMetaData metaData) {
        this.m_metaData = metaData;
        String str = metaData.getAdditionalInfo("has_big_word_dictionary");
        this.setUseLongWordCodes(str != null && "true".equals(str));
    }

    protected void setUseLongWordCodes(boolean b) {
        this.m_useLongWordCodes = b;
    }

    protected boolean getUseLongWordCodes() {
        return this.m_useLongWordCodes;
    }

    public void read(ByteBuffer buf) {
        this.m_isReading = true;
        this.m_buf = buf;
        this.m_startOffset = buf.position();
        int size = this.m_buf.getInt();
        this.m_wordToTypeItems = new WordToFieldTypeList(size);
    }

    private boolean isReading() {
        return this.m_isReading;
    }

    public void setAddressCount(int count) {
        this.m_addressCount = count;
    }

    public int getAddressCount() {
        return this.m_addressCount;
    }

    public int getWordCount() {
        return this.m_wordToTypeItems != null ? this.m_wordToTypeItems.size() : 0;
    }

    public long getWordCodeAt(int ndx) {
        return this.m_wordToTypeItems != null ? this.m_wordToTypeItems.get((int)ndx).m_wordCode : -1L;
    }

    public int getWordCodeIndex(long wordCode) {
        WordToFieldType searchItem = new WordToFieldType(wordCode);
        int ndx = Collections.binarySearch(this.m_wordToTypeItems, searchItem, this.m_comparator);
        return ndx;
    }

    public void write(DataOutput out) throws IOException {
        WordToFieldType typeItem;
        int i;
        int size = this.m_wordToTypeItems == null ? 0 : this.m_wordToTypeItems.size();
        this.m_startOffset = 0;
        out.writeInt(size);
        this.m_startOffset += 4;
        this.m_startOffset += size * (this.m_useLongWordCodes ? 12 : 8);
        DummyDataOutput dummyOut = new DummyDataOutput();
        dummyOut.setOffset(this.m_startOffset);
        for (i = 0; i < size; ++i) {
            typeItem = this.m_wordToTypeItems.get(i);
            if (this.m_useLongWordCodes) {
                out.writeLong(typeItem.m_wordCode);
            } else {
                out.writeInt((int)typeItem.m_wordCode);
            }
            out.writeInt(dummyOut.getOffset());
            this.writeTypeAndOffsets(typeItem, dummyOut);
        }
        for (i = 0; i < size; ++i) {
            typeItem = this.m_wordToTypeItems.get(i);
            this.writeTypeAndOffsets(typeItem, out);
        }
    }

    public void addWordCode(long wordCode, FieldType type, int addressOffset) {
        WordToFieldType item = null;
        WordToFieldType searchItem = new WordToFieldType(wordCode);
        int ndx = Collections.binarySearch(this.m_wordToTypeItems, searchItem, this.m_comparator);
        if (ndx < 0) {
            ndx = MMUtils.nextInsertPosition(this.m_wordToTypeItems, searchItem, this.m_comparator);
            item = searchItem;
            this.m_wordToTypeItems.add(ndx, searchItem);
        } else {
            item = this.m_wordToTypeItems.get(ndx);
        }
        if (type != FieldType.UNKNOWN_FIELD_TYPE) {
            item.add(type, addressOffset);
        }
    }

    private WordToFieldType readAt(int ndx) {
        long wordCode = 0L;
        int bufOffset = this.m_startOffset + 4 + ndx * (this.m_useLongWordCodes ? 12 : 8);
        this.m_buf.position(bufOffset);
        wordCode = this.m_useLongWordCodes ? this.m_buf.getLong() : (long)this.m_buf.getInt() & 0xFFFFFFFFL;
        int offset = this.m_buf.getInt();
        WordToFieldType item = new WordToFieldType(wordCode);
        item.m_offset = offset;
        return item;
    }

    protected IntArray getAddressOffsets(FieldType type, long wordCode) {
        FieldTypeToAddressOffset typeToOffset;
        WordToFieldType item = new WordToFieldType(wordCode);
        int ndx = Collections.binarySearch(this.m_wordToTypeItems, item, this.m_comparator);
        if (ndx > -1 && (typeToOffset = (item = this.m_wordToTypeItems.get(ndx)).get(type)) != null) {
            return typeToOffset.m_addressOffsets;
        }
        return null;
    }

    private List<FieldTypeToAddressOffset> readTypeAndOffsets(int offset) {
        ArrayList<FieldTypeToAddressOffset> types = null;
        this.m_buf.position(this.m_startOffset + offset);
        int typeCount = this.m_buf.get();
        if (typeCount > 0) {
            types = new ArrayList<FieldTypeToAddressOffset>(typeCount);
            for (int i = 0; i < typeCount; ++i) {
                int typeValue = MMUtils.toPositiveInteger(this.m_buf.get());
                FieldType type = this.m_metaData.getFieldType(typeValue);
                int offsetCount = 0;
                offsetCount = this.m_addressCount < 254 ? IOUtil.readUnsignedByte(this.m_buf) : (this.m_addressCount < 65534 ? IOUtil.readUnsignedShort(this.m_buf) : this.m_buf.getInt());
                FieldTypeToAddressOffset typeItem = new FieldTypeToAddressOffset(type);
                types.add(typeItem);
                for (int j = 0; j < offsetCount; ++j) {
                    int addrOffset = 0;
                    addrOffset = this.m_addressCount < 254 ? IOUtil.readUnsignedByte(this.m_buf) : (this.m_addressCount < 65534 ? IOUtil.readUnsignedShort(this.m_buf) : this.m_buf.getInt());
                    typeItem.add(addrOffset);
                }
            }
        }
        return types;
    }

    private void writeTypeAndOffsets(WordToFieldType wordToTypeItem, DataOutput out) throws IOException {
        int typeCount = wordToTypeItem.getTypeCount();
        out.write(typeCount);
        if (typeCount > 0) {
            for (int i = 0; i < typeCount; ++i) {
                FieldTypeToAddressOffset typeItem = wordToTypeItem.getAt(i);
                typeItem.removeDuplicateOffsets();
                int typeValue = typeItem.m_type.getKey();
                out.write(typeValue);
                int offsetCount = typeItem.getAddressOffsetCount();
                if (this.m_addressCount < 254) {
                    out.write(offsetCount);
                } else if (this.m_addressCount < 65534) {
                    out.writeShort(offsetCount);
                } else {
                    out.writeInt(offsetCount);
                }
                for (int j = 0; j < offsetCount; ++j) {
                    int addressOffset = typeItem.getAt(j);
                    if (this.m_addressCount < 254) {
                        out.write(addressOffset);
                        continue;
                    }
                    if (this.m_addressCount < 65534) {
                        out.writeShort(addressOffset);
                        continue;
                    }
                    out.writeInt(addressOffset);
                }
            }
        }
    }

    private static class FieldTypeToAddressOffset
    implements Comparator<FieldTypeToAddressOffset> {
        FieldType m_type;
        private IntArray m_addressOffsets = new IntArray(100);

        FieldTypeToAddressOffset(FieldType type) {
            this.m_type = type;
        }

        void add(int addressOffset) {
            this.m_addressOffsets.add(addressOffset);
        }

        @Override
        public int compare(FieldTypeToAddressOffset t1, FieldTypeToAddressOffset t2) {
            if (t1 != null && t2 != null) {
                return t1.m_type.compare(t1.m_type, t2.m_type);
            }
            if (t1 != null) {
                return 1;
            }
            if (t2 != null) {
                return -1;
            }
            return 0;
        }

        int getAddressOffsetCount() {
            return this.m_addressOffsets == null ? 0 : this.m_addressOffsets.size();
        }

        int getAt(int ndx) {
            return this.m_addressOffsets == null ? -1 : this.m_addressOffsets.get(ndx);
        }

        void removeDuplicateOffsets() {
            this.m_addressOffsets = IntArray.removeDuplicates(this.m_addressOffsets);
        }
    }

    private class WordToFieldType
    implements Comparator<WordToFieldType> {
        long m_wordCode;
        List<FieldTypeToAddressOffset> m_types;
        int m_offset;
        Comparator<FieldTypeToAddressOffset> m_compartor = new FieldTypeToAddressOffset(FieldType.UNKNOWN_FIELD_TYPE);

        WordToFieldType(long wordCode) {
            this.m_wordCode = wordCode;
            this.m_types = null;
        }

        void add(FieldType type, int addressOffset) {
            if (this.m_types == null) {
                this.m_types = new ArrayList<FieldTypeToAddressOffset>(5);
            }
            FieldTypeToAddressOffset item = null;
            FieldTypeToAddressOffset searchType = new FieldTypeToAddressOffset(type);
            int ndx = Collections.binarySearch(this.m_types, searchType, this.m_compartor);
            if (ndx < 0) {
                ndx = MMUtils.nextInsertPosition(this.m_types, searchType, this.m_compartor);
                item = searchType;
                this.m_types.add(ndx, searchType);
            } else {
                item = this.m_types.get(ndx);
            }
            item.add(addressOffset);
        }

        int getTypeCount() {
            return this.m_types != null ? this.m_types.size() : 0;
        }

        FieldTypeToAddressOffset get(FieldType type) {
            int ndx;
            if (this.m_types == null && this.m_offset > -1 && AddressHandleWords.this.isReading()) {
                this.m_types = AddressHandleWords.this.readTypeAndOffsets(this.m_offset);
            }
            FieldTypeToAddressOffset item = null;
            if (this.m_types != null && (ndx = Collections.binarySearch(this.m_types, item = new FieldTypeToAddressOffset(type), item)) > -1) {
                item = this.m_types.get(ndx);
            }
            return item;
        }

        FieldTypeToAddressOffset getAt(int ndx) {
            return this.m_types != null ? this.m_types.get(ndx) : null;
        }

        @Override
        public int compare(WordToFieldType w1, WordToFieldType w2) {
            if (w1 != null && w2 != null && w1.m_wordCode != w2.m_wordCode) {
                if (w1.m_wordCode > w2.m_wordCode) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }
    }

    private class WordToFieldTypeList
    extends ArrayList<WordToFieldType> {
        public WordToFieldTypeList(int initialCapacity) {
            super(initialCapacity);
            if (AddressHandleWords.this.isReading()) {
                for (int i = 0; i < initialCapacity; ++i) {
                    this.add(null);
                }
            }
        }

        @Override
        public WordToFieldType get(int index) {
            WordToFieldType item = (WordToFieldType)super.get(index);
            if (item == null && AddressHandleWords.this.isReading()) {
                item = AddressHandleWords.this.readAt(index);
                this.set(index, item);
            }
            return item;
        }
    }
}

