/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AddressNumberIOHandler {
    private static int MASK_FIRST_NUMBER_IS_SHORT = 1;
    private static int MASK_FIRST_NUMBER_HAS_SUFFIX = 2;
    private static int MASK_IS_RANGE = 4;
    private static int MASK_SEPERATOR_IS_SLASH = 8;
    private static int MASK_SECOND_NUMBER_IS_SHORT = 16;
    private static int MASK_SECOND_NUMBER_HAS_SUFFIX = 32;
    private static int MASK_HAS_SECOND_HNR = 64;
    private static int MASK_NUMBER_IS_INT = 128;

    public static void write(AddressNumber addrNum, DataOutput out) throws IOException {
        int mask = 0;
        if (addrNum.getHnrNumber1() >= 65534 || addrNum.getHnrNumber2() >= 65534) {
            mask |= MASK_NUMBER_IS_INT;
        } else if (addrNum.getHnrNumber1() >= 254) {
            mask |= MASK_FIRST_NUMBER_IS_SHORT;
        }
        if (addrNum.getHnrSuffix1() != null) {
            mask |= MASK_FIRST_NUMBER_HAS_SUFFIX;
        }
        if (addrNum.getHnrNumber2() > 0 || addrNum.getHnrSuffix2() != null) {
            mask |= MASK_IS_RANGE;
            if (addrNum.getSeperatorType() == 1) {
                mask |= MASK_SEPERATOR_IS_SLASH;
            }
            if ((mask & MASK_NUMBER_IS_INT) != MASK_NUMBER_IS_INT && addrNum.getHnrNumber2() >= 254) {
                mask |= MASK_SECOND_NUMBER_IS_SHORT;
            }
            if (addrNum.getHnrSuffix2() != null) {
                mask |= MASK_SECOND_NUMBER_HAS_SUFFIX;
            }
        }
        if (addrNum.getSecondHNR() != null) {
            mask |= MASK_HAS_SECOND_HNR;
        }
        out.write(mask);
        if ((mask & MASK_NUMBER_IS_INT) == MASK_NUMBER_IS_INT) {
            out.writeInt(addrNum.getHnrNumber1());
        } else if ((mask & MASK_FIRST_NUMBER_IS_SHORT) == MASK_FIRST_NUMBER_IS_SHORT) {
            out.writeShort(addrNum.getHnrNumber1());
        } else {
            out.writeByte(addrNum.getHnrNumber1());
        }
        if ((mask & MASK_FIRST_NUMBER_HAS_SUFFIX) == MASK_FIRST_NUMBER_HAS_SUFFIX) {
            out.writeByte(addrNum.getHnrSuffix1().charAt(0));
        }
        if ((mask & MASK_IS_RANGE) == MASK_IS_RANGE) {
            if ((mask & MASK_NUMBER_IS_INT) == MASK_NUMBER_IS_INT) {
                out.writeInt(addrNum.getHnrNumber2());
            } else if ((mask & MASK_SECOND_NUMBER_IS_SHORT) == MASK_SECOND_NUMBER_IS_SHORT) {
                out.writeShort(addrNum.getHnrNumber2());
            } else {
                out.writeByte(addrNum.getHnrNumber2());
            }
            if ((mask & MASK_SECOND_NUMBER_HAS_SUFFIX) == MASK_SECOND_NUMBER_HAS_SUFFIX) {
                out.writeByte(addrNum.getHnrSuffix2().charAt(0));
            }
        }
        if ((mask & MASK_HAS_SECOND_HNR) == MASK_HAS_SECOND_HNR) {
            AddressNumberIOHandler.write(addrNum.getSecondHNR(), out);
        }
    }

    public static void read(AddressNumber addrNum, ICGGEDataInput in) throws IOException {
        int b;
        int s;
        int i;
        int mask = MMUtils.toPositiveInteger(in.readByte());
        if ((mask & MASK_NUMBER_IS_INT) == MASK_NUMBER_IS_INT) {
            i = in.readInt();
            addrNum.setHnrNumber1(i);
        } else if ((mask & MASK_FIRST_NUMBER_IS_SHORT) == MASK_FIRST_NUMBER_IS_SHORT) {
            s = in.readShort();
            addrNum.setHnrNumber1(s < 0 ? MMUtils.toPositiveInteger((short)s) : s);
        } else {
            b = in.readByte();
            addrNum.setHnrNumber1(b < 0 ? MMUtils.toPositiveInteger((byte)b) : b);
        }
        if ((mask & MASK_FIRST_NUMBER_HAS_SUFFIX) == MASK_FIRST_NUMBER_HAS_SUFFIX) {
            addrNum.setHnrSuffix1(new String(new byte[]{in.readByte()}));
        }
        if ((mask & MASK_IS_RANGE) == MASK_IS_RANGE) {
            if ((mask & MASK_SEPERATOR_IS_SLASH) == MASK_SEPERATOR_IS_SLASH) {
                addrNum.setSeperatorType(1);
            }
            if ((mask & MASK_NUMBER_IS_INT) == MASK_NUMBER_IS_INT) {
                i = in.readInt();
                addrNum.setHnrNumber2(i);
            } else if ((mask & MASK_SECOND_NUMBER_IS_SHORT) == MASK_SECOND_NUMBER_IS_SHORT) {
                s = in.readShort();
                addrNum.setHnrNumber2(s < 0 ? MMUtils.toPositiveInteger((short)s) : s);
            } else {
                b = in.readByte();
                addrNum.setHnrNumber2(b < 0 ? MMUtils.toPositiveInteger((byte)b) : b);
            }
            if ((mask & MASK_SECOND_NUMBER_HAS_SUFFIX) == MASK_SECOND_NUMBER_HAS_SUFFIX) {
                addrNum.setHnrSuffix2(new String(new byte[]{in.readByte()}));
            }
        }
        if ((mask & MASK_HAS_SECOND_HNR) == MASK_HAS_SECOND_HNR) {
            AddressNumber secondAddrNum = new AddressNumber();
            AddressNumberIOHandler.read(secondAddrNum, in);
            addrNum.setSecondHNR(secondAddrNum);
        }
    }
}

