/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.IInternalAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.InternalAreaItemFactory;
import com.mapinfo.mapmarker.cgge.dp.SALocator;
import com.mapinfo.mapmarker.cgge.dp.WordDictionary;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaNameDictionary {
    static final Logger logger = LoggerFactory.getLogger(AreaNameDictionary.class);
    private IInternalAreaTermItem[] m_areaTermArray = null;
    private Map<FieldType, AreaTypeToTerms> m_typeToAreaIndexMap = null;
    private WordDictionary m_wordDictionary = null;
    private WordDictionary m_streetWordDictionary = null;
    private boolean m_loaded = false;
    private static final char DATA_FIELD_SEPERATOR = '|';
    private static final char WORD_FIELD_SEPERATOR = '-';
    private static final char WORD_SEPERATOR = ',';
    private static final String DATA_NOT_INIT_MSG = "Area Name Dictionary is not initialised";
    ICGGEParser m_parser;
    ICGGESoundex m_soundex;

    public boolean loadDictionary(String dataPath, WordDictionary streetWordDictionary, CGGEHandler handler, IDictionaryMetaData metaData) throws Exception {
        this.m_soundex = handler.getSoundex();
        this.m_parser = handler.getParser();
        this.m_streetWordDictionary = streetWordDictionary;
        boolean loaded = false;
        if (this.loadAreaWordDictionary(dataPath + ".arw", handler, metaData) && this.loadAreaNameDictionary(dataPath + ".ard", metaData)) {
            loaded = this.loadSACDictionary(dataPath + ".sac", metaData);
        }
        this.setLoaded(loaded);
        return loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.m_loaded = loaded;
    }

    protected void setParser(ICGGEParser parser) {
        this.m_parser = parser;
    }

    protected void setSoundex(ICGGESoundex soundex) {
        this.m_soundex = soundex;
    }

    protected boolean loadAreaWordDictionary(String fileName, CGGEHandler handler, IDictionaryMetaData metaData) throws Exception {
        WordDictionary wordDict = new WordDictionary();
        if (wordDict.loadDictionary(fileName, handler)) {
            this.setAreaWordDictionary(wordDict);
            return true;
        }
        return false;
    }

    protected void setAreaWordDictionary(WordDictionary wordDict) {
        this.m_wordDictionary = wordDict;
    }

    protected boolean loadSACDictionary(String fileName, IDictionaryMetaData metaData) throws Exception {
        FileInputStream s = new FileInputStream(fileName);
        boolean success = this.loadSACDictionary(s, metaData);
        ((InputStream)s).close();
        return success;
    }

    protected boolean loadAreaNameDictionary(String fileName, IDictionaryMetaData metaData) throws Exception {
        FileInputStream s = new FileInputStream(fileName);
        boolean success = this.loadAreaNameDictionary(s, metaData);
        ((InputStream)s).close();
        return success;
    }

    public AddressWord[] getAreaWords(int offset) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        IInternalAreaTermItem areaTermItem = this.m_areaTermArray[offset];
        return this.getAddressWords(areaTermItem);
    }

    private AddressWord[] getAddressWords(IInternalAreaTermItem areaTermItem) {
        CodedWord[] codedWords = areaTermItem.getAreaWords();
        int wordCount = codedWords == null ? 0 : codedWords.length;
        AddressWord[] addrWords = new AddressWord[wordCount];
        byte[] areaWordWeights = areaTermItem.getWeights();
        FieldType type = areaTermItem.getFieldType();
        ICGGEParser parser = this.getParser();
        ICGGESoundex soundex = this.getSoundex();
        for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
            AddressWord addrWord = new AddressWord(codedWords[wordNdx]);
            addrWord.m_weight = areaWordWeights[wordNdx];
            addrWord.m_wordType = type;
            parser.assignAlternateWord(addrWord, soundex);
            addrWords[wordNdx] = addrWord;
        }
        return addrWords;
    }

    private ICGGEParser getParser() {
        return this.m_parser;
    }

    private ICGGESoundex getSoundex() {
        return this.m_soundex;
    }

    private DictionaryAreaTermItem convertToDictionaryAreaTermItem(IInternalAreaTermItem areaTermItem) {
        DictionaryAreaTermItem dictAreaItem = null;
        if (areaTermItem != null) {
            dictAreaItem = new DictionaryAreaTermItem(this.getAddressWords(areaTermItem), areaTermItem.getFieldType());
            dictAreaItem.m_indexCode = areaTermItem.getOffset();
        }
        return dictAreaItem;
    }

    public char[] getWordChars(int soundex, int offset, FieldType type) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        WordDictionary wordDict = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL ? this.m_wordDictionary : this.m_streetWordDictionary;
        return wordDict.getWordChars(soundex, offset);
    }

    public FieldType getAreaType(int areaCode) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        if (areaCode > -1 && areaCode < this.m_areaTermArray.length) {
            return this.m_areaTermArray[areaCode].getFieldType();
        }
        return null;
    }

    public int[] getAreaSacs(int areaCode) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        int[] sacs = this.m_areaTermArray[areaCode].getSacs();
        if (sacs != null) {
            sacs = (int[])sacs.clone();
        }
        return sacs;
    }

    public DictionaryAreaTermItem findAreaTermOffset(String str, FieldType type, ICGGEParser parser) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        AreaTypeToTerms areaTypeToTerms = this.m_typeToAreaIndexMap.get(type);
        if (areaTypeToTerms != null) {
            WordDictionary wordDict;
            AddressWord[] weightedWords = parser.splitIntoWeightedWords(str, type);
            AddressWord[] scoringWords = null;
            WordDictionary wordDictionary = wordDict = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL ? this.m_wordDictionary : this.m_streetWordDictionary;
            if (weightedWords != null && weightedWords.length > 0) {
                scoringWords = new AddressWord[weightedWords.length];
                int nAdded = 0;
                for (int i = 0; i < weightedWords.length; ++i) {
                    CodedWord codedWord = wordDict.getCodedWord(weightedWords[i].getWord());
                    AddressWord word = new AddressWord(codedWord);
                    if (word != null) {
                        scoringWords[nAdded++] = word;
                    }
                    word.m_wordType = type;
                }
                if (nAdded < scoringWords.length) {
                    AddressWordArray.arraycopy(scoringWords, 0, scoringWords, 0, nAdded);
                }
                DictionaryAreaTermItem compareItem = new DictionaryAreaTermItem(scoringWords, type);
                compareItem.m_indexCode = -1;
                for (int i = 0; i < scoringWords.length; ++i) {
                    AddressWord addrWord = scoringWords[i];
                    addrWord.m_weight = weightedWords[i].m_weight;
                    IInternalAreaTermItem[] areaItems = areaTypeToTerms.findAreaItemsWithCodedWord(addrWord.getCodedWord());
                    if (areaItems == null) continue;
                    for (IInternalAreaTermItem areaItem : areaItems) {
                        DictionaryAreaTermItem areaTerm = this.convertToDictionaryAreaTermItem(areaItem);
                        this.checkAltWordsForCodedWord(areaTerm, wordDict);
                        if (!areaTerm.equals(compareItem)) continue;
                        return areaTerm;
                    }
                }
            }
        }
        return null;
    }

    protected void checkAltWordsForCodedWord(DictionaryAreaTermItem areaTerm, WordDictionary wordDict) throws DataNotInitialisedException {
        AddressWord[] adwords;
        for (AddressWord aWord : adwords = areaTerm.getAreaAddressWords()) {
            if (!aWord.hasAlternates()) continue;
            List<WordAlternate> alts = aWord.getAlternates();
            for (WordAlternate wdAlt : alts) {
                if (wdAlt.getAltWord() == null || wdAlt.getAltWord().getCodedWord() == null || wdAlt.getAltWord().getCodedWord().getWordCode() != -1L) continue;
                CodedWord codedWord = wordDict.getCodedWord(wdAlt.getAltWord().getCodedWord().getWord());
                wdAlt.getAltWord().setCodedWord(codedWord);
            }
        }
    }

    public ArrayList<DictionaryAreaTermItem> findAreaTerms(AddressWord scoringWord, FieldType type, double minQuality, ICGGEScorer scorer) throws IOException, DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        AreaTypeToTerms areaTypeToTerms = this.m_typeToAreaIndexMap.get(type);
        if (areaTypeToTerms != null) {
            ArrayList<DictionaryAreaTermItem> retAreaTermList = new ArrayList<DictionaryAreaTermItem>(10);
            WordDictionary wordDict = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL ? this.m_wordDictionary : this.m_streetWordDictionary;
            List<AddressWord> matchingWordList = wordDict.getMatchingWords(scoringWord, scorer, minQuality);
            int matchingWordListSize = matchingWordList == null ? 0 : matchingWordList.size();
            for (int i = 0; i < matchingWordListSize; ++i) {
                IInternalAreaTermItem[] areaList;
                AddressWord matchingWord = matchingWordList.get(i);
                double quality = matchingWord.m_quality;
                if (!(quality >= minQuality) || (areaList = areaTypeToTerms.findAreaItemsWithCodedWord(matchingWord.getCodedWord())) == null) continue;
                block1: for (IInternalAreaTermItem areaItem : areaList) {
                    DictionaryAreaTermItem areaTerm = this.convertToDictionaryAreaTermItem(areaItem);
                    retAreaTermList.add(areaTerm);
                    AddressWord[] areaWords = areaTerm.m_areaWords;
                    for (int k = 0; k < areaWords.length; ++k) {
                        AddressWord areaWord = areaWords[k];
                        if (!areaWord.getCodedWord().isSameWord(matchingWord.getCodedWord())) continue;
                        DictionaryAddressWord dictWord = new DictionaryAddressWord(matchingWord, scoringWord);
                        dictWord.setMatchQuality(quality);
                        areaTerm.addMatchedWord(dictWord, k);
                        continue block1;
                    }
                }
            }
            if (retAreaTermList.size() > 0) {
                return retAreaTermList;
            }
        }
        return null;
    }

    protected boolean loadAreaNameDictionary(InputStream inStream, IDictionaryMetaData metaData) throws NumberFormatException, IOException, DataFetchException {
        BufferedReader r = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        ArrayList<IInternalAreaTermItem> areaTermList = new ArrayList<IInternalAreaTermItem>();
        this.m_typeToAreaIndexMap = new HashMap<FieldType, AreaTypeToTerms>();
        int lineNo = 1;
        HashMap<FieldType, Map<CodedWord, List<IInternalAreaTermItem>>> tempTypeToWordTermMap = new HashMap<FieldType, Map<CodedWord, List<IInternalAreaTermItem>>>();
        while ((line = r.readLine()) != null) {
            String[] st = MMUtils.splitString(line, '|');
            if (st == null || st.length < 2) continue;
            int typeValue = Integer.parseInt(st[0]);
            FieldType type = metaData.getFieldType(typeValue);
            WordDictionary wordDict = type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL ? this.m_wordDictionary : this.m_streetWordDictionary;
            int wordLen = Integer.parseInt(st[1]);
            String[] strCodes = MMUtils.splitString(st[2], ',');
            if (strCodes != null && strCodes.length == wordLen) {
                CodedWord[] codedWords = new CodedWord[wordLen];
                byte[] weights = new byte[wordLen];
                for (int wordNdx = 0; wordNdx < wordLen; ++wordNdx) {
                    String[] st1 = MMUtils.splitString(strCodes[wordNdx], '-');
                    int soundex = Integer.parseInt(st1[0]);
                    int offset = Integer.parseInt(st1[1]);
                    CodedWord word = null;
                    try {
                        word = wordDict.getCodedWord(soundex, offset);
                    }
                    catch (DataNotInitialisedException e) {
                        throw new DataFetchException(e);
                    }
                    if (word == null) {
                        throw new DataFetchException("Word is null");
                    }
                    codedWords[wordNdx] = word;
                    weights[wordNdx] = Byte.parseByte(st1[2]);
                }
                IInternalAreaTermItem term = InternalAreaItemFactory.getInstance(codedWords, weights, type);
                int areaIndex = areaTermList.size();
                term.setOffset(areaIndex);
                areaTermList.add(areaIndex, term);
                HashMap wordToTermMap = (HashMap)tempTypeToWordTermMap.get(type);
                if (wordToTermMap == null) {
                    wordToTermMap = new HashMap();
                    tempTypeToWordTermMap.put(type, wordToTermMap);
                }
                AreaTypeToTerms.addToMap(term, wordToTermMap);
            }
            ++lineNo;
        }
        r.close();
        int areaTermSize = areaTermList.size();
        this.m_areaTermArray = areaTermList.toArray(new IInternalAreaTermItem[areaTermSize]);
        this.addWordToTermsList(this.m_typeToAreaIndexMap, tempTypeToWordTermMap);
        return true;
    }

    private void addWordToTermsList(Map<FieldType, AreaTypeToTerms> typeToAreaIndexMap, Map<FieldType, Map<CodedWord, List<IInternalAreaTermItem>>> tempTypeToWordTermMap) {
        Iterator<Map.Entry<FieldType, Map<CodedWord, List<IInternalAreaTermItem>>>> it = tempTypeToWordTermMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<FieldType, Map<CodedWord, List<IInternalAreaTermItem>>> en = it.next();
            AreaTypeToTerms areaTypeToTerms = new AreaTypeToTerms(en.getKey());
            areaTypeToTerms.fillAndRemoveFromMap(en.getValue());
            typeToAreaIndexMap.put(areaTypeToTerms.m_type, areaTypeToTerms);
            it.remove();
        }
    }

    protected boolean loadSACDictionary(InputStream inStream, IDictionaryMetaData metaData) throws IOException {
        Map<Integer, int[]> areaSacMap = SALocator.loadSACDictionary(inStream, metaData);
        for (Map.Entry<Integer, int[]> sacEntry : areaSacMap.entrySet()) {
            int areaCode = sacEntry.getKey();
            int[] sacs = sacEntry.getValue();
            this.m_areaTermArray[areaCode].setSacs(sacs);
        }
        return true;
    }

    protected static boolean canBeAKeyWord(byte[] weights, int wordNdx) {
        int wordCount = weights.length;
        if (wordCount > 0) {
            if (wordCount == 1) {
                return true;
            }
            byte weight = weights[wordNdx];
            if (weight > 0) {
                double avg = 1.0 / (double)wordCount;
                double quality = (double)weight * 0.01 / avg;
                return quality >= 0.75;
            }
        }
        return false;
    }

    public List<AddressWord> getMatchingWords(AddressWord word, ICGGEScorer scorer, double minQuality) throws DataNotInitialisedException {
        if (!this.m_loaded) {
            throw new DataNotInitialisedException(DATA_NOT_INIT_MSG);
        }
        List<AddressWord> tempWords = this.m_wordDictionary.getMatchingWords(word, scorer, minQuality);
        return tempWords != null && tempWords.size() > 0 ? tempWords : null;
    }

    public static int writeAreaNameDictionary(OutputStream outStream, List<DictionaryAreaTermItem> areaTermItems) {
        PrintWriter w = new PrintWriter(outStream);
        int areaCode = 0;
        for (DictionaryAreaTermItem areaItem : areaTermItems) {
            w.write(Integer.toString(areaItem.getFieldType().getKey()));
            w.write(124);
            w.write(Integer.toString(areaItem.getWordCount()));
            w.write(124);
            AddressWord[] words = areaItem.getAreaAddressWords();
            for (int j = 0; j < words.length; ++j) {
                w.write(Integer.toString(words[j].getSoundex()));
                w.write(45);
                w.write(Integer.toString(words[j].getCodedWord().getOffset()));
                w.write(45);
                w.write(Byte.toString(words[j].m_weight));
                w.write(44);
            }
            w.println();
            areaItem.m_indexCode = areaCode++;
        }
        w.flush();
        w.close();
        return areaCode;
    }

    public WordDictionary getWordDictionary() {
        return this.m_wordDictionary;
    }

    private static class AreaTypeToTerms
    implements Comparable<AreaTypeToTerms> {
        FieldType m_type;
        Map<CodedWord, IInternalAreaTermItem[]> m_areaIndexMap;

        AreaTypeToTerms(FieldType type) {
            this.m_type = type;
        }

        @Override
        public int compareTo(AreaTypeToTerms o) {
            if (this.m_type != null) {
                return this.m_type.compare(this.m_type, o.m_type);
            }
            if (o.m_type != null) {
                return -1;
            }
            return 0;
        }

        void fillAndRemoveFromMap(Map<CodedWord, List<IInternalAreaTermItem>> map) {
            this.m_areaIndexMap = new HashMap<CodedWord, IInternalAreaTermItem[]>();
            Iterator<Map.Entry<CodedWord, List<IInternalAreaTermItem>>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<CodedWord, List<IInternalAreaTermItem>> en = it.next();
                CodedWord word = en.getKey();
                List<IInternalAreaTermItem> areaList = en.getValue();
                this.m_areaIndexMap.put(word, areaList.toArray(new IInternalAreaTermItem[areaList.size()]));
                it.remove();
            }
        }

        static void addToMap(IInternalAreaTermItem areaItem, Map<CodedWord, List<IInternalAreaTermItem>> map) {
            CodedWord[] codedWords = areaItem.getAreaWords();
            int wordCount = codedWords == null ? 0 : codedWords.length;
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                if (!AreaNameDictionary.canBeAKeyWord(areaItem.getWeights(), wordNdx)) continue;
                CodedWord codedWord = codedWords[wordNdx];
                List<IInternalAreaTermItem> areaGroupList = map.get(codedWord);
                if (areaGroupList == null) {
                    areaGroupList = new ArrayList<IInternalAreaTermItem>(1);
                    map.put(codedWord, areaGroupList);
                }
                areaGroupList.add(areaItem);
            }
        }

        public IInternalAreaTermItem[] findAreaItemsWithCodedWord(CodedWord codedWord) {
            return this.m_areaIndexMap.get(codedWord);
        }
    }
}

