/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.midev.geometry.DirectPosition;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompressedSegment {
    static final Logger logger = LoggerFactory.getLogger(CompressedSegment.class);
    private byte m_xPow10;
    private byte m_yPow10;
    private long m_xFactor;
    private long m_yFactor;
    private short m_numPoints;
    private LongPoint m_firstPoint;
    private byte[] m_offsets;
    private LongPoint m_origin;
    private long m_firstXOffset;
    private long m_firstYOffset;

    public CompressedSegment(DirectPosition[] pnts, byte xPow10, byte yPow10, long xFactor, long yFactor) {
        this.m_xPow10 = xPow10;
        this.m_xFactor = xFactor;
        this.m_yPow10 = yPow10;
        this.m_yFactor = yFactor;
        if (pnts != null && pnts.length != 0) {
            LongPoint[] longPnts = this.convertToLongPoints(pnts);
            longPnts = this.addExtraPoints(longPnts);
            this.m_numPoints = (short)longPnts.length;
            this.m_firstPoint = longPnts[0];
            this.m_firstXOffset = this.m_firstPoint.getX();
            this.m_firstYOffset = this.m_firstPoint.getY();
            this.m_offsets = this.computeOffsets(longPnts);
        }
    }

    public CompressedSegment(byte xPow10, byte yPow10) {
        this.m_xPow10 = xPow10;
        this.m_xFactor = (long)Math.pow(10.0, this.m_xPow10);
        this.m_yPow10 = yPow10;
        this.m_yFactor = (long)Math.pow(10.0, this.m_yPow10);
    }

    public CompressedSegment(short numPoints, long firstXOffset, long firstYOffset, byte xPow10, byte yPow10, long xFactor, long yFactor) {
        this.m_xPow10 = xPow10;
        this.m_xFactor = xFactor;
        this.m_yPow10 = yPow10;
        this.m_yFactor = yFactor;
        this.m_numPoints = numPoints;
        this.m_firstXOffset = firstXOffset;
        this.m_firstYOffset = firstYOffset;
    }

    protected CompressedSegment() {
        this.m_xFactor = 1L;
        this.m_yFactor = 1L;
    }

    public short getNumberPoints() {
        return this.m_numPoints;
    }

    long getFirstXOffset() {
        return this.m_firstXOffset;
    }

    long getFirstYOffset() {
        return this.m_firstYOffset;
    }

    public long getXFactor() {
        return this.m_xFactor;
    }

    public long getYFactor() {
        return this.m_yFactor;
    }

    public void setOrigin(DirectPosition origin) {
        long x = CompressedSegment.convertDoubleToLongAndRound(origin.getX(), this.m_xFactor);
        long y = CompressedSegment.convertDoubleToLongAndRound(origin.getY(), this.m_yFactor);
        this.m_origin = new LongPoint(x, y);
        if (this.m_firstPoint != null) {
            this.m_firstXOffset = this.m_firstPoint.getX() - x;
            this.m_firstYOffset = this.m_firstPoint.getY() - y;
        }
    }

    public DirectPosition[] convert() {
        LongPoint[] longPnts = new LongPoint[this.m_numPoints];
        if (this.m_firstPoint == null) {
            this.m_firstPoint = this.m_origin == null ? new LongPoint(this.m_firstXOffset, this.m_firstYOffset) : new LongPoint(this.m_firstXOffset + this.m_origin.getX(), this.m_firstYOffset + this.m_origin.getY());
        }
        longPnts[0] = this.m_firstPoint;
        int nextByte = 0;
        for (int i = 1; i < this.m_numPoints; ++i) {
            longPnts[i] = new LongPoint(longPnts[i - 1].getX() - (long)this.m_offsets[nextByte++], longPnts[i - 1].getY() - (long)this.m_offsets[nextByte++]);
        }
        DirectPosition[] points = this.convertToPoints(longPnts);
        return points;
    }

    private byte[] computeOffsets(LongPoint[] longPnts) {
        byte[] bytes = new byte[(longPnts.length - 1) * 2];
        int nextByte = 0;
        for (int i = 0; i < longPnts.length - 1; ++i) {
            bytes[nextByte++] = (byte)this.computeDelta(longPnts[i].getX(), longPnts[i + 1].getX(), 1);
            bytes[nextByte++] = (byte)this.computeDelta(longPnts[i].getY(), longPnts[i + 1].getY(), 1);
        }
        return bytes;
    }

    private long computeDelta(long coord1, long coord2, int divisor) {
        return (coord1 - coord2) / (long)divisor;
    }

    private boolean allOffsetsCorrect(LongPoint[] longPnts) {
        for (int i = 0; i < longPnts.length - 1; ++i) {
            long deltaX = this.computeDelta(longPnts[i].getX(), longPnts[i + 1].getX(), 1);
            long deltaY = this.computeDelta(longPnts[i].getY(), longPnts[i + 1].getY(), 1);
            if (deltaX <= 127L && deltaX >= -128L && deltaY <= 127L && deltaY >= -128L) continue;
            return false;
        }
        return true;
    }

    private boolean numberOfExtraPointsCorrect(LongPoint firstPoint, LongPoint secondPoint, int numberOfPointsToAdd) {
        LongPoint[] testArray = new LongPoint[]{firstPoint, secondPoint};
        logger.debug("j = " + numberOfPointsToAdd);
        testArray = this.addExtraPointsToSubSegment(0, testArray, numberOfPointsToAdd);
        return this.allOffsetsCorrect(testArray);
    }

    private LongPoint[] addExtraPointsToSubSegment(int startIndex, LongPoint[] longPnts, int numberOfPointsToAdd) {
        long deltaX = this.computeDelta(longPnts[startIndex].getX(), longPnts[startIndex + 1].getX(), numberOfPointsToAdd + 1);
        long deltaY = this.computeDelta(longPnts[startIndex].getY(), longPnts[startIndex + 1].getY(), numberOfPointsToAdd + 1);
        for (int i = startIndex; i < startIndex + numberOfPointsToAdd; ++i) {
            LongPoint pnt = new LongPoint(longPnts[i].getX() - deltaX, longPnts[i].getY() - deltaY);
            longPnts = this.insertNewPoint(longPnts, pnt, i + 1);
        }
        return longPnts;
    }

    private LongPoint[] correctOffsets(int i, LongPoint[] longPnts) {
        long deltaX = this.computeDelta(longPnts[i].getX(), longPnts[i + 1].getX(), 1);
        long deltaY = this.computeDelta(longPnts[i].getY(), longPnts[i + 1].getY(), 1);
        if (deltaY <= 127L && deltaY >= -128L && deltaX <= 127L && deltaX >= -128L) {
            return longPnts;
        }
        int j = 1;
        while (true) {
            boolean offsetsCorrected;
            if (offsetsCorrected = this.numberOfExtraPointsCorrect(longPnts[i], longPnts[i + 1], j)) {
                longPnts = this.addExtraPointsToSubSegment(i, longPnts, j);
                return longPnts;
            }
            ++j;
        }
    }

    private LongPoint[] addExtraPoints(LongPoint[] longPnts) {
        for (int i = 0; i < longPnts.length - 1; ++i) {
            long deltaX = this.computeDelta(longPnts[i].getX(), longPnts[i + 1].getX(), 1);
            long deltaY = this.computeDelta(longPnts[i].getY(), longPnts[i + 1].getY(), 1);
            if (deltaY <= 127L && deltaY >= -128L && deltaX <= 127L && deltaX >= -128L) continue;
            LongPoint midPoint = this.computeMidPoint(longPnts[i], longPnts[i + 1]);
            longPnts = this.insertNewPoint(longPnts, midPoint, i + 1);
            --i;
        }
        return longPnts;
    }

    private LongPoint computeMidPoint(LongPoint pnt1, LongPoint pnt2) {
        return new LongPoint((pnt1.getX() + pnt2.getX()) / 2L, (pnt1.getY() + pnt2.getY()) / 2L);
    }

    private LongPoint[] insertNewPoint(LongPoint[] longPnts, LongPoint newPnt, int index) {
        LongPoint[] returnPnts = new LongPoint[longPnts.length + 1];
        for (int i = 0; i <= longPnts.length; ++i) {
            returnPnts[i] = i < index ? longPnts[i] : (i == index ? newPnt : longPnts[i - 1]);
        }
        return returnPnts;
    }

    private DirectPosition[] convertToPoints(LongPoint[] longPnts) {
        DirectPosition[] points = new DirectPosition[longPnts.length];
        for (int i = 0; i < longPnts.length; ++i) {
            double newX = (double)longPnts[i].getX() / (double)this.m_xFactor;
            double newY = (double)longPnts[i].getY() / (double)this.m_yFactor;
            points[i] = new DirectPosition(newX, newY);
        }
        return points;
    }

    private LongPoint[] convertToLongPoints(DirectPosition[] points) {
        LongPoint[] longPnts = new LongPoint[points.length];
        for (int i = 0; i < points.length; ++i) {
            long newX = CompressedSegment.convertDoubleToLongAndRound(points[i].getX(), this.m_xFactor);
            long newY = CompressedSegment.convertDoubleToLongAndRound(points[i].getY(), this.m_yFactor);
            longPnts[i] = new LongPoint(newX, newY);
        }
        return longPnts;
    }

    public static long convertDoubleToLongAndRound(double coord, byte pow10) {
        long newCoord = (long)(coord * Math.pow(10.0, pow10) * 10.0);
        newCoord = newCoord < 0L ? (newCoord -= 5L) : (newCoord += 5L);
        return newCoord / 10L;
    }

    public static long convertDoubleToLongAndRound(double coord, long multiplicationFactor) {
        long newCoord = (long)(coord * (double)multiplicationFactor * 10.0);
        newCoord = newCoord < 0L ? (newCoord -= 5L) : (newCoord += 5L);
        return newCoord / 10L;
    }

    public void decode(byte[] valueBytes) {
        ByteBuffer buf = ByteBuffer.wrap(valueBytes);
        this.m_numPoints = buf.getShort();
        if (this.m_numPoints == 0) {
            return;
        }
        long x = buf.getLong();
        long y = buf.getLong();
        this.m_firstPoint = new LongPoint(x, y);
        if (this.m_numPoints > 1) {
            this.m_offsets = new byte[(this.m_numPoints - 1) * 2];
            buf.get(this.m_offsets);
        } else {
            this.m_offsets = null;
        }
    }

    public byte[] getValueBytes() {
        int totalBytes = 0;
        if (this.m_numPoints > 0) {
            totalBytes = 18;
            totalBytes += this.m_numPoints > 1 ? this.m_offsets.length : 0;
        }
        ByteBuffer buf = ByteBuffer.allocate(totalBytes);
        buf.putShort(this.m_numPoints);
        if (this.m_numPoints <= 0) {
            return null;
        }
        buf.putLong(this.m_firstPoint.getX());
        buf.putLong(this.m_firstPoint.getY());
        if (this.m_numPoints > 1) {
            for (int i = 0; i < this.m_offsets.length; ++i) {
                buf.put(this.m_offsets[i]);
            }
        }
        return buf.array();
    }

    public static final DirectPosition[] getSamplePointArray() {
        DirectPosition[] points = new DirectPosition[3];
        points[2] = new DirectPosition(6.1086997, 50.7832801);
        points[1] = new DirectPosition(6.1090863, 50.7810022);
        points[0] = new DirectPosition(6.1090908, 50.7710233);
        return points;
    }

    class LongPoint {
        private long x;
        private long y;

        LongPoint(long x, long y) {
            this.x = x;
            this.y = y;
        }

        long getX() {
            return this.x;
        }

        long getY() {
            return this.y;
        }
    }
}

