/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSet;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataDictionary;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataDictionary
implements IDataDictionary {
    public static final String KEY_ALLOWED_DATASETS = "allowed_datasets";
    public static final String KEY_ALLOWED_DATASETS_LIST = "allowed_datasets_list";
    private String m_dataPath;
    private String m_country;
    private String m_language;
    private int m_dictionaryNumber;
    Map<Integer, List<DataSet>> m_dataSets;

    public void loadDictionary(String path, int dictNumber) throws CGGEDataIntializationException {
        this.m_dictionaryNumber = dictNumber;
        try {
            int dataSetCount;
            File file = new File(path);
            String[] dataSetFiles = file.list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    return arg1.endsWith(".adi");
                }
            });
            int n = dataSetCount = dataSetFiles == null ? 0 : dataSetFiles.length;
            if (dataSetCount == 0) {
                throw new CGGEDataIntializationException("Failed to find data files at " + path);
            }
            this.m_dataSets = new HashMap<Integer, List<DataSet>>(3);
            for (int i = 0; i < dataSetCount; ++i) {
                String fileName = dataSetFiles[i];
                String name = fileName.substring(0, fileName.length() - ".adi".length());
                DataSet dataSet = DataSet.getInstance(path, name, dictNumber, 0);
                int dictType = dataSet.getMetaData().getDictionaryType();
                List<DataSet> dataSets = ListUtils.addToList(this.m_dataSets.get(dictType), dataSet);
                this.m_dataSets.put(dictType, dataSets);
                dataSet.getDataSetInfo().setDataSetNumber(dataSets.size() - 1);
                if (dataSet.loadData(path, name)) continue;
                throw new CGGEDataIntializationException("Failed to load dataset " + name + "at " + path);
            }
            this.m_dataPath = path;
        }
        catch (Exception e) {
            throw new CGGEDataIntializationException(e);
        }
    }

    @Override
    public String getDictionaryPath() {
        return this.m_dataPath;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    public List<DictionaryAreaTermItem> findAreaTerms(int dictionaryType, AddressWord[] searchWords, FieldType type, double minQuality, GeocodeOptions options) throws IOException, DataNotInitialisedException {
        List<DataSet> dataSets;
        int wordsLen = searchWords == null ? 0 : searchWords.length;
        List<DictionaryAreaTermItem> areaItems = null;
        if (wordsLen > 0 && (dataSets = this.m_dataSets.get(dictionaryType)) != null) {
            for (DataSet dataSet : dataSets) {
                if (!this.canSearchDataset(dataSet, options)) continue;
                Collection<DictionaryAreaTermItem> curTerms = dataSet.findAreaTerms(searchWords, type, minQuality);
                areaItems = ListUtils.addToList(areaItems, curTerms);
            }
        }
        return areaItems;
    }

    public DictionaryAreaSacs getSacsForArea(int dictType, DictionaryAreaTermItem area, GeocodeOptions options) throws DataNotInitialisedException {
        DataSet dataSet;
        int[] sacs;
        DictionaryAreaSacs dictAreaSacs = null;
        List<DataSet> dataSets = this.m_dataSets.get(dictType);
        if (dataSets != null && (sacs = (dataSet = dataSets.get(area.getDataSetInfo().getDataSetNumber())).getAreaSacs(area, options)) != null) {
            dictAreaSacs = new DictionaryAreaSacs(area, sacs);
        }
        return dictAreaSacs;
    }

    protected final Collection<InternalScoringAddress> findCandidates(DataSetInfo dataSetInfo, int[] sacs, List<DictionaryAddressWord> dictAddrWordList, GeocodeOptions options) throws CGGEInternalException, IOException {
        DataSet dataSet = this.getDataSet(dataSetInfo);
        List<InternalScoringAddress> cands = null;
        int sacItems = sacs.length;
        int dictNum = this.getDictionaryNumber();
        for (int sacNdx = 0; sacNdx < sacItems; ++sacNdx) {
            Collection<InternalScoringAddress> curCands = dataSet.findCandidates(sacs[sacNdx], dictAddrWordList, options, dictNum);
            cands = ListUtils.addToList(cands, curCands);
        }
        if (cands != null) {
            this.setDataTypeAndDictionaryNumber(cands, dataSetInfo);
        }
        return cands;
    }

    private void setDataTypeAndDictionaryNumber(List<InternalScoringAddress> cands, DataSetInfo dataSetInfo) {
        if (cands != null) {
            for (InternalScoringAddress cand : cands) {
                this.setDataTypeAndDictionaryNumber(cand, dataSetInfo);
            }
        }
    }

    private void setDataTypeAndDictionaryNumber(InternalScoringAddress cand, DataSetInfo dataSetInfo) {
        InternalStreetAddress address = cand.getInternalStreetAddress();
        address.setDataSetInfo(dataSetInfo);
        List<InternalRangeAddress> rangeList = address.getRangeList();
        if (rangeList != null) {
            for (InternalRangeAddress range : rangeList) {
                range.setDataSetInfo(dataSetInfo);
                List<InternalUnitAddress> unitList = range.getUnits();
                if (unitList == null) continue;
                for (InternalUnitAddress unit : unitList) {
                    unit.setDataSetInfo(dataSetInfo);
                }
            }
        }
    }

    public List<DictionaryAddressWord> getMatchingWords(int dictType, AddressWord word, FieldType type, double minQuality, GeocodeOptions options) throws DataNotInitialisedException {
        ArrayList<DictionaryAddressWord> retDictAddrWordList = null;
        List<DataSet> dataSets = this.m_dataSets.get(dictType);
        if (dataSets != null) {
            for (DataSet dataSet : dataSets) {
                List<AddressWord> addrWords;
                int wordSize;
                if (!this.canSearchDataset(dataSet, options) || (wordSize = (addrWords = dataSet.getMatchingWords(word, type, minQuality)) == null ? 0 : addrWords.size()) <= 0) continue;
                if (retDictAddrWordList == null) {
                    retDictAddrWordList = new ArrayList<DictionaryAddressWord>(wordSize);
                }
                DataSetInfo dataSetInfo = dataSet.getDataSetInfo();
                for (int wordNdx = 0; wordNdx < wordSize; ++wordNdx) {
                    AddressWord addrWord = addrWords.get(wordNdx);
                    DictionaryAddressWord dictWord = new DictionaryAddressWord(addrWord, word);
                    dictWord.setMatchQuality(addrWord.m_quality);
                    dictWord.setDataSetInfo(dataSetInfo);
                    retDictAddrWordList.add(dictWord);
                }
            }
        }
        return retDictAddrWordList;
    }

    private boolean canSearchDataset(DataSet dataSet, GeocodeOptions options) {
        List dataSetList = (List)options.get(KEY_ALLOWED_DATASETS);
        boolean flag = true;
        if (dataSetList == null) {
            flag = this.canSearchAllowedDataset(dataSet, options);
        } else {
            String dataSetName = dataSet.getDataSetInfo().getName();
            for (String string : dataSetList) {
                if (!StringUtilities.isEmpty((String)dataSetName) && dataSetName.equalsIgnoreCase(string)) {
                    flag = true;
                    break;
                }
                flag = false;
            }
        }
        return flag;
    }

    private boolean canSearchAllowedDataset(DataSet dataSet, GeocodeOptions options) {
        boolean flag = true;
        List dataSetList = (List)options.get(KEY_ALLOWED_DATASETS_LIST);
        if (dataSetList != null) {
            flag = dataSetList.contains(dataSet.getDataSetInfo());
        }
        return flag;
    }

    @Override
    public int getDictionaryNumber() {
        return this.m_dictionaryNumber;
    }

    public List<DirectPosition> getGeometry(DataSetInfo dataSetInfo, InternalAddress addr) throws CGGEInternalException, IOException {
        return this.getDataSet(dataSetInfo).getGeometry(addr);
    }

    private DataSet getDataSet(int geocodeType) throws CGGEInternalException {
        List<DataSet> dataSets = this.m_dataSets.get(geocodeType);
        if (dataSets == null) {
            throw new CGGEInternalException("Data for type " + geocodeType + " not loaded");
        }
        return dataSets.get(0);
    }

    public boolean isSupportedType(int geocodeType) {
        return this.m_dataSets.get(geocodeType) != null;
    }

    public IDictionaryMetaData getMetaData(DataSetInfo dataSetInfo) throws CGGEInternalException {
        return this.getDataSet(dataSetInfo).getMetaData();
    }

    public IDictionaryMetaData getMetaData(int type) throws CGGEInternalException {
        return this.getDataSet(type).getMetaData();
    }

    public void readAdditionalFields(DataSetInfo dataSetInfo, InternalAddress addr) throws IOException, CGGEInternalException {
        this.getDataSet(dataSetInfo).readAdditionalFields(addr);
    }

    public Collection<DataSet> getDataSets() {
        if (this.m_dataSets != null) {
            List dataSets = null;
            Collection<List<DataSet>> dataSetCol = this.m_dataSets.values();
            Iterator<List<DataSet>> it = dataSetCol.iterator();
            while (it.hasNext()) {
                dataSets = ListUtils.addToList(dataSets, (Collection)it.next());
            }
            return dataSets;
        }
        return null;
    }

    @Override
    public List<Integer> getSupportedGeocodeTypes() {
        if (this.m_dataSets != null) {
            return new ArrayList<Integer>(this.m_dataSets.keySet());
        }
        return null;
    }

    @Override
    public boolean isUserDictionary() {
        Collection<DataSet> dataSets = this.getDataSets();
        if (dataSets != null && dataSets.size() > 0) {
            for (DataSet dataSet : dataSets) {
                if (!dataSet.getMetaData().isUserDictionary()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<InternalStreetAddress> retrieveReverseGeocodeCandidates(int dictionaryType, DirectPosition position, Length length, GeocodeOptions options, IDataManager dataManager) throws DataAccessRuntimeException, FatalDataAccessRuntimeException, CGGEInternalException {
        if (dictionaryType == 0) {
            Iterator<List<DataSet>> it = this.m_dataSets.values().iterator();
            List<InternalStreetAddress> cands = null;
            while (it.hasNext()) {
                List<InternalStreetAddress> curCands = this.retrieveReverseGeocodeCandidates(it.next(), position, length, options, dataManager);
                cands = ListUtils.addToList(cands, curCands);
            }
            return cands;
        }
        return this.retrieveReverseGeocodeCandidates(this.m_dataSets.get(dictionaryType), position, length, options, dataManager);
    }

    private List<InternalStreetAddress> retrieveReverseGeocodeCandidates(List<DataSet> dataSets, DirectPosition position, Length distance, GeocodeOptions options, IDataManager dataManager) throws DataAccessRuntimeException, FatalDataAccessRuntimeException, CGGEInternalException {
        double[] closestCandidateDistance = new double[]{Double.MAX_VALUE};
        List<InternalStreetAddress> cands = null;
        if (dataSets != null) {
            for (DataSet dataSet : dataSets) {
                if (!dataSet.isReverseGeocodeSupported()) continue;
                List<InternalStreetAddress> curCands = dataSet.retrieveReverseGeocodeCandidates(position, distance, options, dataManager, closestCandidateDistance);
                cands = ListUtils.addToList(cands, curCands);
            }
        }
        return cands;
    }

    @Override
    public boolean isReverseGeocodeSupported(int dictionaryType) {
        if (dictionaryType == 0) {
            Iterator<List<DataSet>> it = this.m_dataSets.values().iterator();
            while (it.hasNext()) {
                if (!this.isReverseGeocodeSupported(it.next())) continue;
                return true;
            }
            return false;
        }
        return this.isReverseGeocodeSupported(this.m_dataSets.get(dictionaryType));
    }

    private boolean isReverseGeocodeSupported(List<DataSet> dataSets) {
        if (dataSets != null) {
            for (DataSet dataSet : dataSets) {
                if (!dataSet.isReverseGeocodeSupported()) continue;
                return true;
            }
        }
        return false;
    }

    private DataSet getDataSet(DataSetInfo info) {
        List<DataSet> dataSets = this.m_dataSets.get(info.getGeocodeType());
        return dataSets.get(info.getDataSetNumber());
    }

    public List<DataSet> getDataSets(int dictionaryType) {
        return this.m_dataSets.get(dictionaryType);
    }

    public List<FieldType> getSACSearchFields(int dictionaryType) {
        List<DataSet> dataSets = this.getDataSets(dictionaryType);
        List<FieldType> sacSearchFields = null;
        for (DataSet dataSet : dataSets) {
            IDictionaryMetaData md = dataSet.getMetaData();
            sacSearchFields = ListUtils.addToList(sacSearchFields, md.getSacSearchFields());
        }
        ListUtils.removeDuplicates(sacSearchFields);
        return Collections.unmodifiableList(sacSearchFields);
    }

    public List<FieldType> getAddressSearchFields(int dictionaryType) {
        List<DataSet> dataSets = this.getDataSets(dictionaryType);
        List<FieldType> addrSearchFields = null;
        for (DataSet dataSet : dataSets) {
            IDictionaryMetaData md = dataSet.getMetaData();
            addrSearchFields = ListUtils.addToList(addrSearchFields, md.getSearchFields());
        }
        ListUtils.removeDuplicates(addrSearchFields);
        return Collections.unmodifiableList(addrSearchFields);
    }
}

