/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.dp.AddressDictionary;
import com.mapinfo.mapmarker.cgge.dp.AddressHandle;
import com.mapinfo.mapmarker.cgge.dp.AreaNameDictionary;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.ReverseGeocodeAddressDictionary;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.cgge.utils.RGUtils;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.unit.Length;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class DataSet {
    private static final String KEY_PREV_CANDS_NDXS_FROM_SAC = "prev_cands_ndxs_from_sac_";
    private AddressDictionary m_addrDictionary;
    private ICGGEScorer m_scorer;
    private ICGGEParser m_parser;
    private ICGGESoundex m_soundex;
    private ReverseGeocodeAddressDictionary m_rgAddressDictionary;
    private DataSetInfo m_dataSetInfo;

    public static DataSet getInstance(String path, String dataName, int dictNum, int dataSetNum) throws Exception {
        DataSet dataSet = new DataSet();
        dataSet.initAddressDictionary(path, dataName);
        dataSet.initDataSetInfo(dataName, dictNum, dataSetNum);
        return dataSet;
    }

    private void initAddressDictionary(String path, String dataName) throws Exception {
        String fullPath = MMUtils.appendToPath(path, dataName);
        this.m_addrDictionary = this.getAddressDictionaryInstance(fullPath);
    }

    public boolean loadData(String path, String dataName) throws Exception {
        CGGEHandler handler = CGGEHandler.getInstance(this.m_dataSetInfo, this.m_dataSetInfo.getCountry(), this.m_dataSetInfo.getLanguage());
        this.loadData(this.m_addrDictionary, path, dataName, handler);
        return true;
    }

    AddressDictionary getAddressDictionaryInstance(String fullPath) throws Exception {
        AddressDictionary addrDict = AddressDictionary.getAddressDictionaryInstance(fullPath);
        return addrDict;
    }

    void initDataSetInfo(String dataName, int dictNum, int dataSetNum) {
        AddressDictionary addrDictionary = this.getAddressDictionary();
        IDictionaryMetaData metaData = addrDictionary.getMetaData();
        this.m_dataSetInfo = new DataSetInfo(addrDictionary.getMetaData(), dataName, dictNum, dataSetNum, metaData.getDictionaryType());
        this.m_dataSetInfo.setDataSetConfiguration(addrDictionary.getDataSetConfiguration());
    }

    void loadData(AddressDictionary addrDictionary, String path, String dataName, CGGEHandler handler) throws Exception {
        String fullPath = MMUtils.appendToPath(path, dataName);
        addrDictionary.loadDictionary(fullPath, handler);
        if (this.getMetaData().isReverseGeocodingSupported()) {
            this.m_rgAddressDictionary = new ReverseGeocodeAddressDictionary(addrDictionary.getMetaData());
            this.m_rgAddressDictionary.loadSpatialIndexes(path, dataName);
        }
    }

    public void setDataSetInfo(DataSetInfo dataSetInfo) {
        this.m_dataSetInfo = dataSetInfo;
    }

    public DataSetInfo getDataSetInfo() {
        return this.m_dataSetInfo;
    }

    public List<InternalStreetAddress> retrieveReverseGeocodeCandidates(DirectPosition position, Length distance, GeocodeOptions options, IDataManager dataManager, double[] currentClosestCandidateDistance) throws DataAccessRuntimeException, FatalDataAccessRuntimeException, CGGEInternalException {
        SpatialIndexValue.WrappedSpatialIndexValue value;
        ArrayList<InternalStreetAddress> candidates = new ArrayList<InternalStreetAddress>();
        List<SpatialIndexValue> spatialIndexes = this.m_rgAddressDictionary.getSpatialIndexValues(position, distance);
        ArrayList<SpatialIndexValue.WrappedSpatialIndexValue> wrappedValues = new ArrayList<SpatialIndexValue.WrappedSpatialIndexValue>(spatialIndexes.size());
        for (SpatialIndexValue value2 : spatialIndexes) {
            wrappedValues.add(value2.getWrappedSpatialIndexValue(position));
        }
        SpatialIndexValue.sortAndRemoveDuplicates(wrappedValues);
        AddressHandle addressHandle = null;
        int refrenceSac = 0;
        DataSetInfo dataSetInfo = this.getDataSetInfo();
        Iterator iterator = wrappedValues.iterator();
        while (iterator.hasNext() && !(currentClosestCandidateDistance[0] + 1.0 < (value = (SpatialIndexValue.WrappedSpatialIndexValue)iterator.next()).getDistance())) {
            SpatialIndexValue spatialValue = value.getValue();
            int sac = spatialValue.getSac();
            if (addressHandle == null || refrenceSac != sac) {
                addressHandle = this.getAddressHandle(sac, options);
                refrenceSac = sac;
            }
            InternalStreetAddress street = this.fetchAddress(addressHandle, spatialValue, dataSetInfo);
            for (InternalRangeAddress range : street.getRangeList()) {
                range.setDataSetInfo(street.getDataSetInfo());
                try {
                    range.setPoints(this.getGeometry(range));
                }
                catch (IOException e) {
                    throw new DataAccessRuntimeException(new DataAccessException(2102, (Object[])new String[]{"CGGE data fetch exception caused " + e.getMessage()}));
                }
            }
            List<InternalStreetAddress> brokenUpStreets = RGUtils.breakUpPointAddressRanges(Collections.singletonList(street));
            for (InternalStreetAddress s : brokenUpStreets) {
                candidates.add(s);
                this.computeDistance(position, s);
                if (!(s.getDistance() < currentClosestCandidateDistance[0])) continue;
                currentClosestCandidateDistance[0] = street.getDistance();
            }
        }
        return candidates;
    }

    private InternalStreetAddress fetchAddress(AddressHandle addrHandle, SpatialIndexValue spatialValue, DataSetInfo dataSetInfo) throws CGGEInternalException {
        if (this.getMetaData().getVersion() < 2) {
            return addrHandle.getAddressAtOffset(spatialValue.getStreetStartOffset(), spatialValue.getAddressSize(), this.getParser(), this.getSoundex(), dataSetInfo);
        }
        return addrHandle.getAddressAtIndex((int)spatialValue.getStreetStartOffset(), this.getParser(), this.getSoundex(), dataSetInfo);
    }

    private void removeDuplicates(List<SpatialIndexValue.WrappedSpatialIndexValue> values) {
        TreeSet<Long> previousOffsets = new TreeSet<Long>();
        Iterator<SpatialIndexValue.WrappedSpatialIndexValue> it = values.iterator();
        while (it.hasNext()) {
            SpatialIndexValue.WrappedSpatialIndexValue value = it.next();
            if (previousOffsets.contains(value.getValue().getStreetStartOffset())) {
                it.remove();
                continue;
            }
            previousOffsets.add(value.getValue().getStreetStartOffset());
        }
    }

    private void computeDistance(DirectPosition position, InternalStreetAddress streetAddress) {
        streetAddress.setDistance(Double.MAX_VALUE);
        List<InternalRangeAddress> rangeList = streetAddress.getRangeList();
        int rangeCounts = rangeList != null ? rangeList.size() : 0;
        for (int rangeCount = 0; rangeCount < rangeCounts; rangeCount = (int)((short)(rangeCount + 1))) {
            InternalRangeAddress range = rangeList.get(rangeCount);
            CoordSys srcCoordSys = streetAddress.getDataSetInfo().getMetaData().getSourceCoordSysObject();
            List points = CoordConvertor.transformPointsToWGS84((CoordSys)srcCoordSys, range.getPoints());
            double distance = ReverseGeocodeUtils.getDistance((DirectPosition)position, (List)points);
            range.setDistance(distance);
            if (!(distance < streetAddress.getDistance())) continue;
            streetAddress.setDistance(distance);
        }
    }

    public int[] getAreaSacs(DictionaryAreaTermItem area, GeocodeOptions options) throws DataNotInitialisedException {
        return this.getAreaNameDictionary().getAreaSacs(area.getIndexCode());
    }

    private ICGGEScorer getScorer() {
        if (this.m_scorer == null) {
            DataSetInfo dataSetInfo = this.getDataSetInfo();
            this.m_scorer = CGGEHandler.getInstance(dataSetInfo, dataSetInfo.getCountry(), dataSetInfo.getLanguage()).getScorer();
        }
        return this.m_scorer;
    }

    private final ICGGEParser getParser() {
        if (this.m_parser == null) {
            DataSetInfo dataSetInfo = this.getDataSetInfo();
            this.m_parser = CGGEHandler.getInstance(dataSetInfo, dataSetInfo.getCountry(), dataSetInfo.getLanguage()).getParser();
        }
        return this.m_parser;
    }

    private final ICGGESoundex getSoundex() {
        if (this.m_soundex == null) {
            DataSetInfo dataSetInfo = this.getDataSetInfo();
            this.m_soundex = CGGEHandler.getInstance(dataSetInfo, dataSetInfo.getCountry(), dataSetInfo.getLanguage()).getSoundex();
        }
        return this.m_soundex;
    }

    public Collection<DictionaryAreaTermItem> findAreaTerms(AddressWord[] searchWords, FieldType type, double minQuality) throws IOException, DataNotInitialisedException {
        int wordsLen = searchWords == null ? 0 : searchWords.length;
        ArrayList<DictionaryAreaTermItem> areaList = new ArrayList<DictionaryAreaTermItem>(10);
        IntArray savedAreaIndexes = new IntArray(10);
        ICGGEScorer scorer = this.getScorer();
        AreaNameDictionary areaDictionary = this.getAreaNameDictionary();
        for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
            AddressWord wordToSearch = searchWords[wordNdx];
            if (wordToSearch == null) continue;
            ArrayList<DictionaryAreaTermItem> curList = areaDictionary.findAreaTerms(wordToSearch, type, minQuality, scorer);
            int size = curList == null ? 0 : curList.size();
            for (int areaNdx = 0; areaNdx < size; ++areaNdx) {
                DictionaryAreaTermItem term = (DictionaryAreaTermItem)curList.get(areaNdx);
                term.setDataSetInfo(this.getDataSetInfo());
                int areaCode = term.m_indexCode;
                int savedPos = savedAreaIndexes.indexOf(areaCode);
                if (savedPos > -1) {
                    DictionaryAreaTermItem savedTerm = areaList.get(savedPos);
                    DictionaryAddressWord[] matchedWords = term.m_matchedWords;
                    DictionaryAddressWord[] savedTermMatchedWords = savedTerm.m_matchedWords;
                    if (matchedWords != null && savedTermMatchedWords != null) {
                        for (int m = 0; m < matchedWords.length; ++m) {
                            DictionaryAddressWord savedMatchedWord;
                            DictionaryAddressWord matchedWord = matchedWords[m];
                            if (matchedWord == null || (savedMatchedWord = savedTermMatchedWords[m]) != null && !(savedMatchedWord.getMatchQuality() < matchedWord.getMatchQuality())) continue;
                            savedTerm.addMatchedWord(matchedWord, m);
                        }
                    } else {
                        savedTermMatchedWords = matchedWords;
                    }
                    savedTerm.m_matchedWords = savedTermMatchedWords;
                    continue;
                }
                areaList.add(term);
                savedAreaIndexes.add(areaCode);
            }
        }
        return ListUtils.isEmpty(areaList) ? null : this.filterAreaItems(areaList, searchWords, scorer, minQuality);
    }

    protected Collection<DictionaryAreaTermItem> filterAreaItems(Collection<DictionaryAreaTermItem> areaList, AddressWord[] searchWords, ICGGEScorer scorer, double minQuality) {
        Iterator<DictionaryAreaTermItem> it = areaList.iterator();
        while (it.hasNext()) {
            boolean add;
            DictionaryAreaTermItem term = it.next();
            AddressWord[] areaWords = term.getAreaAddressWords();
            int wordCount = areaWords.length;
            double quality = 0.0;
            int matchedWordCount = 0;
            if (term.m_matchedWords == null) continue;
            for (int wordndx = 0; wordndx < wordCount; ++wordndx) {
                double weight = (double)areaWords[wordndx].m_weight * 0.01;
                if (term.m_matchedWords[wordndx] == null) continue;
                quality += term.m_matchedWords[wordndx].getMatchQuality() * weight;
                ++matchedWordCount;
            }
            boolean bl = add = quality >= minQuality;
            if (!add && matchedWordCount < searchWords.length && this.doFullScore(term, searchWords, quality, minQuality, scorer)) {
                FieldScore score = scorer.scoreAddressWords(searchWords, areaWords, term.getFieldType(), null);
                quality = score.m_value;
                boolean bl2 = add = quality >= minQuality;
            }
            if (add) {
                term.setQuality(quality);
                continue;
            }
            it.remove();
        }
        if (areaList.size() > 0) {
            return areaList;
        }
        return null;
    }

    private boolean doFullScore(DictionaryAreaTermItem item, AddressWord[] searchWords, double quality, double minQuality, ICGGEScorer scorer) {
        DictionaryAddressWord[] matchedAreaWords = item.m_matchedWords;
        double possibleQualityUplift = 0.0;
        double rejectedQuality = 0.0;
        if (matchedAreaWords != null) {
            AddressWord[] areaWords = item.getAreaAddressWords();
            int n = item.getWordCount();
            for (int i = 0; i < n; ++i) {
                if (matchedAreaWords[i] != null) continue;
                AddressWord areaWord = areaWords[i];
                if (areaWord.m_weight <= 0) continue;
                boolean matched = false;
                for (AddressWord searchWord : searchWords) {
                    if (item.hasMatchedWord(searchWord) || !scorer.canMatchWords(areaWord, searchWord)) continue;
                    possibleQualityUplift += (double)areaWord.m_weight * 0.01;
                    matched = true;
                }
                if (matched || !(1.0 - (rejectedQuality += (double)areaWord.m_weight * 0.01) < minQuality)) continue;
                return false;
            }
        }
        return quality + possibleQualityUplift >= minQuality;
    }

    public IDictionaryMetaData getMetaData() {
        return this.m_addrDictionary.getMetaData();
    }

    private final AddressHandle getAddressHandle(int sac, GeocodeOptions options) throws CGGEInternalException {
        AddressHandle handle = this.m_addrDictionary.findAddressHandleForSAC(sac);
        if (handle != null) {
            handle.setAreaNameDictionary(this.getAreaNameDictionary());
        }
        return handle;
    }

    protected Collection<InternalScoringAddress> findCandidates(int sac, List<DictionaryAddressWord> dictAddrWordList, GeocodeOptions options, int dictNum) throws CGGEInternalException, IOException {
        if (DebugLevel.getDebugLevel((int)3) >= 3) {
            MMJLog.getLog().debug("DataSet::findCandidates sac: " + sac);
            MMJLog.getLog().debug("DataSet::findCandidates wordCount: " + dictAddrWordList.size());
        }
        IDictionaryMetaData metaData = this.getMetaData();
        ArrayList<InternalScoringAddress> curCanList = null;
        AddressHandle handle = this.getAddressHandle(sac, options);
        DataSetInfo dataSetInfo = this.getDataSetInfo();
        if (handle != null) {
            int wordCount = dictAddrWordList.size();
            StringBuilder builder = new StringBuilder();
            builder.append(KEY_PREV_CANDS_NDXS_FROM_SAC);
            builder.append(sac);
            builder.append("_");
            builder.append(dictNum);
            builder.append("_");
            builder.append(dataSetInfo.getDataSetNumber());
            String savedSacCandidateKey = builder.toString();
            HashMap<Integer, InternalScoringAddress> fetchedCands = (HashMap<Integer, InternalScoringAddress>)options.get(savedSacCandidateKey);
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                int[] ndxs;
                int addrCount;
                AddressWord addrWord = dictAddrWordList.get(wordNdx).getAddressWord();
                if (DebugLevel.getDebugLevel((int)3) >= 3) {
                    MMJLog.getLog().debug("DataSet::findCandidates addrWord:");
                    MMJLog.getLog().debug("\t" + addrWord.toString());
                }
                int n = addrCount = (ndxs = handle.findAddressIndexesFromWords(addrWord)) == null ? 0 : ndxs.length;
                if (DebugLevel.getDebugLevel((int)3) >= 3) {
                    MMJLog.getLog().debug("DataSet::findCandidates addrCount: " + addrCount);
                }
                for (int addrOffset = 0; addrOffset < addrCount; ++addrOffset) {
                    InternalScoringAddress fetchedCandidate;
                    int ndx = ndxs[addrOffset];
                    if (curCanList == null) {
                        curCanList = new ArrayList<InternalScoringAddress>(addrCount);
                    }
                    if (fetchedCands == null) {
                        fetchedCands = new HashMap<Integer, InternalScoringAddress>();
                        options.put(savedSacCandidateKey, fetchedCands);
                    }
                    if ((fetchedCandidate = (InternalScoringAddress)fetchedCands.get(new Integer(ndx))) == null) {
                        InternalStreetAddress address = handle.getAddressAtIndex(ndx, this.getParser(), this.getSoundex(), dataSetInfo);
                        InternalScoringAddress cand = new InternalScoringAddress(address);
                        curCanList.add(cand);
                        fetchedCands.put(new Integer(ndx), cand);
                        fetchedCandidate = cand;
                    }
                    fetchedCandidate.addSearchWord(addrWord);
                    if (DebugLevel.getDebugLevel((int)3) < 3) continue;
                    MMJLog.getLog().debug("DataSet::findCandidates fetchedCandidate");
                    MMJLog.getLog().debug(fetchedCandidate.toString());
                }
            }
        }
        return curCanList;
    }

    public List<AddressWord> getMatchingWords(AddressWord word, FieldType type, double minQuality) throws DataNotInitialisedException {
        if (type.getLevel() == FieldType.FieldLevel.LEVEL_POSTAL) {
            return this.getAreaNameDictionary().getMatchingWords(word, this.getScorer(), minQuality);
        }
        return this.getAddressDictionary().getMatchingWords(word, this.getScorer(), minQuality);
    }

    public List<DirectPosition> getGeometry(InternalAddress internalAddress) throws IOException {
        return this.getAddressDictionary().getGeometry(internalAddress);
    }

    public void readAdditionalFields(InternalAddress addr) throws IOException {
        this.m_addrDictionary.readAdditionalFields(addr);
    }

    public boolean isReverseGeocodeSupported() {
        return this.m_addrDictionary.getMetaData().isReverseGeocodingSupported();
    }

    protected AddressDictionary getAddressDictionary() {
        return this.m_addrDictionary;
    }

    protected AreaNameDictionary getAreaNameDictionary() {
        return this.getAddressDictionary().getAreaNameDictionary();
    }
}

