/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Properties;

public class DataSetInfo
implements Comparable<DataSetInfo> {
    private final String m_name;
    private final int m_dictionaryNumber;
    private int m_dataSetNumber;
    private final int m_geocodeType;
    private final IDictionaryMetaData m_metaData;
    private static final int HASH_CODE_PRIME = 31;
    private Properties m_dataSetConfiguration;

    public String getDataSetInfoKey() {
        return this.m_name + this.hashCode();
    }

    public DataSetInfo(IDictionaryMetaData metaData, String name, int dictNum, int dataSetNum, int type) {
        this.m_name = name;
        this.m_dictionaryNumber = dictNum;
        this.m_dataSetNumber = dataSetNum;
        this.m_geocodeType = type;
        this.m_metaData = metaData;
    }

    public String getName() {
        return this.m_name;
    }

    public int getDictionaryNumber() {
        return this.m_dictionaryNumber;
    }

    public int getDataSetNumber() {
        return this.m_dataSetNumber;
    }

    public void setDataSetNumber(int dataSetNum) {
        this.m_dataSetNumber = dataSetNum;
    }

    public int getGeocodeType() {
        return this.m_geocodeType;
    }

    public IDictionaryMetaData getMetaData() {
        return this.m_metaData;
    }

    public int hashCode() {
        String country;
        int base = this.m_dataSetNumber;
        base *= 31;
        base += this.m_dictionaryNumber;
        base *= 31;
        base += this.m_geocodeType;
        base *= 31;
        if (this.getMetaData() != null && (country = this.getMetaData().getCountry()) != null) {
            base += country.hashCode();
        }
        return base;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DataSetInfo) {
            DataSetInfo other = (DataSetInfo)o;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public boolean equals(DataSetInfo other) {
        return this == other || this.compareTo(other) == 0;
    }

    @Override
    public int compareTo(DataSetInfo o) {
        int c = this.m_dictionaryNumber - o.m_dictionaryNumber;
        if (c == 0) {
            c = this.m_geocodeType - o.m_geocodeType;
        }
        if (c == 0) {
            c = this.m_dataSetNumber - o.m_dataSetNumber;
        }
        if (c == 0) {
            IDictionaryMetaData m1 = this.getMetaData();
            IDictionaryMetaData m2 = o.getMetaData();
            if (m1 != null && m2 != null) {
                c = MMUtils.compare(m1.getCountry(), m2.getCountry());
                if (c == 0) {
                    c = MMUtils.compare(m1.getLanguage(), m2.getLanguage());
                }
            } else {
                c = m1 == null && m2 == null ? 0 : (m1 == null ? -1 : 1);
            }
        }
        return c;
    }

    public Properties getDataSetConfiguration() {
        return this.m_dataSetConfiguration;
    }

    public void setDataSetConfiguration(Properties m_dataSetConfiguration) {
        this.m_dataSetConfiguration = m_dataSetConfiguration;
    }

    public String getCountry() {
        return this.m_metaData.getCountry();
    }

    public String getLanguage() {
        return this.m_metaData.getLanguage();
    }
}

