/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.AbstractDictionaryItem;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;

public class DictionaryAreaTermItem
extends AbstractDictionaryItem
implements Comparable<DictionaryAreaTermItem> {
    public AddressWord[] m_areaWords;
    public int m_indexCode;
    public double m_quality;
    protected DictionaryAddressWord[] m_matchedWords;

    public DictionaryAreaTermItem(AddressWord[] areaWords, FieldType type) {
        if (areaWords == null) {
            throw new NullPointerException("areaWords is null");
        }
        this.m_areaWords = areaWords;
        this.setFieldType(type);
        this.m_indexCode = -1;
    }

    @Override
    public int compareTo(DictionaryAreaTermItem o) {
        return this.compare(this, o);
    }

    @Override
    public int compare(DictionaryAreaTermItem at1, DictionaryAreaTermItem at2) {
        int c = super.compare(at1, at2);
        if (c == 0) {
            if (at1.m_indexCode == -1 || at2.m_indexCode == -1) {
                int wc2;
                int wc1 = at1.getWordCount();
                if (wc1 > (wc2 = at2.getWordCount())) {
                    return 1;
                }
                if (wc1 < wc2) {
                    return -1;
                }
                AddressWord[] addrWords1 = at1.m_areaWords;
                AddressWord[] addrWords2 = at2.m_areaWords;
                for (int i = 0; i < wc1; ++i) {
                    c = addrWords1[i].compareTo(addrWords2[i]);
                    if (c == 0) continue;
                    return c;
                }
            } else {
                return at1.m_indexCode - at2.m_indexCode;
            }
        }
        return c;
    }

    public AddressWord[] getAreaAddressWords() {
        return this.m_areaWords;
    }

    public int getWordCount() {
        return this.m_areaWords == null ? 0 : this.m_areaWords.length;
    }

    public int getIndexCode() {
        return this.m_indexCode;
    }

    public void setAreaCodedWords(AddressWord[] codes) {
        this.m_areaWords = codes;
    }

    public void setIndexCode(int i) {
        this.m_indexCode = i;
    }

    @Override
    public boolean equals(Object obj) {
        return this.compare(this, (DictionaryAreaTermItem)obj) == 0;
    }

    public double getQuality() {
        return this.m_quality;
    }

    public void setQuality(double s) {
        this.m_quality = s;
    }

    @Override
    public int hashCode() {
        int hash = this.m_indexCode * this.getFieldType().getKey() * this.getWordCount() ^ this.m_areaWords[0].hashCode();
        return hash;
    }

    public DictionaryAddressWord[] getMatchedWords() {
        return this.m_matchedWords;
    }

    public int getMatchedWordCount() {
        int c = 0;
        if (this.m_matchedWords != null) {
            for (int wordNdx = 0; wordNdx < this.m_matchedWords.length; ++wordNdx) {
                if (this.m_matchedWords[wordNdx] == null) continue;
                ++c;
            }
        }
        return c;
    }

    public boolean hasMatchedWord(AddressWord word) {
        if (this.m_matchedWords != null) {
            for (DictionaryAddressWord dictWord : this.m_matchedWords) {
                if (dictWord == null || dictWord.getSearchWord() != word) continue;
                return true;
            }
        }
        return false;
    }

    public void addMatchedWord(DictionaryAddressWord word, int ndx) {
        if (this.m_matchedWords == null) {
            this.m_matchedWords = new DictionaryAddressWord[this.m_areaWords.length];
        }
        this.m_matchedWords[ndx] = word;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append(lineSeparator);
        builder.append(lineSeparator);
        builder.append(this.getClass().getSimpleName());
        builder.append(lineSeparator);
        builder.append("fieldType: ");
        builder.append(this.getFieldType() == null ? "none" : this.getFieldType().toString());
        builder.append(lineSeparator);
        builder.append("dictionaryNumber: ");
        builder.append(this.getDictionaryNumber());
        builder.append(lineSeparator);
        builder.append("quailty: ");
        builder.append(this.getQuality());
        builder.append(lineSeparator);
        builder.append("indexCode: ");
        builder.append(this.getIndexCode());
        builder.append(lineSeparator);
        builder.append("areaWords:");
        if (this.getAreaAddressWords() != null) {
            builder.append(lineSeparator);
            builder.append(lineSeparator);
            for (Comparable<AddressWord> comparable : this.getAreaAddressWords()) {
                builder.append('\t');
                builder.append(((AddressWord)comparable).toString());
                builder.append(lineSeparator);
            }
        } else {
            builder.append("none");
            builder.append(lineSeparator);
        }
        builder.append("matchedWords: ");
        if (this.getMatchedWords() != null) {
            for (Comparable<AddressWord> comparable : this.getMatchedWords()) {
                builder.append(((DictionaryAddressWord)comparable).toString());
                builder.append(lineSeparator);
            }
        } else {
            builder.append("none");
            builder.append(lineSeparator);
        }
        return builder.toString();
    }
}

