/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.dp.IDictionaryFieldItem;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryItem;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class DictionaryItemUtils {
    public static Comparator<IDictionaryItem> getDictionaryItemComparator() {
        return new Comparator<IDictionaryItem>(){

            @Override
            public final int compare(IDictionaryItem o1, IDictionaryItem o2) {
                return MMUtils.compare(o1.getDataSetInfo(), o2.getDataSetInfo());
            }
        };
    }

    private static final int compare(IDictionaryFieldItem o1, IDictionaryFieldItem o2) {
        int c = MMUtils.compare(o1.getDataSetInfo(), o2.getDataSetInfo());
        if (c == 0) {
            c = MMUtils.compare(o1.getFieldType(), o2.getFieldType());
        }
        return c;
    }

    public static Comparator<IDictionaryFieldItem> getDictionaryFieldItemComparator() {
        return new Comparator<IDictionaryFieldItem>(){

            @Override
            public int compare(IDictionaryFieldItem o1, IDictionaryFieldItem o2) {
                return DictionaryItemUtils.compare(o1, o2);
            }
        };
    }

    public static final boolean fromSameDataSet(IDictionaryItem o1, IDictionaryItem o2) {
        return MMUtils.compare(o1.getDataSetInfo(), o2.getDataSetInfo()) == 0;
    }

    public static <T extends IDictionaryItem> Iterator<List<T>> getGroupedSubListIterator(List<T> list) {
        Collections.sort(list, DictionaryItemUtils.getDictionaryItemComparator());
        return new DataSetInfoGroupedSubListIterator<T>(list);
    }

    private static class DataSetInfoGroupedSubListIterator<T extends IDictionaryItem>
    implements Iterator<List<T>> {
        final List<T> m_list;
        final int m_listSize;
        int m_nextCheckNdx = 0;

        DataSetInfoGroupedSubListIterator(List<T> list) {
            this.m_list = list;
            this.m_listSize = this.m_list.size();
        }

        @Override
        public boolean hasNext() {
            return this.m_nextCheckNdx < this.m_listSize;
        }

        @Override
        public List<T> next() {
            if (this.hasNext()) {
                return this.getNextSubList();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private List<T> getNextSubList() {
            int startNdx = this.m_nextCheckNdx;
            IDictionaryItem item = (IDictionaryItem)this.m_list.get(startNdx);
            int endNdx = startNdx + 1;
            for (int ndx = startNdx + 1; ndx < this.m_listSize; ++ndx) {
                if (!DictionaryItemUtils.fromSameDataSet(item, (IDictionaryItem)this.m_list.get(ndx))) continue;
                ++endNdx;
            }
            this.m_nextCheckNdx = endNdx;
            return this.m_list.subList(startNdx, endNdx);
        }
    }
}

