/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.AreaMetaData;
import com.mapinfo.mapmarker.cgge.dp.CompressedSegment;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.InternalAddressIOHandler;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataInput;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataOutput;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.utils.LongPoint;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalAddressIOHandler1
extends InternalAddressIOHandler {
    InternalAddressIOHandler1() {
    }

    @Override
    public void writeAdditionalFields(Map<FieldType, String> addFields, DataOutput out) throws IOException {
        if (addFields == null) {
            out.write(0);
            return;
        }
        out.write(addFields.size());
        for (Map.Entry<FieldType, String> customField : addFields.entrySet()) {
            out.write(customField.getKey().getKey());
            IOUtil.encodeAndWrite(customField.getValue(), out);
        }
    }

    @Override
    public Map<FieldType, String> readAdditionalFields(DataInput in, IDictionaryMetaData metaData) throws IOException {
        int c = in.readUnsignedByte();
        if (c == 0) {
            return Collections.emptyMap();
        }
        HashMap<FieldType, String> customFieldMap = new HashMap<FieldType, String>();
        for (int i = 0; i < c; ++i) {
            FieldType ft = metaData.getFieldType(in.readUnsignedByte());
            String value = IOUtil.readAndDecode(in);
            customFieldMap.put(ft, value);
        }
        return customFieldMap;
    }

    @Override
    public void writeGeometry(DirectPosition[] geom, AreaMetaData metaData, ICGGEDataOutput out) throws IOException {
        long multiplicationFactor = (long)Math.pow(10.0, metaData.getCoordDecimalPrecision());
        LongPoint[] lngPnts = this.getLongPoints(geom, multiplicationFactor);
        LongPoint offsetPoint = metaData.getOffetPoint();
        out.writeVUnsignedInt(lngPnts.length);
        for (LongPoint lngPnt : lngPnts) {
            IOUtil.writeSignedVLong(lngPnt.getX() - offsetPoint.getX(), out);
            IOUtil.writeSignedVLong(lngPnt.getY() - offsetPoint.getY(), out);
            offsetPoint = lngPnt;
        }
    }

    @Override
    public List<DirectPosition> readGeometry(ICGGEDataInput in, AreaMetaData metaData) throws IOException {
        double multiplicationFactor = Math.pow(10.0, metaData.getCoordDecimalPrecision());
        int pntCount = in.readVUnsignedInt();
        LongPoint offsetPoint = metaData.getOffetPoint();
        long xoffset = offsetPoint.getX();
        long yoffset = offsetPoint.getY();
        ArrayList<DirectPosition> geom = new ArrayList<DirectPosition>(pntCount);
        for (int i = 0; i < pntCount; ++i) {
            long x = xoffset + IOUtil.readSignedVLong(in);
            long y = yoffset + IOUtil.readSignedVLong(in);
            DirectPosition pnt = new DirectPosition((double)x / multiplicationFactor, (double)y / multiplicationFactor);
            geom.add(pnt);
            xoffset = x;
            yoffset = y;
        }
        return geom;
    }

    @Override
    public void writeAreaMetaData(AreaMetaData areaMetaData, ICGGEDataOutput stream) throws IllegalArgumentException, IOException {
        LongPoint position = areaMetaData.getOffetPoint();
        IOUtil.writeSignedVLong(position.getX(), stream);
        IOUtil.writeSignedVLong(position.getY(), stream);
        stream.writeVUnsignedLong(areaMetaData.getFileOffsetAdjust());
    }

    @Override
    public AreaMetaData readAreaMetaData(IDictionaryMetaData metaData, DataInput in) throws IOException {
        LongPoint offsetPoint = new LongPoint(IOUtil.readSignedVLong(in), IOUtil.readSignedVLong(in));
        AreaMetaData areaMetaData = new AreaMetaData();
        areaMetaData.setCoordDecimalPrecision(metaData.getCoordDecimalPrecision());
        areaMetaData.setOffsetPoint(offsetPoint);
        areaMetaData.setFileOffsetAdjust(IOUtil.readVUnsignedNumber(in));
        return areaMetaData;
    }

    @Override
    long readOffset(ICGGEDataInput in, boolean readLongValue) throws IOException {
        return in.readVUnsignedLong();
    }

    @Override
    void writeOffset(ICGGEDataOutput out, long offset, boolean writeLongValue) throws IOException {
        out.writeVUnsignedLong(offset);
    }

    private LongPoint[] getLongPoints(DirectPosition[] geom, long multiplicationFactor) {
        int pointCount = geom.length;
        LongPoint[] lngPnts = new LongPoint[pointCount];
        for (int i = 0; i < pointCount; ++i) {
            lngPnts[i] = new LongPoint(CompressedSegment.convertDoubleToLongAndRound(geom[i].getX(), multiplicationFactor), CompressedSegment.convertDoubleToLongAndRound(geom[i].getY(), multiplicationFactor));
        }
        return lngPnts;
    }
}

