/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexIOHandler;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValueEnvelopeDecorator;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValuePersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.IRGIterator;
import com.mapinfo.mapmarker.common.dp.index.spatial.IndexUtils;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.CompositeRGIndex;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.unit.Length;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReverseGeocodeAddressDictionary {
    private IRGIndex<SpatialIndexValue> m_streetRGIndex;
    private final SpatialIndexIOHandler spatialIndexIOHandler;

    ReverseGeocodeAddressDictionary(IDictionaryMetaData metaData) {
        this.spatialIndexIOHandler = SpatialIndexIOHandler.getInstance(metaData);
    }

    public void loadSpatialIndexes(String filepath, String dictionaryName) {
        this.m_streetRGIndex = this.loadSpatialIndexs(filepath, dictionaryName);
    }

    private IRGIndex<SpatialIndexValue> loadSpatialIndexs(String dictionaryPath, String dictionaryName) {
        File dataDir = new File(dictionaryPath);
        String[] streetRGIndexFiles = dataDir.list(new CGGEStreetRGIndexFilenameFilter(dictionaryName));
        if (streetRGIndexFiles != null && streetRGIndexFiles.length > 0) {
            SpatialIndexValueEnvelopeDecorator geometryDecorator = new SpatialIndexValueEnvelopeDecorator();
            ArrayList<DiskRGIndex> indexes = new ArrayList<DiskRGIndex>(streetRGIndexFiles.length);
            for (String fileName : streetRGIndexFiles) {
                File f = new File(StringUtilities.appendToPath((String)dictionaryPath, (String)fileName));
                SpatialIndexValuePersistenceDecorator fileDecorator = new SpatialIndexValuePersistenceDecorator(this.spatialIndexIOHandler);
                try {
                    indexes.add(new DiskRGIndex(f, (IPersistenceDecorator)fileDecorator, (IEnvelopeDecorator)geometryDecorator));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            return new CompositeRGIndex(indexes);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SpatialIndexValue> getSpatialIndexValues(DirectPosition position, Length distance) {
        IRGIterator<SpatialIndexValue> rgIterator = null;
        boolean bIteratorComplete = false;
        try {
            rgIterator = this.getStreetRGIterator(position, distance);
            if (!rgIterator.hasNext()) {
                List<SpatialIndexValue> list = Collections.emptyList();
                return list;
            }
            ArrayList<SpatialIndexValue> values = new ArrayList<SpatialIndexValue>();
            while (rgIterator.hasNext()) {
                values.add((SpatialIndexValue)rgIterator.next());
            }
            bIteratorComplete = true;
            ArrayList<SpatialIndexValue> arrayList = values;
            return arrayList;
        }
        finally {
            block13: {
                if (rgIterator != null) {
                    try {
                        rgIterator.close();
                    }
                    catch (IOException IOEx) {
                        if (!bIteratorComplete) break block13;
                        throw new DataAccessRuntimeException(new DataAccessException(2102, (Throwable)IOEx));
                    }
                }
            }
        }
    }

    private IRGIterator<SpatialIndexValue> getStreetRGIterator(DirectPosition position, Length searchDistance) throws DataAccessRuntimeException {
        if (this.m_streetRGIndex == null) {
            return new EmptyRGIterator();
        }
        return this.m_streetRGIndex.search(IndexUtils.createRect((DirectPosition)position, (Length)searchDistance));
    }

    private class CGGEStreetRGIndexFilenameFilter
    implements FilenameFilter {
        private String m_DictionaryName;

        CGGEStreetRGIndexFilenameFilter(String dictionaryName) {
            this.m_DictionaryName = dictionaryName;
        }

        @Override
        public boolean accept(File dir, String filename) {
            return filename != null && filename.startsWith(this.m_DictionaryName) && filename.endsWith(".spx");
        }
    }

    private class EmptyRGIterator
    implements IRGIterator<SpatialIndexValue> {
        private EmptyRGIterator() {
        }

        public boolean hasNext() throws DataAccessRuntimeException {
            return false;
        }

        public SpatialIndexValue next() throws DataAccessRuntimeException {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
        }
    }
}

