/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.AreaSacList;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SALocator {
    private static final char DATA_FIELD_SEPERATOR = '|';

    protected static Map<Integer, int[]> loadSACDictionary(InputStream inStream, IDictionaryMetaData metaData) throws IOException {
        BufferedReader r = new BufferedReader(new InputStreamReader(inStream));
        String line = null;
        line = r.readLine();
        int numSATypes = Integer.parseInt(line);
        int[] sizes = new int[numSATypes];
        FieldType[] types = new FieldType[numSATypes];
        for (int i = 0; i < numSATypes; ++i) {
            line = r.readLine();
            int ndx = line.indexOf(124);
            int fieldkey = Integer.parseInt(line.substring(0, ndx));
            types[i] = metaData.getFieldType(fieldkey);
            sizes[i] = Integer.parseInt(line.substring(ndx + 1));
        }
        HashMap<Integer, int[]> areaSacMap = new HashMap<Integer, int[]>();
        for (int i = 0; i < numSATypes; ++i) {
            int areaSacSize = sizes[i];
            for (int j = 0; j < areaSacSize; ++j) {
                int lastndx;
                line = r.readLine();
                int ndx = line.indexOf(124);
                int areaCode = Integer.parseInt(line.substring(0, ndx));
                IntArray sacArray = new IntArray(10);
                while ((lastndx = ndx + 1) < line.length()) {
                    ndx = line.indexOf(124, lastndx);
                    int sac = Integer.parseInt(line.substring(lastndx, ndx));
                    sacArray.add(sac);
                }
                sacArray.sort();
                areaSacMap.put(areaCode, sacArray.asArray());
            }
        }
        return areaSacMap;
    }

    public Map<Integer, int[]> loadSACDictionary(String fileName, IDictionaryMetaData metaData) throws IOException {
        FileInputStream inStream = new FileInputStream(fileName);
        return SALocator.loadSACDictionary(inStream, metaData);
    }

    public static int writeSACDictionary(OutputStream stream, Map<FieldType, List<AreaSacList>> typeToAreaMap) {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(stream));
        PrintWriter sacWriter = new PrintWriter(writer);
        int areasForSAC = typeToAreaMap.size();
        sacWriter.write(Integer.toString(areasForSAC));
        sacWriter.println();
        Set<Map.Entry<FieldType, List<AreaSacList>>> entrySet = typeToAreaMap.entrySet();
        for (Map.Entry<FieldType, List<AreaSacList>> entry : entrySet) {
            FieldType type = entry.getKey();
            sacWriter.write(Integer.toString(type.getKey()));
            sacWriter.write(124);
            sacWriter.write(Integer.toString(entry.getValue().size()));
            sacWriter.println();
        }
        int sacEntries = 0;
        for (Map.Entry<FieldType, List<AreaSacList>> entry : entrySet) {
            List<AreaSacList> areaSacs = entry.getValue();
            for (AreaSacList areaSacList : areaSacs) {
                sacWriter.write(Integer.toString(areaSacList.getAreaCode()));
                sacWriter.write(124);
                int[] sacs = areaSacList.getSacs();
                int sacCount = sacs.length;
                for (int sacNdx = 0; sacNdx < sacCount; ++sacNdx) {
                    sacWriter.write(Integer.toString(sacs[sacNdx]));
                    sacWriter.write(124);
                }
                sacWriter.println();
                ++sacEntries;
            }
        }
        sacWriter.close();
        return sacEntries;
    }
}

