/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import java.util.Map;
import java.util.Properties;

public abstract class RawDataReader {
    public static final String KEY_SAC_COL_NAME = "Sac";
    public static final String KEY_LEFT_SAC_COL_NAME = "LeftSac";
    public static final String KEY_RIGHT_SAC_COL_NAME = "RightSac";
    public static final String KEY_IS_SAC_FROM_FILE = "IsSacFromFile";
    protected static Map<String, FieldType> m_dditionalFieldNames;
    protected Properties m_properties;
    private boolean m_isLeftAndRightSac;
    private boolean m_isSacFromFile;

    public abstract boolean loadData(Properties var1) throws Exception;

    public abstract RawAddress getNextRecord();

    public abstract boolean loadNextFileSet();

    public abstract void rewind();

    public abstract String getCurrentFileSetName();

    public abstract String getCoordSysString();

    protected final void prepareSacMappings() throws InvalidSacException {
        String value = (String)this.m_properties.get(KEY_IS_SAC_FROM_FILE);
        if (value == null || value.trim().length() == 0) {
            throw new InvalidSacException("Mapping for \"IsSacFromFile\" must be specified");
        }
        if (!value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
            throw new InvalidSacException("Mapping for \"IsSacFromFile\" can only be true or false");
        }
        this.m_isSacFromFile = Boolean.parseBoolean(value);
        if (this.m_isSacFromFile && ((value = (String)this.m_properties.get(KEY_SAC_COL_NAME)) == null || value.trim().length() == 0)) {
            value = (String)this.m_properties.get(KEY_LEFT_SAC_COL_NAME);
            if (value == null || value.trim().length() == 0) {
                throw new InvalidSacException("Mapping for \"LeftSac\" must be specified");
            }
            value = (String)this.m_properties.get(KEY_RIGHT_SAC_COL_NAME);
            if (value == null || value.trim().length() == 0) {
                throw new InvalidSacException("Mapping for \"RightSac\" must be specified");
            }
            this.m_isLeftAndRightSac = true;
        }
    }

    public void setAdditionalFields(Map<String, FieldType> map) throws InvalidFieldMappingException {
        m_dditionalFieldNames = map;
    }

    protected abstract void confirmMappings() throws InvalidFieldMappingException;

    protected abstract void populateAdditionalFields(RawAddress var1);

    public void close() {
    }

    public boolean isSacFromFile() {
        return this.m_isSacFromFile;
    }

    public boolean isLeftAndRightSac() {
        return this.m_isLeftAndRightSac;
    }
}

