/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.SacCreator;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.RawAddressReaderWriter;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.IRandomDataInputOutputStream;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class SACSortingReader
extends RawDataReader {
    public static final String SUB_DATA_READER = "subDataReader";
    public static final String FILESET_NAME = "SACSortedFileSet";
    private Map<String, FieldType> m_additionalFields;
    private RawDataReader m_reader;
    private SacCreator m_sacCreator;
    private FieldType m_sacSourceField;
    private boolean m_bDataLoaded;
    private boolean m_currentFileSetLoaded;
    private boolean m_bIsSacFromFile;
    private IRandomDataInputOutputStream m_stream;
    private RawAddressReaderWriter m_readerWriter;
    private List<SACEntry> m_SACEntries;
    private Iterator<SACEntry> m_SACEntryIterator;
    private SACEntryOffsetFile m_sacEntryFile;
    private RetrievableSACEntry m_currentEntry;

    @Override
    public boolean loadData(Properties prop) throws Exception {
        if (this.m_bDataLoaded) {
            throw new IllegalStateException("data already loaded");
        }
        this.createSubReader(prop);
        this.m_reader.setAdditionalFields(this.m_additionalFields);
        boolean loaded = this.m_reader.loadData(prop);
        if (!loaded) {
            return loaded;
        }
        this.m_bIsSacFromFile = this.m_reader.isSacFromFile();
        if (!this.m_bIsSacFromFile) {
            this.createSacCreator(prop);
        }
        this.loadAllDataSets(prop);
        return loaded;
    }

    @Override
    public RawAddress getNextRecord() {
        if (!this.m_bDataLoaded) {
            throw new IllegalStateException("data not loaded");
        }
        if (!this.m_currentEntry.hasNext()) {
            if (this.m_SACEntryIterator.hasNext()) {
                this.m_currentEntry = this.m_SACEntryIterator.next().toRetrievableSACEntry();
                assert (this.m_currentEntry.hasNext());
            } else {
                return null;
            }
        }
        try {
            long offset = this.m_currentEntry.getNext();
            this.m_stream.seek(offset);
            Address address = new Address();
            this.m_readerWriter.read((DataInput)this.m_stream, address);
            return address;
        }
        catch (IOException IOEx) {
            IOEx.printStackTrace(System.err);
            throw new RuntimeException(IOEx);
        }
    }

    @Override
    public boolean loadNextFileSet() {
        if (!this.m_bDataLoaded) {
            return false;
        }
        if (this.m_currentFileSetLoaded) {
            return false;
        }
        this.m_currentFileSetLoaded = true;
        return true;
    }

    @Override
    public void rewind() {
        if (!this.m_bDataLoaded) {
            throw new IllegalStateException("data has not been loaded");
        }
        this.m_SACEntryIterator = this.m_SACEntries.iterator();
        this.m_currentEntry = this.m_SACEntryIterator.hasNext() ? this.m_SACEntryIterator.next().toRetrievableSACEntry() : new RetrievableSACEntry(new Link());
        this.m_currentFileSetLoaded = false;
    }

    @Override
    public String getCurrentFileSetName() {
        return FILESET_NAME;
    }

    @Override
    public String getCoordSysString() {
        return this.m_reader.getCoordSysString();
    }

    @Override
    public void setAdditionalFields(Map<String, FieldType> map) throws InvalidFieldMappingException {
        this.m_additionalFields = map;
    }

    @Override
    public boolean isSacFromFile() {
        return true;
    }

    @Override
    public boolean isLeftAndRightSac() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void confirmMappings() throws InvalidFieldMappingException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void populateAdditionalFields(RawAddress addr) {
        throw new UnsupportedOperationException();
    }

    private void createSubReader(Properties props) throws DataCreationException {
        Class<?> clz;
        String readerClassName = props.getProperty(SUB_DATA_READER);
        if (StringUtilities.isEmpty((String)readerClassName)) {
            throw new DataCreationException("No sub reader given");
        }
        try {
            clz = Class.forName(readerClassName, true, MMUtils.getCurrentClassLoader(readerClassName));
        }
        catch (ClassNotFoundException CNFEx) {
            throw new DataCreationException("Cannot find class: " + readerClassName, CNFEx);
        }
        try {
            this.m_reader = (RawDataReader)clz.newInstance();
        }
        catch (InstantiationException IEx) {
            throw new DataCreationException("Unable to instantiate class: " + readerClassName, IEx);
        }
        catch (IllegalAccessException IAEx) {
            throw new DataCreationException("Unable to instantiate class: " + readerClassName, IAEx);
        }
    }

    private void createSacCreator(Properties props) throws InvalidSacException {
        String[] sacMapping;
        this.m_sacCreator = new SacCreator();
        String value = (String)props.get("sac");
        if (value == null || value.trim().length() == 0) {
            throw new InvalidSacException("Databuild aborted: No value provided for \"sac\" for SAC creation");
        }
        int sepNdx = value.indexOf(44);
        if (sepNdx > -1) {
            sacMapping = new String[2];
            sacMapping[0] = value.substring(0, sepNdx).trim();
            if (sepNdx + 1 < value.length()) {
                sacMapping[1] = value.substring(sepNdx + 1);
            }
        } else {
            sacMapping = new String[]{value.trim()};
        }
        if (sacMapping.length > 1 && sacMapping[sacMapping.length - 1].trim().length() > 0) {
            this.m_sacCreator.setPattern(sacMapping[sacMapping.length - 1]);
        }
        this.initSacSourceField(sacMapping[0]);
    }

    private void initSacSourceField(String fieldName) throws InvalidSacException {
        FieldType[] types;
        for (FieldType type : types = FieldType.getPredefinedFieldTypes()) {
            if (!type.getName().equals(fieldName)) continue;
            this.m_sacSourceField = type;
            return;
        }
        if (this.m_additionalFields != null) {
            this.m_sacSourceField = this.m_additionalFields.get(fieldName);
        }
        if (this.m_sacSourceField == null) {
            throw new InvalidSacException("Unable to find sac source field: " + fieldName);
        }
    }

    private void loadAllDataSets(Properties prop) throws IOException {
        String intermediatePath = prop.getProperty("intermediateFolder");
        File intermediateFolder = new File(intermediatePath);
        File tempFile = File.createTempFile("data", "tmp", intermediateFolder);
        this.m_stream = new RandomAccessDataStream(tempFile);
        this.m_readerWriter = new RawAddressReaderWriter();
        this.m_sacEntryFile = new SACEntryOffsetFile(prop);
        this.m_SACEntries = new ArrayList<SACEntry>();
        while (this.m_reader.loadNextFileSet()) {
            RawAddress address;
            while ((address = this.m_reader.getNextRecord()) != null) {
                int sac;
                if (this.m_bIsSacFromFile) {
                    try {
                        sac = Integer.parseInt(address.getSac());
                    }
                    catch (NumberFormatException NFEx) {
                        sac = -1;
                        address.setSac(String.valueOf(sac));
                    }
                } else {
                    sac = this.m_sacCreator.getSac((String)((AddressFieldValue)address.getField(this.m_sacSourceField)).getFieldValue());
                    address.setSac(String.valueOf(sac));
                }
                long offset = this.m_stream.getFilePointer();
                SACEntry entry = new SACEntry(sac);
                int index = Collections.binarySearch(this.m_SACEntries, entry);
                if (index < 0) {
                    ++index;
                    this.m_SACEntries.add(index *= -1, entry);
                }
                this.m_SACEntries.get(index).addOffset(offset);
                this.m_readerWriter.write((DataOutput)this.m_stream, address);
            }
        }
        this.m_bDataLoaded = true;
        this.rewind();
    }

    @Override
    public void close() {
        if (null != this.m_stream) {
            try {
                this.m_stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != this.m_sacEntryFile && null != this.m_sacEntryFile.m_stream) {
            try {
                this.m_sacEntryFile.m_stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Entry {
        private long m_offset;
        private Link m_next = new Link();

        public long getOffset() {
            return this.m_offset;
        }

        public Link getNext() {
            return this.m_next;
        }

        public void read(IRandomDataInputOutputStream stream, Link link) throws IOException {
            stream.seek(link.getNext());
            this.m_offset = stream.readLong();
            this.m_next.read(stream);
        }
    }

    private static class Link {
        private static final long NO_LINK = -1L;
        private long m_position;
        private long m_next;

        public Link() {
            this(-1L);
        }

        public Link(long next) {
            this.m_position = -1L;
            this.m_next = next;
        }

        public Link(Link that) {
            this.m_position = that.m_position;
            this.m_next = that.m_next;
        }

        public boolean hasNext() {
            return this.m_next != -1L;
        }

        public void setNext(long next) {
            this.m_next = next;
        }

        public long getNext() {
            return this.m_next;
        }

        public void read(IRandomDataInputOutputStream stream) throws IOException {
            this.updatePosition(stream);
            this.m_next = stream.readLong();
        }

        public void write(IRandomDataInputOutputStream stream) throws IOException {
            this.updatePosition(stream);
            stream.writeLong(this.m_next);
        }

        public void update(IRandomDataInputOutputStream stream) throws IOException {
            if (this.m_position != -1L) {
                long currentOffset = stream.getFilePointer();
                stream.seek(this.m_position);
                this.write(stream);
                stream.seek(currentOffset);
            }
        }

        private void updatePosition(IRandomDataInputOutputStream stream) throws IOException {
            this.m_position = stream.getFilePointer();
        }
    }

    private static class SACEntryOffsetFile {
        private final IRandomDataInputOutputStream m_stream;

        public SACEntryOffsetFile(Properties props) throws IOException {
            String intermediatePath = props.getProperty("intermediateFolder");
            File intermediateFolder = new File(intermediatePath);
            File tempFile = File.createTempFile("data", "tmp", intermediateFolder);
            this.m_stream = new RandomAccessDataStream(tempFile);
        }

        public Link writeEntry(Link link, long offset) throws IOException {
            long newEntryPosition = this.m_stream.length();
            link.setNext(newEntryPosition);
            link.update(this.m_stream);
            this.m_stream.seek(newEntryPosition);
            this.m_stream.writeLong(offset);
            Link link2 = new Link();
            link2.write(this.m_stream);
            return link2;
        }

        public Entry read(Link link) throws IOException {
            Entry entry = new Entry();
            entry.read(this.m_stream, link);
            return entry;
        }
    }

    private static class Address
    extends RawAddress {
        private DirectPosition[] m_coordinates;
        private String m_sac;
        private int m_oddEvenType;
        private int m_side;

        private Address() {
        }

        @Override
        public String getSac() {
            return this.m_sac;
        }

        @Override
        public void setCoordinates(DirectPosition[] points) {
            this.m_coordinates = points;
        }

        @Override
        public void setSac(String sac) {
            this.m_sac = sac;
        }

        @Override
        public DirectPosition[] getCoordinates() {
            return this.m_coordinates;
        }

        @Override
        public int getOddEvenType() {
            return this.m_oddEvenType;
        }

        @Override
        public void setOddEvenType(int type) {
            this.m_oddEvenType = type;
        }

        @Override
        public int getStreetSide() {
            return this.m_side;
        }

        @Override
        public void setStreetSide(int side) {
            this.m_side = side;
        }
    }

    private class RetrievableSACEntry {
        private Link m_next;

        public RetrievableSACEntry(Link first) {
            this.m_next = new Link(first);
        }

        public boolean hasNext() {
            return this.m_next.hasNext();
        }

        public long getNext() throws IOException {
            Entry entry = SACSortingReader.this.m_sacEntryFile.read(this.m_next);
            this.m_next = entry.getNext();
            return entry.getOffset();
        }
    }

    private class SACEntry
    implements Comparable<SACEntry> {
        private final int m_sac;
        private final Link m_first;
        private Link m_last;

        public SACEntry(int sac) {
            this.m_sac = sac;
            this.m_first = new Link();
        }

        public void addOffset(long offset) throws IOException {
            this.m_last = this.m_last == null ? SACSortingReader.this.m_sacEntryFile.writeEntry(this.m_first, offset) : SACSortingReader.this.m_sacEntryFile.writeEntry(this.m_last, offset);
        }

        @Override
        public int compareTo(SACEntry that) {
            return this.m_sac - that.m_sac;
        }

        public RetrievableSACEntry toRetrievableSACEntry() {
            return new RetrievableSACEntry(this.m_first);
        }
    }
}

