/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder;

import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.dp.DataCreationException;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.builder.DataWriter;
import com.mapinfo.mapmarker.cgge.dp.builder.InternalStreetObject;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexIOHandler;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValueEnvelopeDecorator;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValueIterator;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValuePersistenceDecorator;
import com.mapinfo.mapmarker.cgge.utils.io.DataStreamFactory;
import com.mapinfo.mapmarker.cgge.utils.io.ICGGEDataStream;
import com.mapinfo.mapmarker.cgge.utils.io.IOUtil;
import com.mapinfo.mapmarker.common.dp.index.spatial.IPersistenceDecorator;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.DiskRGIndexBuilder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpatialIndexWriter {
    private final IDictionaryMetaData metaData;
    private ICGGEDataStream spatialIndexTempStream;
    private String tempFileName;
    private Logger logger = LoggerFactory.getLogger(SpatialIndexWriter.class);
    private final SpatialInfo spatialInfo;
    private final SpatialIndexIOHandler spatialIndexIOHandler;

    SpatialIndexWriter(String filebasepath, String filebaseName, IDictionaryMetaData metaData) throws IOException {
        this.tempFileName = StringUtilities.appendToPath((String)filebasepath, (String)filebaseName, (String)".tsx");
        this.spatialIndexTempStream = DataStreamFactory.getDataStream(this.tempFileName, IOUtil.IO_MODE.READ_WRITE, false);
        this.metaData = metaData;
        this.spatialInfo = this.getSpatialInfo(metaData);
        this.spatialIndexIOHandler = SpatialIndexIOHandler.getInstance(metaData);
    }

    void createTemproryRGIndexes(DataWriter writer) throws IOException {
        List<InternalStreetObject> streetObjectList = writer.getCurrentAreaHandle().getListOfInternalAddress();
        for (InternalStreetObject streetObject : streetObjectList) {
            SpatialIndexValue spatialIndexValue = this.getSpatialIndexValue(streetObject, writer);
            if (spatialIndexValue == null) continue;
            this.spatialIndexIOHandler.write(spatialIndexValue, this.spatialIndexTempStream);
        }
    }

    private SpatialIndexValue getSpatialIndexValue(InternalStreetObject streetObject, DataWriter writer) throws IOException {
        List<InternalRangeAddress> ranges = streetObject.getStreeAddress().getRangeList();
        SpatialIndexValue spatialIndexValue = new SpatialIndexValue(this.spatialInfo);
        spatialIndexValue.setStreetStartOffset(streetObject.getAddressIndex());
        spatialIndexValue.setAddressSize(streetObject.getAddressSize());
        spatialIndexValue.setSac(writer.getCurrentAreaHandle().getSac());
        boolean geomAdded = false;
        for (InternalRangeAddress range : ranges) {
            List<DirectPosition> geom = writer.getGeometry(range);
            if (geom == null) continue;
            for (DirectPosition dp : geom) {
                spatialIndexValue.addPoint(dp);
            }
            geomAdded = true;
        }
        return geomAdded ? spatialIndexValue : null;
    }

    private SpatialInfo getSpatialInfo(IDictionaryMetaData metaData) {
        CoordSys srcCoordSys = metaData.getSourceCoordSysObject();
        if (srcCoordSys == null) {
            srcCoordSys = CoordSysConstants.longLatWGS84;
        }
        return new SpatialInfo(srcCoordSys);
    }

    void close() throws IOException {
        this.spatialIndexTempStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createFinalRGIndexes(String filebase, String filename, int numberOfRangesTocombine) throws DataCreationException {
        SpatialIndexValueIterator baseIterator = new SpatialIndexValueIterator(this.metaData.getSourceCoordSysObject(), this.spatialIndexIOHandler);
        try {
            this.spatialIndexTempStream.close();
            baseIterator.open(this.tempFileName);
        }
        catch (IOException IOEx) {
            throw new DataCreationException("Reverse Geocoding Index file exception", IOEx);
        }
        boolean bFinished = false;
        DiskRGIndexBuilder builder = new DiskRGIndexBuilder(new File(StringUtilities.appendToPath((String)filebase, (String)filename, (String)".spx")));
        try {
            this.logger.info("Building spatial index file.");
            builder.buildIndex((Iterator)((Object)baseIterator), (IPersistenceDecorator)new SpatialIndexValuePersistenceDecorator(this.spatialIndexIOHandler), (IEnvelopeDecorator)new SpatialIndexValueEnvelopeDecorator());
            this.logger.info("Spatial index file completed.");
            bFinished = true;
        }
        finally {
            block10: {
                try {
                    baseIterator.close();
                }
                catch (IOException IOEx) {
                    if (!bFinished) break block10;
                    throw new DataCreationException("Final Reverse Geocoding Index file exception", IOEx);
                }
            }
        }
    }
}

