/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.RawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.TAB_RecordAddress;
import com.mapinfo.mapmarker.cgge.utils.CGGEResourceBundle;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.MidevConversionUtils;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.data.ICursor;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.data.ITable;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.AttributeType;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.table.Table;
import com.mapinfo.midev.tabledepot.TableDepot;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class TAB_Reader
extends RawDataReader {
    private IDataSourceTable m_miTable;
    private ICursor m_recordSet;
    private IFeature m_currentRecord;
    public static String KEY_TAB_FILE = "TABFile";
    private String m_tabName;
    private String m_coordSys = null;
    private String m_featureGeometryColumnName;
    private boolean m_isRecordLeft = true;
    public static String KEY_COUNTRY_COL_NAME = "RecordCountry";
    public static String KEY_COMBINE_ALT_VALS_DELIM = "Combine_Alt_Vals_Delim";
    public static String KEY_PLACENAME_COL_NAME = "PlaceName";
    public static String KEY_LEFT_UNIT_PLACENAME_COL_NAME = "LeftUnitPlaceName";
    public static String KEY_RIGHT_UNIT_PLACENAME_COL_NAME = "RightUnitPlaceName";
    public static String KEY_LEFT_RANGE_PLACENAME_COL_NAME = "LeftRangePlaceName";
    public static String KEY_RIGHT_RANGE_PLACENAME_COL_NAME = "RightRangePlaceName";
    public static String KEY_STREET_COL_NAME = "Street";
    public static String KEY_LEFTRANGE_FROM_COL_NAME = "FromLeft";
    public static String KEY_LEFTRANGE_TO_COL_NAME = "ToLeft";
    public static String KEY_RIGHTRANGE_FROM_COL_NAME = "FromRight";
    public static String KEY_RIGHTRANGE_TO_COL_NAME = "ToRight";
    public static String KEY_LEFT_STRUCT_COL_NAME = "LeftStruct";
    public static String KEY_RIGHT_STRUCT_COL_NAME = "RightStruct";
    public static String KEY_LEFT_PC_COL_NAME = "LeftPostcode";
    public static String KEY_RIGHT_PC_COL_NAME = "RightPostcode";
    public static String KEY_LEFT_PC_EX_COL_NAME = "LeftPostcodeEx";
    public static String KEY_RIGHT_PC_EX_COL_NAME = "RightPostcodeEx";
    public static String KEY_LEFT_AREANAME1_COL_NAME = "LeftAreaName1";
    public static String KEY_LEFT_AREANAME2_COL_NAME = "LeftAreaName2";
    public static String KEY_LEFT_AREANAME3_COL_NAME = "LeftAreaName3";
    public static String KEY_LEFT_AREANAME4_COL_NAME = "LeftAreaName4";
    public static String KEY_RIGHT_AREANAME1_COL_NAME = "RightAreaName1";
    public static String KEY_RIGHT_AREANAME2_COL_NAME = "RightAreaName2";
    public static String KEY_RIGHT_AREANAME3_COL_NAME = "RightAreaName3";
    public static String KEY_RIGHT_AREANAME4_COL_NAME = "RightAreaName4";
    private static final String KEY_LEFT_GENERIC_FIELD1_COL_NAME = "LeftGenericField1";
    private static final String KEY_RIGHT_GENERIC_FIELD1_COL_NAME = "RightGenericField1";
    private static final String KEY_LEFT_GENERIC_FIELD2_COL_NAME = "LeftGenericField2";
    private static final String KEY_RIGHT_GENERIC_FIELD2_COL_NAME = "RightGenericField2";
    public static String KEY_GENERIC_FIELD1_COL_NAME = "GenericField1";
    public static String KEY_GENERIC_FIELD2_COL_NAME = "GenericField2";
    public static String KEY_GENERIC_FIELD3_COL_NAME = "GenericField3";
    public static String KEY_GENERIC_FIELD4_COL_NAME = "GenericField4";
    public static String KEY_ALT_STREET_COL_NAME = "Alt_Street";
    public static String KEY_ALT_PLACENAME_COL_NAME = "Alt_PlaceName";
    public static String KEY_ALT_LEFT_PC_COL_NAME = "Alt_LeftPostcode";
    public static String KEY_ALT_RIGHT_PC_COL_NAME = "Alt_RightPostcode";
    public static String KEY_ALT_LEFT_PC_EX_COL_NAME = "Alt_LeftPostcodeEx";
    public static String KEY_ALT_RIGHT_PC_EX_COL_NAME = "Alt_RightPostcodeEx";
    public static String KEY_ALT_LEFT_AREANAME1_COL_NAME = "Alt_LeftAreaName1";
    public static String KEY_ALT_LEFT_AREANAME2_COL_NAME = "Alt_LeftAreaName2";
    public static String KEY_ALT_LEFT_AREANAME3_COL_NAME = "Alt_LeftAreaName3";
    public static String KEY_ALT_LEFT_AREANAME4_COL_NAME = "Alt_LeftAreaName4";
    public static String KEY_ALT_RIGHT_AREANAME1_COL_NAME = "Alt_RightAreaName1";
    public static String KEY_ALT_RIGHT_AREANAME2_COL_NAME = "Alt_RightAreaName2";
    public static String KEY_ALT_RIGHT_AREANAME3_COL_NAME = "Alt_RightAreaName3";
    public static String KEY_ALT_RIGHT_AREANAME4_COL_NAME = "Alt_RightAreaName4";
    public static String KEY_ALT_GENERIC_FIELD1_COL_NAME = "Alt_GenericField1";
    public static String KEY_ALT_GENERIC_FIELD2_COL_NAME = "Alt_GenericField2";
    public static String KEY_ALT_GENERIC_FIELD3_COL_NAME = "Alt_GenericField3";
    public static String KEY_ALT_GENERIC_FIELD4_COL_NAME = "Alt_GenericField4";
    private File[] m_tabFiles;
    private int m_currentFile;
    private String m_tabPath;
    private String m_nameStartsWith;
    private String m_altValsDelim;
    private boolean possiblePointData;
    protected String dataName;
    private boolean m_geometryErrorReported;
    private RawAddress m_rightRecord;

    @Override
    public String getCurrentFileSetName() {
        return this.m_tabName;
    }

    protected String getFieldValue(String fieldKey) {
        return this.getColumnValue(this.m_properties.getProperty(fieldKey));
    }

    private String getColumnValue(String colName) {
        if (colName != null) {
            IAttributeDefinition metadata = this.m_miTable.getMetadata().getAttributeDefinitions().get(colName);
            if (metadata != null && metadata.getDataType().isWholeNumber()) {
                return String.valueOf((long)this.m_currentRecord.getDouble(colName));
            }
            if (metadata != null) {
                return this.m_currentRecord.getString(colName);
            }
        }
        return null;
    }

    protected boolean bothValuesSame(AddressFieldValue left, AddressFieldValue right) {
        if (left != null) {
            return left.equals(right);
        }
        return right == null;
    }

    private int checkHNRType(int type) {
        if (type != 2 && type != 3 && type != 4 && type != 5) {
            type = 0;
        }
        return type;
    }

    public TAB_RecordAddress getNextLeftAddress(DirectPosition[] coordinates) {
        TAB_RecordAddress leftAddress = new TAB_RecordAddress();
        leftAddress.setStreetSide(1);
        String str = this.getFieldValue(KEY_LEFT_STRUCT_COL_NAME);
        int type = 0;
        try {
            type = str != null ? MMUtils.convertToIntValue(str) : type;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        leftAddress.setOddEvenType(this.checkHNRType(type));
        String leftFrom = null;
        String leftTo = null;
        if (this.possiblePointData || leftAddress.getOddEvenType() != 0) {
            leftFrom = this.getFieldValue(KEY_LEFTRANGE_FROM_COL_NAME);
            leftTo = this.getFieldValue(KEY_LEFTRANGE_TO_COL_NAME);
        }
        if (leftTo != null && this.possiblePointData && (leftFrom == leftTo || leftFrom.equals(leftTo))) {
            leftTo = null;
        }
        leftAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(leftFrom));
        leftAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(leftTo));
        this.setAddressField(leftAddress, KEY_COUNTRY_COL_NAME, FieldType.COUNTRY_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_UNIT_PLACENAME_COL_NAME, FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_RANGE_PLACENAME_COL_NAME, FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_PLACENAME_COL_NAME, FieldType.PLACE_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_STREET_COL_NAME, FieldType.STREET_NAME_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_LEFT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE);
        this.handleGenericFieldsLeftAddress(leftAddress);
        this.setCoordinates(leftAddress, coordinates);
        this.setSACtoAddress(leftAddress, "LeftSac");
        this.populateAdditionalFields(leftAddress);
        return leftAddress;
    }

    protected void setCoordinates(TAB_RecordAddress address, DirectPosition[] coordinates) {
        address.setCoordinates(coordinates);
    }

    protected void handleGenericFieldsLeftAddress(TAB_RecordAddress leftAddress) {
        this.setGenericField(leftAddress, KEY_GENERIC_FIELD1_COL_NAME, KEY_LEFT_GENERIC_FIELD1_COL_NAME, FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        this.setGenericField(leftAddress, KEY_GENERIC_FIELD2_COL_NAME, KEY_LEFT_GENERIC_FIELD2_COL_NAME, FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        this.setAddressField(leftAddress, KEY_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }

    public TAB_RecordAddress getNextRightAddress(DirectPosition[] coordinates) {
        TAB_RecordAddress rightAddress = new TAB_RecordAddress();
        rightAddress.setStreetSide(2);
        String str = this.getFieldValue(KEY_RIGHT_STRUCT_COL_NAME);
        int type = 0;
        try {
            type = str != null ? MMUtils.convertToIntValue(str) : type;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        rightAddress.setOddEvenType(this.checkHNRType(type));
        String rightFrom = null;
        String rightTo = null;
        if (this.possiblePointData || rightAddress.getOddEvenType() != 0) {
            rightFrom = this.getFieldValue(KEY_RIGHTRANGE_FROM_COL_NAME);
            rightTo = this.getFieldValue(KEY_RIGHTRANGE_TO_COL_NAME);
        }
        if (rightTo != null && this.possiblePointData && (rightFrom == rightTo || rightFrom.equals(rightTo))) {
            rightTo = null;
        }
        rightAddress.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, new AddressFieldValue(rightFrom));
        rightAddress.setField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE, new AddressFieldValue(rightTo));
        this.setAddressField(rightAddress, KEY_COUNTRY_COL_NAME, FieldType.COUNTRY_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_UNIT_PLACENAME_COL_NAME, FieldType.UNIT_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_LEFT_RANGE_PLACENAME_COL_NAME, FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_PLACENAME_COL_NAME, FieldType.PLACE_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_STREET_COL_NAME, FieldType.STREET_NAME_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_RIGHT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE);
        this.handleGenericFieldsRightAddress(rightAddress);
        this.setCoordinates(rightAddress, coordinates);
        this.setSACtoAddress(rightAddress, "RightSac");
        this.populateAdditionalFields(rightAddress);
        return rightAddress;
    }

    protected void handleGenericFieldsRightAddress(TAB_RecordAddress rightAddress) {
        this.setGenericField(rightAddress, KEY_GENERIC_FIELD1_COL_NAME, KEY_RIGHT_GENERIC_FIELD1_COL_NAME, FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        this.setGenericField(rightAddress, KEY_GENERIC_FIELD2_COL_NAME, KEY_RIGHT_GENERIC_FIELD2_COL_NAME, FieldType.GENERIC_FIELD_2_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        this.setAddressField(rightAddress, KEY_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_4_FIELD_TYPE);
    }

    protected void setAddressField(RawAddress address, String fieldValue, FieldType fieldType) {
        String str = this.getFieldValue(fieldValue);
        address.setField(fieldType, new AddressFieldValue(str));
    }

    protected void setSACtoAddress(TAB_RecordAddress address, String sacColumnName) {
        String str = null;
        if (this.isSacFromFile()) {
            if (this.isLeftAndRightSac()) {
                str = this.getFieldValue(sacColumnName);
                str = str == null ? str : str.trim();
                address.setSac(str);
            } else {
                str = this.getFieldValue("Sac");
                str = str == null ? str : str.trim();
                address.setSac(str);
            }
        }
    }

    protected void setGenericField(RawAddress address, String genericFieldValue, String genericDirectionFieldValue, FieldType fieldType) {
        AddressFieldValue addFieldVal = null;
        String str = this.getFieldValue(genericFieldValue);
        if (str != null) {
            addFieldVal = new AddressFieldValue(str);
            address.setField(fieldType, addFieldVal);
        } else {
            str = this.getFieldValue(genericDirectionFieldValue);
            address.setField(fieldType, new AddressFieldValue(str));
        }
    }

    @Override
    public RawAddress getNextRecord() {
        if (this.m_rightRecord != null) {
            RawAddress record = this.m_rightRecord;
            this.m_rightRecord = null;
            this.m_isRecordLeft = false;
            return record;
        }
        TAB_RecordAddress leftAddress = null;
        TAB_RecordAddress rightAddress = null;
        if (this.m_recordSet.hasNext() && this.m_featureGeometryColumnName != null) {
            do {
                this.m_currentRecord = this.m_recordSet.next();
                if (!this.m_currentRecord.isNull(this.m_featureGeometryColumnName)) continue;
                DataBuilder.m_consoleLogger.warn(String.format("Current record's geometry is null: %s", this.m_currentRecord.toString()));
            } while (this.m_currentRecord.isNull(this.m_featureGeometryColumnName) && this.m_recordSet.hasNext());
            if (!this.m_currentRecord.isNull(this.m_featureGeometryColumnName)) {
                IFeatureGeometry geom = this.m_currentRecord.getFeatureGeometry(this.m_featureGeometryColumnName);
                DirectPosition[] coordinates = this.getCoordinates(geom);
                leftAddress = this.getNextLeftAddress(coordinates);
                rightAddress = this.getNextRightAddress(coordinates);
                this.populateAlternateFields(leftAddress, rightAddress);
                boolean useRightAddress = this.considerRightAddress(leftAddress, rightAddress);
                if (!useRightAddress) {
                    leftAddress.setStreetSide(0);
                    rightAddress = null;
                } else {
                    this.m_rightRecord = rightAddress;
                }
            }
        }
        this.m_isRecordLeft = true;
        return leftAddress;
    }

    private DirectPosition[] getCoordinates(IFeatureGeometry geom) {
        ArrayList pointsArray = new ArrayList();
        GeometryType gtype = geom.getType();
        if (gtype == GeometryType.MULTI_CURVE) {
            pointsArray = MidevConversionUtils.getPoints((IMultiCurve)((IMultiCurve)geom), null);
        } else if (gtype == GeometryType.POINT) {
            Point pt = (Point)geom;
            pointsArray.add(pt.getDirectPosition());
        } else if (!this.m_geometryErrorReported) {
            DataBuilder.m_consoleLogger.warn("Unsupported geometry type! Only Line, PolyLine and Point geometry currently supported");
            this.m_geometryErrorReported = true;
        }
        if (pointsArray.size() > 0) {
            return pointsArray.toArray(new DirectPosition[pointsArray.size()]);
        }
        return null;
    }

    protected boolean considerRightAddress(TAB_RecordAddress left, TAB_RecordAddress right) {
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.POST_CODE_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.POST_CODE_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.POST_CODE_EX_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.POST_CODE_EX_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_1_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_1_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_2_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_2_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_3_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_3_FIELD_TYPE))) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.AREA_NAME_4_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.AREA_NAME_4_FIELD_TYPE))) {
            return true;
        }
        if (left.getOddEvenType() != right.getOddEvenType()) {
            return true;
        }
        if (!this.bothValuesSame((AddressFieldValue)left.getField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE))) {
            return true;
        }
        return !this.bothValuesSame((AddressFieldValue)left.getField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE), (AddressFieldValue)right.getField(FieldType.ADDRESS_NUMBER_TO_FIELD_TYPE));
    }

    @Override
    protected void confirmMappings() throws InvalidFieldMappingException {
        Iterator<Object> itr = this.m_properties.keySet().iterator();
        String key = null;
        while (itr.hasNext()) {
            key = (String)itr.next();
            if (this.isValidAddressField(key)) continue;
            throw new InvalidFieldMappingException("Property \"" + key + "\" is not a valid field");
        }
    }

    protected boolean isValidAddressField(String str) {
        boolean isValid = false;
        if (str.equals(KEY_TAB_FILE) || str.equals(KEY_COUNTRY_COL_NAME) || str.equals(KEY_LEFT_UNIT_PLACENAME_COL_NAME) || str.equals(KEY_RIGHT_UNIT_PLACENAME_COL_NAME) || str.equals(KEY_LEFT_RANGE_PLACENAME_COL_NAME) || str.equals(KEY_RIGHT_RANGE_PLACENAME_COL_NAME) || str.equals(KEY_PLACENAME_COL_NAME) || str.equals(KEY_STREET_COL_NAME) || str.equals(KEY_LEFTRANGE_FROM_COL_NAME) || str.equals(KEY_LEFTRANGE_TO_COL_NAME) || str.equals(KEY_RIGHTRANGE_FROM_COL_NAME) || str.equals(KEY_RIGHTRANGE_TO_COL_NAME) || str.equals(KEY_LEFT_STRUCT_COL_NAME) || str.equals(KEY_RIGHT_STRUCT_COL_NAME) || str.equals(KEY_LEFT_PC_COL_NAME) || str.equals(KEY_RIGHT_PC_COL_NAME) || str.equals(KEY_LEFT_PC_EX_COL_NAME) || str.equals(KEY_RIGHT_PC_EX_COL_NAME) || str.equals(KEY_LEFT_AREANAME1_COL_NAME) || str.equals(KEY_LEFT_AREANAME2_COL_NAME) || str.equals(KEY_LEFT_AREANAME3_COL_NAME) || str.equals(KEY_LEFT_AREANAME4_COL_NAME) || str.equals(KEY_RIGHT_AREANAME1_COL_NAME) || str.equals(KEY_RIGHT_AREANAME2_COL_NAME) || str.equals(KEY_RIGHT_AREANAME3_COL_NAME) || str.equals(KEY_RIGHT_AREANAME4_COL_NAME) || str.equals(KEY_ALT_PLACENAME_COL_NAME) || str.equals(KEY_ALT_STREET_COL_NAME) || str.equals(KEY_ALT_LEFT_PC_COL_NAME) || str.equals(KEY_ALT_RIGHT_PC_COL_NAME) || str.equals(KEY_ALT_LEFT_PC_EX_COL_NAME) || str.equals(KEY_ALT_RIGHT_PC_EX_COL_NAME) || str.equals(KEY_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_LEFT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_RIGHT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_LEFT_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_RIGHT_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_GENERIC_FIELD3_COL_NAME) || str.equals(KEY_GENERIC_FIELD4_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD1_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD2_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD3_COL_NAME) || str.equals(KEY_ALT_GENERIC_FIELD4_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME1_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME2_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME3_COL_NAME) || str.equals(KEY_ALT_LEFT_AREANAME4_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME1_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME2_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME3_COL_NAME) || str.equals(KEY_ALT_RIGHT_AREANAME4_COL_NAME) || str.equals("Sac") || str.equals("LeftSac") || str.equals("RightSac") || str.equals("IsSacFromFile") || str.equals(KEY_COMBINE_ALT_VALS_DELIM) || m_dditionalFieldNames != null && m_dditionalFieldNames.containsKey(str)) {
            isValid = true;
        }
        return isValid;
    }

    @Override
    protected void populateAdditionalFields(RawAddress addr) {
        if (m_dditionalFieldNames != null && m_dditionalFieldNames.size() > 0) {
            String str = null;
            String colName2 = null;
            for (String colName2 : m_dditionalFieldNames.keySet()) {
                str = this.getFieldValue(colName2);
                addr.setField((FieldType)m_dditionalFieldNames.get(colName2), new AddressFieldValue(str));
            }
        }
    }

    protected boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    protected boolean isEmptyNoTrim(String str) {
        return str == null || str.length() == 0;
    }

    protected void populateAlternate(String key, FieldType fieldType, RawAddress address, RawAddress mirrorAddress) {
        String str = this.m_properties.getProperty(key);
        String[] retrieved = null;
        if (!this.isEmptyNoTrim(str)) {
            retrieved = this.getAlternates(str);
            AddressFieldValue temp = (AddressFieldValue)address.getField(fieldType);
            temp.setAlternateValues(retrieved);
            if (mirrorAddress != null) {
                temp = (AddressFieldValue)mirrorAddress.getField(fieldType);
                temp.setAlternateValues(retrieved);
            }
        }
    }

    protected void populateAlternateFields(RawAddress leftAddr, RawAddress rightAddr) {
        this.populateAlternate(KEY_ALT_PLACENAME_COL_NAME, FieldType.PLACE_NAME_FIELD_TYPE, leftAddr, rightAddr);
        this.populateAlternate(KEY_ALT_STREET_COL_NAME, FieldType.STREET_NAME_FIELD_TYPE, leftAddr, rightAddr);
        this.populateAlternate(KEY_ALT_LEFT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_PC_COL_NAME, FieldType.POST_CODE_FIELD_TYPE, rightAddr, null);
        this.populateAlternate(KEY_ALT_LEFT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_PC_EX_COL_NAME, FieldType.POST_CODE_EX_FIELD_TYPE, rightAddr, null);
        this.populateAlternate(KEY_ALT_LEFT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_AREANAME4_COL_NAME, FieldType.AREA_NAME_4_FIELD_TYPE, rightAddr, null);
        this.populateAlternate(KEY_ALT_LEFT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_AREANAME3_COL_NAME, FieldType.AREA_NAME_3_FIELD_TYPE, rightAddr, null);
        this.populateAlternate(KEY_ALT_LEFT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_AREANAME2_COL_NAME, FieldType.AREA_NAME_2_FIELD_TYPE, rightAddr, null);
        this.populateAlternate(KEY_ALT_LEFT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_RIGHT_AREANAME1_COL_NAME, FieldType.AREA_NAME_1_FIELD_TYPE, rightAddr, null);
        this.populateAlternateGenericFields(leftAddr, rightAddr);
    }

    protected void populateAlternateGenericFields(RawAddress leftAddr, RawAddress rightAddr) {
        this.populateAlternate(KEY_ALT_GENERIC_FIELD1_COL_NAME, FieldType.GENERIC_FIELD_1_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_GENERIC_FIELD2_COL_NAME, FieldType.GENERIC_FIELD_2_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_GENERIC_FIELD3_COL_NAME, FieldType.GENERIC_FIELD_3_FIELD_TYPE, leftAddr, null);
        this.populateAlternate(KEY_ALT_GENERIC_FIELD4_COL_NAME, FieldType.GENERIC_FIELD_4_FIELD_TYPE, leftAddr, null);
    }

    protected String[] getAlternates(String str) {
        String[] tokens = str.split(",");
        ArrayList<String> alternates = null;
        if (tokens != null && tokens.length > 0) {
            alternates = new ArrayList<String>();
            String value = null;
            for (String t : tokens) {
                value = this.getColumnValue(t);
                String[] strAlternates = null;
                if (this.isEmpty(value)) continue;
                if (this.m_altValsDelim == null) {
                    alternates.add(value);
                    continue;
                }
                for (String v : strAlternates = value.split(this.m_altValsDelim)) {
                    if (this.isEmpty(v)) continue;
                    alternates.add(v);
                }
            }
        }
        if (alternates != null && alternates.size() > 0) {
            return alternates.toArray(new String[alternates.size()]);
        }
        return null;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        String dn;
        String country = prop.getProperty("country");
        this.dataName = dn = prop.getProperty("dataName");
        String dp = prop.getProperty("dataProviderName");
        String path = "/com/mapinfo/mapmarker/" + country + "/config/" + dn + "_" + dp + "_TabColumnMapping.properties";
        this.m_properties = null;
        Properties tmpProps = CGGEResourceBundle.getBundle(path);
        for (Object key : tmpProps.keySet()) {
            String value = tmpProps.getProperty((String)key);
            if (value == null) continue;
            tmpProps.setProperty((String)key, value.trim());
        }
        this.m_properties = tmpProps;
        this.m_tabPath = (String)prop.get("inputPath");
        this.m_nameStartsWith = (String)this.m_properties.get(KEY_TAB_FILE);
        this.m_altValsDelim = (String)this.m_properties.get(KEY_COMBINE_ALT_VALS_DELIM);
        try {
            this.prepareSacMappings();
            this.confirmMappings();
            this.possiblePointData = false;
            if (this.isEmptyNoTrim((String)this.m_properties.get(KEY_LEFT_STRUCT_COL_NAME)) && this.isEmptyNoTrim((String)this.m_properties.get(KEY_RIGHT_STRUCT_COL_NAME))) {
                this.possiblePointData = true;
            }
        }
        catch (InvalidSacException ise) {
            DataBuilder.m_consoleLogger.error("Data build terminated: SAC mapping not specified or invalid");
            DataBuilder.m_consoleLogger.error(ise.getMessage());
            throw ise;
        }
        catch (InvalidFieldMappingException ife) {
            throw new InvalidFieldMappingException(ife.getMessage() + "\n Check " + path);
        }
        File f = new File(this.m_tabPath);
        FilenameFilter tabFileNameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String str) {
                return (str = str.toUpperCase()) != null && str.startsWith(TAB_Reader.this.m_nameStartsWith.toUpperCase()) && str.endsWith(".TAB");
            }
        };
        this.m_tabFiles = f.listFiles(tabFileNameFilter);
        this.m_currentFile = -1;
        if (this.m_tabFiles == null || this.m_tabFiles.length == 0) {
            DataBuilder.m_consoleLogger.error("No tables found at " + this.m_tabPath);
            return false;
        }
        this.openDataSet(this.m_tabPath, this.m_tabFiles[0].getName());
        String tableName = this.m_miTable.getDefinition().getName();
        TableDepot tableDepot = new TableDepot();
        Table table = new Table(this.m_miTable);
        tableDepot.add(tableName, (ITable)table);
        String query = "select " + this.m_featureGeometryColumnName + " from " + tableName;
        ICursor recordSet = tableDepot.search(query);
        if (recordSet != null && recordSet.hasNext()) {
            IFeature geomRecord = recordSet.next();
            if (this.m_featureGeometryColumnName != null && !geomRecord.isNull(this.m_featureGeometryColumnName)) {
                IFeatureGeometry geom = geomRecord.getFeatureGeometry(this.m_featureGeometryColumnName);
                this.m_coordSys = CoordSysUtilities.getSRSName((CoordSys)geom.getCoordSys());
            }
            recordSet.dispose();
        }
        table.close();
        return true;
    }

    public int getNumFileSets() {
        return this.m_tabFiles == null ? 0 : this.m_tabFiles.length;
    }

    @Override
    public boolean loadNextFileSet() {
        int fileCount;
        int n = fileCount = this.m_tabFiles == null ? 0 : this.m_tabFiles.length;
        if (fileCount > 0) {
            if (++this.m_currentFile < fileCount) {
                try {
                    if (this.m_recordSet != null) {
                        this.m_recordSet.dispose();
                        this.m_recordSet = null;
                    }
                    if (this.m_miTable != null) {
                        this.m_miTable.close();
                        this.m_miTable = null;
                    }
                    String fileName = this.m_tabFiles[this.m_currentFile].getName();
                    try {
                        this.openDataSet(this.m_tabPath, fileName);
                        this.m_tabName = fileName;
                    }
                    catch (Exception e) {
                        DataBuilder.m_consoleLogger.error("Exception opening table " + fileName, (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    if (this.m_recordSet == null && this.m_miTable != null) {
                        String tableName = this.m_miTable.getDefinition().getName();
                        TableDepot tableDepot = new TableDepot();
                        Table table = new Table(this.m_miTable);
                        tableDepot.add(tableName, (ITable)table);
                        String query = "select * from " + tableName;
                        this.m_recordSet = tableDepot.search(query);
                    }
                }
                catch (Exception e) {
                    DataBuilder.m_consoleLogger.error("", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return true;
            }
            if (this.m_recordSet != null) {
                this.m_recordSet.dispose();
                this.m_recordSet = null;
            }
            if (this.m_miTable != null) {
                this.m_miTable.close();
                this.m_miTable = null;
            }
        }
        return false;
    }

    @Override
    public void rewind() {
        this.m_currentFile = -1;
        if (this.m_miTable != null) {
            if (this.m_recordSet != null) {
                this.m_recordSet.dispose();
                this.m_recordSet = null;
            }
            this.m_miTable.close();
        }
    }

    public void openDataSet(String tabPath, String tabName) throws Exception {
        DataBuilder.m_consoleLogger.info("Input file name: " + tabPath + "/" + tabName);
        String str = System.getProperty("user.language");
        Properties prop = System.getProperties();
        if (this.m_miTable != null) {
            this.m_miTable.close();
            this.m_miTable = null;
        }
        NativeDataProvider dp = NativeDataProvider.getInstance();
        this.m_miTable = dp.openTable(new File(tabPath, tabName));
        this.confirmMappedFields();
        AttributeDefinitionCollection attributeDefinitions = this.m_miTable.getMetadata().getAttributeDefinitions();
        for (IAttributeDefinition def : attributeDefinitions) {
            if (def.getDataType() != AttributeType.FEATURE_GEOMETRY) continue;
            this.m_featureGeometryColumnName = def.getName();
            break;
        }
    }

    @Override
    public void close() {
        try {
            if (this.m_miTable != null) {
                this.m_miTable.close();
            }
            this.m_miTable = null;
        }
        catch (RuntimeException ioe) {
            ioe.printStackTrace();
            throw new CGGERuntimeException(ioe.getMessage());
        }
    }

    private String[] splitAlternateFieldNames(String value) {
        String[] tokens = null;
        if (value != null && value.trim().length() > 0) {
            tokens = value.split(",");
        }
        return tokens;
    }

    private void raiseError(String columnName) {
        throw new RuntimeException("Terminating Databuild: Column \"" + columnName + "\" does not exist in the input table");
    }

    private void validateField(String colName) {
        String value = this.m_properties.getProperty(colName);
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.containsColumn(value, this.m_miTable)) {
            this.raiseError(value);
        }
    }

    private void trimAndValidateField(String colName) throws IOException {
        String value = this.m_properties.getProperty(colName);
        if (value == null || value.length() == 0) {
            return;
        }
        if ((value = value.trim()).length() == 0) {
            return;
        }
        if (!this.containsColumn(value, this.m_miTable)) {
            this.raiseError(value);
        }
    }

    private void splitAndValidateField(String colName) throws IOException {
        String value = this.m_properties.getProperty(colName);
        if (value == null || value.length() == 0) {
            return;
        }
        String[] cols = this.splitAlternateFieldNames(value);
        if (cols != null) {
            for (String alt : cols) {
                if (this.containsColumn(alt, this.m_miTable)) continue;
                this.raiseError(alt);
            }
        }
    }

    private void confirmMappedFields() throws Exception {
        this.validateField(KEY_LEFTRANGE_FROM_COL_NAME);
        this.validateField(KEY_RIGHTRANGE_FROM_COL_NAME);
        this.validateField(KEY_LEFTRANGE_TO_COL_NAME);
        this.validateField(KEY_RIGHTRANGE_TO_COL_NAME);
        this.validateField(KEY_LEFT_UNIT_PLACENAME_COL_NAME);
        this.validateField(KEY_RIGHT_UNIT_PLACENAME_COL_NAME);
        this.validateField(KEY_LEFT_RANGE_PLACENAME_COL_NAME);
        this.validateField(KEY_RIGHT_RANGE_PLACENAME_COL_NAME);
        this.validateField(KEY_PLACENAME_COL_NAME);
        this.validateField(KEY_COUNTRY_COL_NAME);
        this.validateField(KEY_STREET_COL_NAME);
        this.validateField(KEY_LEFT_PC_COL_NAME);
        this.validateField(KEY_RIGHT_PC_COL_NAME);
        this.validateField(KEY_LEFT_PC_EX_COL_NAME);
        this.validateField(KEY_RIGHT_PC_EX_COL_NAME);
        this.validateField(KEY_LEFT_AREANAME1_COL_NAME);
        this.validateField(KEY_RIGHT_AREANAME1_COL_NAME);
        this.validateField(KEY_LEFT_AREANAME2_COL_NAME);
        this.validateField(KEY_RIGHT_AREANAME2_COL_NAME);
        this.validateField(KEY_LEFT_AREANAME3_COL_NAME);
        this.validateField(KEY_RIGHT_AREANAME3_COL_NAME);
        this.validateField(KEY_LEFT_AREANAME4_COL_NAME);
        this.validateField(KEY_RIGHT_AREANAME4_COL_NAME);
        this.validateField(KEY_LEFT_STRUCT_COL_NAME);
        this.validateField(KEY_RIGHT_STRUCT_COL_NAME);
        this.validateField(KEY_STREET_COL_NAME);
        this.validateField(KEY_STREET_COL_NAME);
        this.validateField(KEY_STREET_COL_NAME);
        if (this.isSacFromFile()) {
            if (this.isLeftAndRightSac()) {
                this.validateField("LeftSac");
                this.validateField("RightSac");
            } else {
                this.validateField("Sac");
            }
        }
        this.splitAndValidateField(KEY_ALT_PLACENAME_COL_NAME);
        this.splitAndValidateField(KEY_ALT_STREET_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_PC_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_PC_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_PC_EX_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_PC_EX_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_AREANAME4_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_AREANAME4_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_AREANAME3_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_AREANAME3_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_AREANAME2_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_AREANAME2_COL_NAME);
        this.splitAndValidateField(KEY_ALT_LEFT_AREANAME1_COL_NAME);
        this.splitAndValidateField(KEY_ALT_RIGHT_AREANAME1_COL_NAME);
        this.splitAndValidateField(KEY_ALT_PLACENAME_COL_NAME);
        this.splitAndValidateField(KEY_ALT_PLACENAME_COL_NAME);
        if (m_dditionalFieldNames != null && m_dditionalFieldNames.size() > 0) {
            Iterator itr = m_dditionalFieldNames.keySet().iterator();
            while (itr.hasNext()) {
                this.trimAndValidateField((String)itr.next());
            }
        }
    }

    protected boolean isReadRecordLeft() {
        return this.m_isRecordLeft;
    }

    @Override
    public String getCoordSysString() {
        return this.m_coordSys;
    }

    public boolean containsColumn(String name, IDataSourceTable table) {
        ITableMetadata metadata = table.getMetadata();
        AttributeDefinitionCollection attributeDefinitions = metadata.getAttributeDefinitions();
        IAttributeDefinition col = attributeDefinitions.get(name);
        return col != null;
    }
}

