/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.IRawDataDestination;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcRawDataDestination<T>
implements IRawDataDestination<T> {
    static final Logger logger = LoggerFactory.getLogger(JdbcRawDataDestination.class);
    private ResultSetMetaData rsmd;
    private PreparedStatement ps;
    private Map<String, String> fieldInfo = new HashMap<String, String>();
    private Map<String, Integer> fieldType = new HashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JdbcRawDataDestination(Properties properties, Connection conn, String tableName) throws SQLException {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.fieldInfo.put(((String)entry.getValue()).toLowerCase(), (String)entry.getKey());
        }
        String sql = "select * from " + tableName;
        sql = "Oracle".equalsIgnoreCase(conn.getMetaData().getDatabaseProductName()) ? sql + " where rownum < 2" : sql + " limit 1";
        StringBuilder sb = new StringBuilder();
        try (Statement stmt = null;){
            stmt = conn.createStatement();
            try (ResultSet rs = null;){
                int i;
                rs = stmt.executeQuery(sql);
                this.rsmd = rs.getMetaData();
                sb.append("insert into " + tableName + " (");
                for (i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    this.fieldType.put(this.rsmd.getColumnName(i), this.rsmd.getColumnType(i));
                    sb.append(this.rsmd.getColumnName(i));
                    sb.append(",");
                }
                sb.setLength(sb.length() - 1);
                sb.append(") values (");
                for (i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                    sb.append("?,");
                }
                sb.setLength(sb.length() - 1);
                sb.append(")");
                logger.debug(sb.toString());
                this.ps = conn.prepareStatement(sb.toString());
            }
        }
    }

    @Override
    public void writeHeader(String[] colNames) {
    }

    @Override
    public void writeData(Map<String, T> data) {
        try {
            this.ps.clearParameters();
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String key = this.rsmd.getColumnName(i).toLowerCase();
                if (this.fieldInfo.containsKey(key) && data.containsKey(this.fieldInfo.get(key))) {
                    T value = data.get(this.fieldInfo.get(key));
                    if (value == null) {
                        this.ps.setNull(i, this.rsmd.getColumnType(i));
                        continue;
                    }
                    switch (this.rsmd.getColumnType(i)) {
                        case -15: 
                        case -9: 
                        case 1: 
                        case 12: {
                            if (this.rsmd.getPrecision(i) < String.valueOf(value).length()) {
                                System.out.printf("%s: '%s'\n", this.fieldInfo.get(key), String.valueOf(value));
                            }
                            this.ps.setString(i, String.valueOf(value));
                            break;
                        }
                        case 4: {
                            this.ps.setInt(i, Double.valueOf((String)value).intValue());
                            break;
                        }
                        case 8: {
                            this.ps.setDouble(i, Double.parseDouble((String)value));
                            break;
                        }
                        case 2: {
                            this.ps.setBigDecimal(i, new BigDecimal((String)value));
                            break;
                        }
                        default: {
                            logger.debug("type: " + this.rsmd.getColumnType(i));
                        }
                    }
                    continue;
                }
                this.ps.setNull(i, this.rsmd.getColumnType(i));
            }
            this.ps.execute();
        }
        catch (SQLException e) {
            logger.debug(e.getMessage());
        }
    }

    @Override
    public void close() {
        if (this.ps != null) {
            try {
                this.ps.close();
            }
            catch (SQLException e) {
                logger.debug(e.getMessage());
            }
            finally {
                this.ps = null;
            }
        }
    }
}

