/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.AbstractJdbcRawDataSource;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKBReader;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.io.WKTWriter;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQL_DataSource
extends AbstractJdbcRawDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQL_DataSource.class);

    public PostgreSQL_DataSource() throws CGGEInternalException {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new CGGEInternalException(e);
        }
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        String password;
        String connURL;
        int defaultPrefetchSize = 500;
        this.properties = this.removeEmptyProperties(PostgreSQL_DataSource.loadColumnMappings(prop, "PostgreSQL"));
        if (Boolean.parseBoolean(prop.getProperty("Debug", "")) || Boolean.parseBoolean(prop.getProperty("debug", ""))) {
            DEBUG = true;
        }
        if (this.properties.getProperty("GeometryName", "").isEmpty()) {
            this.properties.setProperty("GeometryName", "GEOM");
            LOG.info(String.format("%s key not present in column mappings, using default: %s", "GeometryName", "GEOM"));
        }
        if ((connURL = this.properties.getProperty("connection_url", "")).isEmpty()) {
            connURL = prop.getProperty("connection_url");
        }
        if (connURL == null) {
            throw new CGGEInternalException("No connection URL specified. Cannot connect to the database");
        }
        String userID = this.properties.getProperty("user_id", "");
        if (userID.isEmpty()) {
            userID = prop.getProperty("user_id");
        }
        if ((password = this.properties.getProperty("password", "")).isEmpty()) {
            password = prop.getProperty("password");
        }
        String prefechSizeString = this.properties.getProperty("prefetch", "");
        int prefetchSize = 500;
        if (!prefechSizeString.isEmpty()) {
            try {
                prefetchSize = Integer.parseInt(prefechSizeString.trim());
            }
            catch (NumberFormatException nfe) {
                throw new CGGEInternalException(String.format("Illegal value for %s of %s, must be an integer", "prefetch", prefechSizeString));
            }
        }
        if (userID == null || userID.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No UserID provided");
        }
        if (password == null || password.length() == 0) {
            DataBuilder.m_consoleLogger.warn("No Password provided");
        }
        Properties connectionProperties = new Properties();
        connectionProperties.put("user", userID);
        connectionProperties.put("password", password);
        this.sqlQuery = this.properties.getProperty("select_statment", "");
        if (this.sqlQuery.isEmpty()) {
            this.sqlQuery = prop.getProperty("select_statment");
        }
        if (this.sqlQuery == null || this.sqlQuery.trim().length() == 0) {
            throw new CGGEInternalException("No select statment specified");
        }
        try {
            this.prepareSacMappings(this.properties);
            this.properties.remove("IsSacFromFile");
        }
        catch (InvalidSacException e) {
            DataBuilder.m_consoleLogger.error("Data build is terminated: SAC mapping not specified or invalid.");
            DataBuilder.m_consoleLogger.error(e.getMessage());
            throw e;
        }
        this.setCoordSysString(prop.getProperty("coordinate_system"));
        this.properties.remove("connection_url");
        this.properties.remove("user_id");
        this.properties.remove("password");
        this.properties.remove("select_statment");
        this.properties.remove("where_clause");
        if (DEBUG) {
            LOG.info(String.format("SQL Query: %s", this.sqlQuery));
            LOG.info(String.format("Connection URL: %s", connURL));
            LOG.info(String.format("Prefetch Size: %d", prefetchSize));
        }
        this.conn = DriverManager.getConnection(connURL, connectionProperties);
        this.conn.setAutoCommit(false);
        this.statement = this.conn.createStatement();
        this.statement.setFetchSize(prefetchSize);
        this.resultSet = this.statement.executeQuery(this.sqlQuery);
        this.setFieldLookup(this.resultSet);
        this.confirmMappedFields(this.properties);
        boolean possiblePointData = false;
        if (PostgreSQL_DataSource.isEmpty((String)this.properties.get("LeftStruct")) && PostgreSQL_DataSource.isEmpty((String)this.properties.get("RightStruct"))) {
            possiblePointData = true;
        }
        this.setPossiblePointData(possiblePointData);
        return true;
    }

    private Properties removeEmptyProperties(Properties properties) {
        Properties copy = new Properties();
        for (String key : properties.stringPropertyNames()) {
            if (properties.getProperty(key, "").isEmpty()) continue;
            copy.setProperty(key, properties.getProperty(key));
        }
        return copy;
    }

    @Override
    protected void setGeometry(Map<String, String> currentRow) {
        block14: {
            String geometryString;
            block15: {
                String geometryColumnName = this.properties.getProperty("GeometryName");
                if (geometryColumnName.contains("/")) {
                    String[] cols = geometryColumnName.split("/");
                    try {
                        double x = this.resultSet.getDouble(cols[0]);
                        boolean wasNull = this.resultSet.wasNull();
                        double y = this.resultSet.getDouble(cols[1]);
                        boolean bl = wasNull = wasNull || this.resultSet.wasNull();
                        if (!wasNull) {
                            currentRow.put("Geometry", PostgreSQL_DataSource.getWKT(x, y));
                        }
                        break block14;
                    }
                    catch (SQLException sqlE) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("Sql Exception retrieving geometry info: " + sqlE.getMessage(), (Throwable)sqlE);
                        }
                        break block14;
                    }
                    catch (ParseException pe) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info("WKT parse exception: " + pe.getMessage(), (Throwable)pe);
                        }
                        break block14;
                    }
                }
                geometryString = null;
                try {
                    geometryString = this.resultSet.getString(geometryColumnName);
                }
                catch (SQLException sqlE) {
                    if (!LOG.isInfoEnabled()) break block15;
                    LOG.info("Sql Exception retrieving geometry info: " + sqlE.getMessage(), (Throwable)sqlE);
                }
            }
            if (geometryString != null) {
                Geometry geometry;
                block16: {
                    geometry = null;
                    try {
                        geometry = new WKBReader().read(WKBReader.hexToBytes((String)geometryString));
                    }
                    catch (ParseException pe) {
                        try {
                            geometry = new WKTReader().read(geometryString);
                        }
                        catch (ParseException peboth) {
                            if (!LOG.isInfoEnabled()) break block16;
                            LOG.info("Geometry parse exception: " + peboth.getMessage(), (Throwable)peboth);
                        }
                    }
                }
                currentRow.put("Geometry", new WKTWriter().write(geometry));
            }
        }
    }

    @Override
    public DirectPosition[] getCoordinates() {
        throw new UnsupportedOperationException("getCoordinates was not known to be used");
    }
}

