/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.staticmap;

import com.mapinfo.mapmarker.cgge.dp.InvalidSacException;
import com.mapinfo.mapmarker.cgge.dp.builder.DataBuilder;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticMap_DataSource
extends StandardRawDataSource {
    private static final Logger LOG = LoggerFactory.getLogger(StaticMap_DataSource.class);
    private final Properties properties = new Properties();
    private boolean first = true;
    private List<Map<String, String>> data = Collections.emptyList();
    private Iterator<Map<String, String>> dataIterator = Collections.emptyList().iterator();

    public StaticMap_DataSource(List<Map<String, String>> data) {
        this.data = data;
    }

    public StaticMap_DataSource(List<Map<String, String>> data, Properties properties) {
        this(data);
        this.properties.putAll((Map<?, ?>)properties);
    }

    protected void setGeometry(Map<String, String> currentRow) {
        String wkt;
        if (currentRow.containsKey("geom.latitude") && currentRow.containsKey("geom.longitude") && (wkt = this.getGeometryWKT()) != null) {
            currentRow.put("Geometry", wkt);
        }
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        try {
            this.prepareSacMappings(this.properties);
            this.properties.remove("IsSacFromFile");
        }
        catch (InvalidSacException e) {
            DataBuilder.m_consoleLogger.error("Data build is terminated: SAC mapping not specified or invalid.");
            DataBuilder.m_consoleLogger.error(e.getMessage());
            throw e;
        }
        this.first = true;
        this.dataIterator = this.data.iterator();
        return true;
    }

    @Override
    public boolean loadNextFileSet() {
        boolean last = this.first;
        this.first = false;
        return last;
    }

    @Override
    public void rewind() {
        this.dataIterator = this.data.iterator();
    }

    @Override
    public void close() {
        List t = Collections.emptyList();
        this.dataIterator = t.iterator();
    }

    @Override
    public String getCurrentFileSetName() {
        return null;
    }

    @Override
    public DirectPosition[] getCoordinates() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.dataIterator.hasNext();
    }

    @Override
    public Map<String, String> next() {
        Map<String, String> currentRow = this.dataIterator.next();
        super.setCurrentRow(currentRow);
        this.setGeometry(currentRow);
        return currentRow;
    }
}

