/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.DataReadException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSV_DataSource;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DataFile;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.Text_DataSource;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTextDataSource
extends DSV_DataSource {
    private List<DataFile> files;
    private int currFileNdx = -1;
    private String[] columnNames;
    static final Logger logger = LoggerFactory.getLogger(Text_DataSource.class);

    protected AbstractTextDataSource(DSVFormat format) {
        super(format);
    }

    @Override
    public void rewind() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.error("Exception thrown while closing the stream" + e.getMessage());
                throw new DataReadException(e);
            }
            this.reader = null;
        }
        this.currFileNdx = -1;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        Properties dataConfig = AbstractTextDataSource.loadColumnMappings(prop, "Text");
        String inputPath = prop.getProperty("inputPath");
        return this.loadDataConfigAndData(dataConfig, inputPath);
    }

    protected boolean loadDataConfigAndData(Properties dataConfig, String dataPath) throws Exception {
        String txtFile = dataConfig.getProperty("TextFile");
        this.setDelimiterFromOptions(dataConfig);
        this.setColumnNamesFromOptions(dataConfig);
        this.files = this.loadFiles(dataPath, txtFile);
        if (this.files == null || this.files.isEmpty()) {
            logger.debug("no file matching pattern exist at: " + dataPath);
            return false;
        }
        dataConfig.remove("CSVFile");
        this.setProperties(dataConfig);
        this.currFileNdx = 0;
        return super.loadData(dataConfig);
    }

    private void setDelimiterFromOptions(Properties prop) {
        String delimiter = prop.getProperty("delimiter");
        if (delimiter != null) {
            if (DSVFormat.TDF.getSeparator().equals(delimiter)) {
                this.setFormat(DSVFormat.TDF);
            } else if (DSVFormat.EXCEL.getSeparator().equals(delimiter)) {
                this.setFormat(DSVFormat.EXCEL);
            } else {
                DSVFormat format = new DSVFormat(delimiter);
                this.setFormat(format);
            }
        }
    }

    private void setColumnNamesFromOptions(Properties prop) {
        String str = prop.getProperty("ColumnNames");
        this.columnNames = MMUtils.isEmpty(str) ? EMPTY_STRING_ARRAY : str.split(",");
    }

    @Override
    public boolean loadNextFileSet() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.error("Exception thrown while closing the stream" + e.getMessage());
                throw new DataReadException(e);
            }
            this.reader = null;
        }
        if (!this.setNextFile()) {
            return false;
        }
        return super.loadNextFileSet();
    }

    protected boolean setNextFile() {
        if (++this.currFileNdx < this.files.size()) {
            this.dataFile = this.files.get(this.currFileNdx);
            return true;
        }
        return false;
    }

    @Override
    protected String[] getColumnList(Reader reader) throws IOException {
        if (this.columnNames != EMPTY_STRING_ARRAY) {
            return this.columnNames;
        }
        return super.getColumnList(reader);
    }

    protected abstract List<DataFile> loadFiles(String var1, String var2) throws Exception;
}

