/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVParser;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVRecord;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSV_DataSource;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSV_DataSource
extends DSV_DataSource {
    static final Logger logger = LoggerFactory.getLogger(CSV_DataSource.class);

    public CSV_DataSource() {
        super(DSVFormat.EXCEL);
    }

    public static String[] parse(String s) throws IOException {
        DSVParser parser = DSVFormat.EXCEL.withSkipHeaderRecord(false).parse(new StringReader(s));
        Iterator<DSVRecord> iter = parser.iterator();
        if (!iter.hasNext()) {
            return EMPTY_STRING_ARRAY;
        }
        DSVRecord record = iter.next();
        String[] values = new String[record.size()];
        for (int i = 0; i < record.size(); ++i) {
            values[i] = (String)record.get(i);
        }
        return values;
    }

    public static String toCsv(String[] args) {
        return DSVFormat.EXCEL.format(args);
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        Properties properties = CSV_DataSource.loadColumnMappings(prop, "Csv");
        String csvfile = properties.getProperty("CSVFile");
        String inputPath = prop.getProperty("inputPath");
        File file = new File(new File(inputPath), csvfile);
        if (!(file.exists() && file.isFile() && file.canRead())) {
            logger.debug("file does not exist: " + file);
            return false;
        }
        this.dataFile = this.getNewDataFile(file);
        properties.remove("CSVFile");
        this.setProperties(properties);
        return super.loadData(prop);
    }
}

