/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVFormat;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVRecord;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.text.DSVUtil;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DSVParser
implements Iterable<DSVRecord> {
    private final DSVFormat format;
    private final Reader reader;

    public DSVParser(DSVFormat format, Reader reader) {
        this.format = format;
        this.reader = reader;
    }

    @Override
    public Iterator<DSVRecord> iterator() {
        MyDSVIterator iter = null;
        try {
            iter = new MyDSVIterator(this.format, this.reader);
        }
        catch (IOException e) {
            iter = Collections.emptyList().iterator();
        }
        return iter;
    }

    private static class MyDSVIterator
    implements Iterator<DSVRecord> {
        private final DSVUtil util;
        private final LineNumberReader lnr;
        private String nextLine = null;

        MyDSVIterator(DSVFormat format, Reader reader) throws IOException {
            this.util = new DSVUtil(format.getSeparator());
            this.lnr = new LineNumberReader(reader);
            if (format.getSkipHeaderRecord()) {
                this.lnr.readLine();
            }
            this.nextLine = this.lnr.readLine();
        }

        @Override
        public boolean hasNext() {
            return this.nextLine != null;
        }

        @Override
        public DSVRecord next() {
            if (this.nextLine == null) {
                throw new NoSuchElementException();
            }
            String actualLine = this.nextLine;
            String[] elements = this.util.split(this.nextLine);
            try {
                this.nextLine = this.lnr.readLine();
            }
            catch (IOException e) {
                this.nextLine = null;
            }
            return new DSVRecord(elements, actualLine);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

