/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.builder.reader.text;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSVUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DSVUtil.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Character DQUOTE = Character.valueOf('\"');
    private static final String DQUOTE_STRING = "\"";
    private final String separator;

    protected DSVUtil(String separator) {
        if (separator.length() != 1) {
            throw new IllegalArgumentException("separator must be one character long.");
        }
        this.separator = separator;
    }

    public String cleanup(String s) {
        if (s.endsWith(this.separator)) {
            return this.cleanup(s.substring(0, s.length() - 1)) + this.separator + " ";
        }
        return s;
    }

    public String[] split(String csv) {
        if (csv.trim().isEmpty()) {
            return EMPTY_STRING_ARRAY;
        }
        StringBuilder sb = new StringBuilder();
        ArrayList<String> elements = new ArrayList<String>();
        State state = State.IN_TEXT;
        char[] chars = csv.toCharArray();
        if (chars[0] == '\u00ff' && chars[1] == '\u00fe' || chars[0] == '\u00fe' && chars[1] == '\u00ff') {
            chars = csv.substring(2).toCharArray();
        } else if (chars[0] == '\u00ef' && chars[1] == '\u00bb' && chars[2] == '\u00bf') {
            chars = csv.substring(3).toCharArray();
        }
        block6: for (char ch : chars) {
            switch (state) {
                case IN_TEXT: {
                    if (ch == DQUOTE.charValue()) {
                        state = State.QUOTE_IN_TEXT;
                        continue block6;
                    }
                    if (ch == this.separator.charAt(0)) {
                        elements.add(sb.toString());
                        sb.setLength(0);
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case QUOTE_IN_TEXT: {
                    sb.append(ch);
                    state = ch == DQUOTE.charValue() ? State.IN_TEXT : State.IN_QUOTE;
                    continue block6;
                }
                case IN_QUOTE: {
                    if (ch == DQUOTE.charValue()) {
                        state = State.QUOTE_IN_QUOTE;
                        continue block6;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case QUOTE_IN_QUOTE: {
                    if (ch == DQUOTE.charValue()) {
                        state = State.IN_QUOTE;
                        sb.append(ch);
                        continue block6;
                    }
                    state = State.IN_TEXT;
                    if (ch == this.separator.charAt(0)) {
                        elements.add(sb.toString());
                        sb.setLength(0);
                        continue block6;
                    }
                    sb.append(ch);
                }
            }
        }
        elements.add(sb.toString());
        String[] results = elements.toArray(EMPTY_STRING_ARRAY);
        for (int i = 0; i < results.length; ++i) {
            results[i] = results[i].trim();
            if (DQUOTE_STRING.equals(results[i])) {
                results[i] = "";
                continue;
            }
            if (!results[i].startsWith(DQUOTE_STRING) || !results[i].endsWith(DQUOTE_STRING)) continue;
            results[i] = results[i].substring(1, results[i].length() - 1);
        }
        return results;
    }

    public String format(String[] elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            if (element != null) {
                if (element.contains(DQUOTE_STRING)) {
                    element = element.replaceAll(DQUOTE_STRING, "\"\"");
                }
                if (element.contains(this.separator) || element.contains(DQUOTE_STRING)) {
                    sb.append(DQUOTE_STRING + element + DQUOTE_STRING);
                } else {
                    sb.append(element);
                }
            }
            sb.append(this.separator);
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String format(Object[] elements) {
        String[] strings = new String[elements.length];
        for (int i = 0; i < strings.length; ++i) {
            if (elements[i] == null) continue;
            strings[i] = elements[i].toString();
        }
        return this.format(strings);
    }

    static enum State {
        IN_TEXT,
        QUOTE_IN_TEXT,
        IN_QUOTE,
        QUOTE_IN_QUOTE;

    }
}

