/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.index.spatial.binary;

import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RangeCombiningSpatialIndexValueIterator
implements Iterator<SpatialIndexValue>,
Closeable {
    private final int m_valuesPerReturn;
    private final Iterator<SpatialIndexValue> m_iterator;
    private Iterator<SpatialIndexValue> m_currentStreetIterator;
    private SpatialIndexValue m_nextStreet;

    public RangeCombiningSpatialIndexValueIterator(int valuesPerReturn, Iterator<SpatialIndexValue> iterator) {
        if (valuesPerReturn < 1) {
            throw new IllegalArgumentException();
        }
        this.m_valuesPerReturn = valuesPerReturn;
        this.m_iterator = iterator;
    }

    @Override
    public boolean hasNext() {
        return this.m_iterator.hasNext() || this.m_nextStreet != null || this.m_currentStreetIterator != null && this.m_currentStreetIterator.hasNext();
    }

    @Override
    public SpatialIndexValue next() throws DataAccessRuntimeException {
        if (this.m_currentStreetIterator == null || !this.m_currentStreetIterator.hasNext()) {
            this.loadNextStreet();
        }
        return this.m_currentStreetIterator.next();
    }

    @Override
    public void remove() {
        if (this.m_currentStreetIterator == null) {
            throw new IllegalStateException();
        }
        this.m_currentStreetIterator.remove();
    }

    @Override
    public void close() throws IOException {
        if (this.m_iterator instanceof Closeable) {
            ((Closeable)((Object)this.m_iterator)).close();
        }
    }

    private void loadNextStreet() {
        ArrayList<SpatialIndexValue> currentStreetValues = new ArrayList<SpatialIndexValue>();
        SpatialIndexValue previousValue = null;
        if (this.m_nextStreet != null) {
            currentStreetValues.add(this.m_nextStreet);
            previousValue = this.m_nextStreet;
            this.m_nextStreet = null;
        } else if (!this.m_iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        while (this.m_iterator.hasNext()) {
            SpatialIndexValue currentValue = this.m_iterator.next();
            if (previousValue == null) {
                currentStreetValues.add(currentValue);
                previousValue = currentValue;
                continue;
            }
            if (this.sameStreets(previousValue, currentValue)) {
                currentStreetValues.add(currentValue);
                continue;
            }
            this.m_nextStreet = currentValue;
            break;
        }
        ArrayList<SpatialIndexValue> addressPointValues = new ArrayList<SpatialIndexValue>();
        ArrayList<SpatialIndexValue> standardValues = new ArrayList<SpatialIndexValue>();
        for (SpatialIndexValue value : currentStreetValues) {
            standardValues.add(value);
        }
        currentStreetValues.clear();
        currentStreetValues.addAll(this.mergeAddressPointValues(addressPointValues));
        currentStreetValues.addAll(this.mergeStandardValues(standardValues));
        this.m_currentStreetIterator = currentStreetValues.iterator();
    }

    private boolean sameStreets(SpatialIndexValue value1, SpatialIndexValue value2) {
        return value1.getSac() == value2.getSac() && value1.getStreetStartOffset() == value2.getStreetStartOffset();
    }

    private List<SpatialIndexValue> mergeAddressPointValues(List<SpatialIndexValue> values) {
        if (values.size() < 2) {
            return values;
        }
        Iterator<SpatialIndexValue> iterator = values.iterator();
        ArrayList<SpatialIndexValue> results = new ArrayList<SpatialIndexValue>();
        SpatialIndexValue current = null;
        int count = 0;
        while (iterator.hasNext()) {
            if (current == null) {
                current = iterator.next();
                count = 1;
                results.add(current);
                continue;
            }
            if (count < this.m_valuesPerReturn) {
                current.addBounds(iterator.next().getBounds());
                ++count;
                continue;
            }
            current = null;
            count = 0;
        }
        return results;
    }

    private List<SpatialIndexValue> mergeStandardValues(List<SpatialIndexValue> values) {
        if (values.size() < 2) {
            return values;
        }
        Collections.sort(values, new StandardValueComparator());
        ArrayList<SpatialIndexValue> results = new ArrayList<SpatialIndexValue>();
        Iterator<SpatialIndexValue> iterator = values.iterator();
        SpatialIndexValue previous = iterator.next();
        results.add(previous);
        while (iterator.hasNext()) {
            SpatialIndexValue value = iterator.next();
            if (previous.getBounds().equals((Object)value.getBounds())) continue;
            previous = value;
            results.add(value);
        }
        return results;
    }

    private static class StandardValueComparator
    implements Comparator<SpatialIndexValue> {
        private StandardValueComparator() {
        }

        @Override
        public int compare(SpatialIndexValue value1, SpatialIndexValue value2) {
            double diff = value1.getBounds().getLLX() - value2.getBounds().getLLX();
            if (diff != 0.0) {
                return this.convertDifference(diff);
            }
            diff = value1.getBounds().getLLY() - value2.getBounds().getLLY();
            if (diff != 0.0) {
                return this.convertDifference(diff);
            }
            diff = value1.getBounds().getURX() - value2.getBounds().getURX();
            if (diff != 0.0) {
                return this.convertDifference(diff);
            }
            diff = value1.getBounds().getURY() - value2.getBounds().getURY();
            if (diff != 0.0) {
                return this.convertDifference(diff);
            }
            return 0;
        }

        private int convertDifference(double diff) {
            return diff < 0.0 ? -1 : 1;
        }
    }
}

