/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.index.spatial.binary;

import com.mapinfo.mapmarker.cgge.dp.IDictionaryMetaData;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexIOHandler1;
import com.mapinfo.mapmarker.cgge.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.midev.geometry.Envelope;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SpatialIndexIOHandler {
    private final IDictionaryMetaData metaData;

    SpatialIndexIOHandler(IDictionaryMetaData metaData) {
        this.metaData = metaData;
    }

    public static SpatialIndexIOHandler getInstance(IDictionaryMetaData metaData) {
        if (metaData.getVersion() > 1) {
            return new SpatialIndexIOHandler1(metaData);
        }
        return new SpatialIndexIOHandler(metaData);
    }

    public void read(SpatialIndexValue spatialIndexValue, DataInput in) throws IOException {
        spatialIndexValue.setSac(in.readInt());
        spatialIndexValue.setStreetStartOffset(in.readLong());
        spatialIndexValue.setAddressSize(in.readInt());
        spatialIndexValue.setBounds(new Envelope(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), spatialIndexValue.getSpatialInfo()));
    }

    public void write(SpatialIndexValue spatialIndexValue, DataOutput outputStream) throws IOException {
        outputStream.writeInt(spatialIndexValue.getSac());
        outputStream.writeLong(spatialIndexValue.getStreetStartOffset());
        outputStream.writeInt(spatialIndexValue.getAddressSize());
        Envelope bounds = spatialIndexValue.getBounds();
        outputStream.writeDouble(bounds.getLLX());
        outputStream.writeDouble(bounds.getLLY());
        outputStream.writeDouble(bounds.getURX());
        outputStream.writeDouble(bounds.getURY());
    }

    IDictionaryMetaData getMetaData() {
        return this.metaData;
    }
}

