/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.dp.index.spatial.binary;

import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.core.reverseGeocode.ReverseGeocodeUtils;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.CoordSysConstants;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class SpatialIndexValue {
    public static final int NO_OFFSET = 0;
    public static final SpatialInfo DEFAULT_SPATIALINFO = new SpatialInfo(CoordSysConstants.longLatWGS84);
    private static final AddressOffsetComparator ADDRESS_OFFSET_COMPARATOR = new AddressOffsetComparator();
    private int m_sac;
    private long m_streetStartOffset;
    private int m_addressSize;
    private Envelope m_bounds;
    private final SpatialInfo spatialInfo;
    private SpatialInfo m_dataSpatialInfo;

    public SpatialIndexValue() {
        this(DEFAULT_SPATIALINFO);
    }

    public SpatialIndexValue(SpatialInfo spatialInfo) {
        this.spatialInfo = DEFAULT_SPATIALINFO;
        this.m_dataSpatialInfo = spatialInfo;
        this.m_streetStartOffset = 0L;
        this.m_addressSize = 0;
        this.m_bounds = null;
    }

    public SpatialIndexValue(SpatialIndexValue copyFrom, Envelope newBounds) {
        this.m_dataSpatialInfo = copyFrom.m_dataSpatialInfo;
        this.spatialInfo = newBounds.getSpatialInfo();
        this.m_streetStartOffset = copyFrom.m_streetStartOffset;
        this.m_addressSize = copyFrom.m_addressSize;
        this.m_bounds = newBounds;
        this.m_sac = copyFrom.m_sac;
    }

    public void setStreetStartOffset(long streetOffset) {
        this.m_streetStartOffset = streetOffset;
    }

    public long getStreetStartOffset() {
        return this.m_streetStartOffset;
    }

    public void setAddressSize(int addressSize) {
        this.m_addressSize = addressSize;
    }

    public int getAddressSize() {
        return this.m_addressSize;
    }

    public int getSac() {
        return this.m_sac;
    }

    public void setSac(int sac) {
        this.m_sac = sac;
    }

    public void addPoint(DirectPosition point) {
        point = this.convert(point);
        if (this.m_bounds == null) {
            this.m_bounds = new Envelope(point, point, this.spatialInfo);
        } else if (!this.m_bounds.contains(point)) {
            this.m_bounds.extend(point);
        }
    }

    private DirectPosition convert(DirectPosition dp) {
        return CoordConvertor.transformPointToWGS84((CoordSys)this.m_dataSpatialInfo.getCoordSys(), (DirectPosition)dp);
    }

    public Envelope getBounds() {
        return this.m_bounds;
    }

    void setBounds(Envelope bounds) {
        this.m_bounds = bounds;
    }

    public void addBounds(Envelope rect) {
        if (!this.m_bounds.contains(rect)) {
            this.m_bounds.extend(rect);
        }
    }

    public SpatialInfo getSpatialInfo() {
        return this.spatialInfo;
    }

    private boolean isSameAddressPointer(SpatialIndexValue other) {
        return this.getSac() == other.getSac() && this.getStreetStartOffset() == other.getStreetStartOffset();
    }

    public static void sortAndRemoveDuplicates(List<WrappedSpatialIndexValue> values) {
        if (values.size() < 2) {
            return;
        }
        Collections.sort(values, ADDRESS_OFFSET_COMPARATOR);
        Iterator<WrappedSpatialIndexValue> it = values.iterator();
        WrappedSpatialIndexValue closestValue = it.next();
        while (it.hasNext()) {
            WrappedSpatialIndexValue currValue = it.next();
            if (closestValue.getValue().isSameAddressPointer(currValue.getValue())) {
                it.remove();
                continue;
            }
            closestValue = currValue;
        }
        Collections.sort(values);
    }

    public WrappedSpatialIndexValue getWrappedSpatialIndexValue(DirectPosition point) {
        return new WrappedSpatialIndexValue(this, point);
    }

    public static class WrappedSpatialIndexValue
    implements Comparable<WrappedSpatialIndexValue> {
        private final SpatialIndexValue m_value;
        private final double m_distance;

        private WrappedSpatialIndexValue(SpatialIndexValue value, DirectPosition point) {
            this.m_value = value;
            this.m_distance = ReverseGeocodeUtils.getDistance((DirectPosition)point, (Envelope)value.getBounds());
        }

        public SpatialIndexValue getValue() {
            return this.m_value;
        }

        public double getDistance() {
            return this.m_distance;
        }

        @Override
        public int compareTo(WrappedSpatialIndexValue that) {
            if (this.m_distance < that.m_distance) {
                return -1;
            }
            if (this.m_distance > that.m_distance) {
                return 1;
            }
            return 0;
        }
    }

    private static class AddressOffsetComparator
    implements Comparator<WrappedSpatialIndexValue> {
        private AddressOffsetComparator() {
        }

        @Override
        public int compare(WrappedSpatialIndexValue wsiv1, WrappedSpatialIndexValue wsiv2) {
            SpatialIndexValue siv1 = wsiv1.getValue();
            SpatialIndexValue siv2 = wsiv2.getValue();
            int c = siv1.getSac() - siv2.getSac();
            if (c == 0) {
                c = MMUtils.compareLongValues(siv1.getStreetStartOffset(), siv2.getStreetStartOffset());
            }
            return c == 0 ? wsiv1.compareTo(wsiv2) : c;
        }
    }
}

