/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.AbstractDictionaryItem;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.DictionaryItemUtils;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryFieldItem;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryItem;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.ICGGEGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractGeocodingHelper
implements ICGGEGeocodingHelper {
    private String m_country;
    private String m_language;
    protected Set<AreaTermSearchWordCombo> m_savedAreaSearchComboList;
    private List<FieldType> m_sacSearchFields;
    private List<FieldType> m_addrSearchFields;
    protected boolean m_filterSearchedAreaItemAndWordCombo;
    protected Map<SearchedSacs, SearchedSacs> m_searchedSacMap;
    private final Comparator<IDictionaryItem> m_dictItemComp = DictionaryItemUtils.getDictionaryItemComparator();
    private final Comparator<IDictionaryFieldItem> m_dictFieldItemComp = DictionaryItemUtils.getDictionaryFieldItemComparator();
    private ICGGEParser m_parser;
    private ICGGESoundex m_soundex;
    private boolean m_canContinue;
    private int m_geocodeType;
    protected List<DictionaryAddressWord> m_searchWordList;
    protected List<DictionaryAreaTermItem> m_areaList;

    @Override
    public boolean init(String country, String language) {
        this.m_country = country;
        this.m_language = language;
        this.m_geocodeType = 0;
        this.m_canContinue = true;
        return true;
    }

    protected void setGeocodeType(int type) {
        this.m_geocodeType = type;
    }

    protected int getGeocodeType() {
        return this.m_geocodeType;
    }

    @Override
    public boolean hasMoreTries() {
        return this.m_canContinue;
    }

    protected void finishRetries() {
        this.m_canContinue = false;
    }

    @Override
    public String getCountry() {
        return this.m_country;
    }

    @Override
    public String getLanguage() {
        return this.m_language;
    }

    public void setCountry(String cntry) {
        this.m_country = cntry;
    }

    public void setLanguage(String lng) {
        this.m_language = lng;
    }

    protected void setSacSearchFields(List<FieldType> sacSearchFields) {
        this.m_sacSearchFields = sacSearchFields;
    }

    protected List<FieldType> getSacSearchFields() {
        return this.m_sacSearchFields;
    }

    protected void setAddressSearchFields(List<FieldType> streetSearchFields) {
        this.m_addrSearchFields = streetSearchFields;
    }

    protected List<FieldType> getAddressSearchFields() {
        return this.m_addrSearchFields;
    }

    public boolean isAddressSearchableField(FieldType type) {
        return this.m_addrSearchFields != null && this.m_addrSearchFields.contains(type);
    }

    public boolean isSacSearchableField(FieldType type) {
        return this.m_sacSearchFields != null && this.m_sacSearchFields.contains(type);
    }

    public List<DictionaryAreaTermItem> getSearchAreaList() {
        return this.m_areaList;
    }

    public void setSearchAreaList(List<DictionaryAreaTermItem> areaList) {
        this.m_areaList = areaList;
    }

    public List<DictionaryAddressWord> getSearchWordList() {
        return this.m_searchWordList;
    }

    public void setSearchWordList(List<DictionaryAddressWord> searchWordList) {
        this.m_searchWordList = searchWordList;
    }

    protected boolean isFilterSearchAreaAndWordCombo() {
        return this.m_filterSearchedAreaItemAndWordCombo;
    }

    protected void setFilterSearchAreaAndWordCombo(boolean b) {
        this.m_filterSearchedAreaItemAndWordCombo = b;
    }

    protected ICGGEParser getHelperParser() {
        if (this.m_parser == null) {
            this.m_parser = this.getHandler().getParser();
        }
        return this.m_parser;
    }

    protected CGGEHandler getHandler() {
        return CGGEHandler.getInstance(null, this.m_country, this.m_language);
    }

    protected ICGGESoundex getHelperSoundex() {
        if (this.m_soundex == null) {
            this.m_soundex = this.getHandler().getSoundex();
        }
        return this.m_soundex;
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, FieldType type, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> searchableWordList = null;
        int searchWordLen = searchWords == null ? 0 : searchWords.length;
        int geocodeType = this.getGeocodeType();
        for (int searchWordNdx = 0; searchWordNdx < searchWordLen; ++searchWordNdx) {
            AddressWord searchWord = searchWords[searchWordNdx];
            List<DictionaryAddressWord> dictWordList = dataManager.findMatchingWords(geocodeType, searchWord, type, minQuality, options);
            searchableWordList = ListUtils.addToList(searchableWordList, dictWordList);
        }
        if (searchableWordList != null) {
            Iterator addrWordIt = searchableWordList.iterator();
            while (addrWordIt.hasNext()) {
                ((DictionaryAddressWord)addrWordIt.next()).getAddressWord().m_wordType = type;
            }
        }
        return searchableWordList;
    }

    protected void filterSearchedSacs(List<DictionaryAreaSacs> areaSacList, List<DictionaryAddressWord> searchWordList) {
        if (areaSacList.size() > 0) {
            Iterator<List<DictionaryAreaSacs>> subListIt = DictionaryItemUtils.getGroupedSubListIterator(areaSacList);
            while (subListIt.hasNext()) {
                List<DictionaryAreaSacs> subAreaSacList = subListIt.next();
                IntArray sacArray = new IntArray(20);
                for (DictionaryAreaSacs das : subAreaSacList) {
                    sacArray.add(das.getAreaSac());
                }
                sacArray.removeDuplicates();
                int sacCount = sacArray.size();
                DataSetInfo dataSetInfo = subAreaSacList.get(0).getDataSetInfo();
                for (int n = 0; n < sacCount; ++n) {
                    int sac = sacArray.get(n);
                    if (!this.considerSACforSearching(sac, searchWordList, dataSetInfo)) continue;
                    sacArray.removeAt(n--);
                    --sacCount;
                }
                if (sacArray.size() <= 0) continue;
                int[] removeSacs = sacArray.asArray();
                for (DictionaryAreaSacs das : subAreaSacList) {
                    das.setAreaSac(IntArray.removeItems(das.getAreaSac(), removeSacs));
                }
            }
            Iterator<DictionaryAreaSacs> it = areaSacList.iterator();
            while (it.hasNext()) {
                DictionaryAreaSacs das = it.next();
                if (das.getAreaSac() != null) continue;
                it.remove();
            }
        }
    }

    private boolean considerSACforSearching(int sac, List<DictionaryAddressWord> searchWordList, DataSetInfo dataSetInfo) {
        if (this.m_searchedSacMap == null) {
            this.m_searchedSacMap = new HashMap<SearchedSacs, SearchedSacs>(20);
        }
        SearchedSacs searchSac = new SearchedSacs(dataSetInfo, sac);
        SearchedSacs savedSearchedSac = this.m_searchedSacMap.get(searchSac);
        boolean canSearch = false;
        boolean sacSaved = true;
        if (savedSearchedSac == null) {
            sacSaved = false;
            canSearch = true;
            this.m_searchedSacMap.put(searchSac, searchSac);
            savedSearchedSac = searchSac;
        }
        for (DictionaryAddressWord searchWord : searchWordList) {
            if (!DictionaryItemUtils.fromSameDataSet(savedSearchedSac, searchWord)) continue;
            if (!sacSaved) {
                savedSearchedSac.addSeachedWord(searchWord);
                continue;
            }
            if (savedSearchedSac.contains(searchWord)) continue;
            savedSearchedSac.addSeachedWord(searchWord);
            canSearch = true;
        }
        return canSearch;
    }

    protected void filterSacsForAreaIntersection(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        int areaSacCount = areaSacList.size();
        if (areaSacCount > 0) {
            if (areaSacCount > 1) {
                Iterator<List<DictionaryAreaSacs>> subListIt = DictionaryItemUtils.getGroupedSubListIterator(areaSacList);
                while (subListIt.hasNext()) {
                    List<DictionaryAreaSacs> subList = subListIt.next();
                    this.filterSacsForAreaIntersection0(subList, insersectionFieldList);
                }
            } else {
                this.filterSacsForAreaIntersection0(areaSacList, insersectionFieldList);
            }
            for (int i = 0; i < areaSacCount; ++i) {
                DictionaryAreaSacs das = areaSacList.get(i);
                if (das.getAreaSac() != null) continue;
                areaSacList.remove(i);
                --areaSacCount;
                --i;
            }
        }
    }

    private void filterSacsForAreaIntersection0(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        IntArray sacArray = this.findIntersectingSacs(areaSacList, insersectionFieldList);
        int n = areaSacList.size();
        if (n > 0) {
            int[] intersectSacs = sacArray == null || sacArray.isEmpty() ? null : sacArray.asArray();
            for (int i = 0; i < n; ++i) {
                DictionaryAreaSacs das = areaSacList.get(i);
                das.setAreaSac(intersectSacs != null && insersectionFieldList.contains(das.getFieldType()) ? IntArray.getCommonItems(das.getAreaSac(), intersectSacs) : null);
            }
        }
    }

    private IntArray findIntersectingSacs(List<DictionaryAreaSacs> areaSacList, List<FieldType> intersectFieldList) {
        IntArray intersectingSacs = null;
        int areaSacCount = areaSacList.size();
        int typesFound = 0;
        if (areaSacCount > 0) {
            Collections.sort(areaSacList, this.m_dictFieldItemComp);
            Iterator<DictionaryAreaSacs> it = areaSacList.iterator();
            FieldType curType = FieldType.UNKNOWN_FIELD_TYPE;
            IntArray typeSacs = new IntArray();
            boolean check = false;
            while (it.hasNext()) {
                DictionaryAreaSacs das = it.next();
                FieldType type = das.getFieldType();
                if (type == curType) {
                    if (!check) continue;
                    typeSacs.add(das.getAreaSac());
                    continue;
                }
                if (check) {
                    if (intersectingSacs == null) {
                        intersectingSacs = new IntArray(typeSacs);
                    } else if ((intersectingSacs = IntArray.getCommonItems(intersectingSacs, typeSacs)) == null) {
                        return null;
                    }
                }
                typeSacs.removeAll();
                if (intersectFieldList.contains(type)) {
                    check = true;
                    ++typesFound;
                    typeSacs.add(das.getAreaSac());
                } else {
                    check = false;
                }
                curType = type;
            }
            if (!typeSacs.isEmpty()) {
                intersectingSacs = IntArray.getCommonItems(intersectingSacs, typeSacs);
            }
        }
        if (intersectingSacs != null && typesFound != intersectFieldList.size()) {
            intersectingSacs = null;
        }
        return intersectingSacs;
    }

    protected boolean containsSameSearchWord(DictionaryAreaTermItem areaItem, DictionaryAddressWord addrWord) {
        DictionaryAddressWord[] areaMatchedWords = areaItem.getMatchedWords();
        int areaMatchedWordLen = areaMatchedWords == null ? 0 : areaMatchedWords.length;
        for (int areaMatchedNdx = 0; areaMatchedNdx < areaMatchedWordLen; ++areaMatchedNdx) {
            DictionaryAddressWord areaMatchedWord = areaMatchedWords[areaMatchedNdx];
            if (areaMatchedWord == null || areaMatchedWord.getSearchWord() != addrWord.getSearchWord()) continue;
            return true;
        }
        return false;
    }

    protected void filterSearchedAreaItemAndSearchWord(List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList) {
        if (areaList != null && searchWordList != null) {
            if (this.m_savedAreaSearchComboList == null) {
                this.m_savedAreaSearchComboList = new HashSet<AreaTermSearchWordCombo>();
            }
            Collections.sort(areaList, this.m_dictItemComp);
            int searchWordSize = searchWordList.size();
            boolean[] searchWordAdded = new boolean[searchWordSize];
            Iterator<DictionaryAreaTermItem> areaIt = areaList.iterator();
            boolean areaAdded = false;
            while (areaIt.hasNext()) {
                DictionaryAreaTermItem areaItem = areaIt.next();
                DataSetInfo dataSetInfo = areaItem.getDataSetInfo();
                for (int searchWordNdx = 0; searchWordNdx < searchWordSize; ++searchWordNdx) {
                    AreaTermSearchWordCombo awc;
                    DictionaryAddressWord searchWord = searchWordList.get(searchWordNdx);
                    if (!DictionaryItemUtils.fromSameDataSet(areaItem, searchWord) || this.containsSameSearchWord(areaItem, searchWord) || this.m_savedAreaSearchComboList.contains(awc = new AreaTermSearchWordCombo(dataSetInfo, areaItem.m_indexCode, searchWord.getAddressWord().getCodedWord().getWordCode(), searchWord.getAddressWord().m_wordType))) continue;
                    this.m_savedAreaSearchComboList.add(awc);
                    areaAdded = true;
                    searchWordAdded[searchWordNdx] = true;
                }
                if (areaAdded || !this.m_filterSearchedAreaItemAndWordCombo) continue;
                areaIt.remove();
            }
            if (this.m_filterSearchedAreaItemAndWordCombo) {
                int searchWordNdx = 0;
                Iterator<DictionaryAddressWord> addrWordIt = searchWordList.iterator();
                while (addrWordIt.hasNext()) {
                    addrWordIt.next();
                    if (searchWordAdded[searchWordNdx++]) continue;
                    addrWordIt.remove();
                }
            }
        }
    }

    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
        List<DictionaryAddressWord> searchWordList = this.getSearchWordList();
        if (areaList != null && searchWordList != null) {
            areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
            List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(this.m_geocodeType, areaList, options);
            if (areaSacList != null) {
                Collection<InternalScoringAddress> cands;
                this.filterSearchedSacs(areaSacList, searchWordList);
                if (areaSacList != null && (cands = dataManager.findCandidates(this.m_geocodeType, areaSacList, searchWordList, options)) != null) {
                    candList = new InternalCandidateList();
                    candList.addCandidates(cands);
                }
            }
        }
        return candList;
    }

    protected void initSacAndStreetSearchFields(IDataManager dataManager) throws CGGEInternalException {
        List<FieldType> sacSearchFields = new ArrayList<FieldType>(3);
        List<FieldType> addrSearchFields = new ArrayList<FieldType>(3);
        int dictCount = dataManager.getDictionaryCount();
        int geocodeType = this.getGeocodeType();
        for (int dictNum = 1; dictNum <= dictCount; ++dictNum) {
            if (!dataManager.doesDictionarySupportsGeocodeType(dictNum, geocodeType)) continue;
            sacSearchFields = ListUtils.addToList(sacSearchFields, dataManager.getSACSearchFields(dictNum, geocodeType));
            addrSearchFields = ListUtils.addToList(addrSearchFields, dataManager.getAddressSearchFields(dictNum, geocodeType));
        }
        ListUtils.removeDuplicates(sacSearchFields);
        ListUtils.removeDuplicates(addrSearchFields);
        this.setSacSearchFields(sacSearchFields);
        this.setAddressSearchFields(addrSearchFields);
    }

    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, int includeMask) {
        return this.filterSearchWords(words, includeNormalWords, false, includeMask);
    }

    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, int includeMask) {
        return this.filterSearchWords(words, includeNormalWords, combineAlphaNumeric, true, includeMask);
    }

    private int getTypeWordCount(AddressWord[] words) {
        int typeCount = 0;
        for (AddressWord word : words) {
            if (!CodedWord.isThoroughfareTypeWord(word.getAttributes())) continue;
            ++typeCount;
        }
        return typeCount;
    }

    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        int wordsLen;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen == 1) {
            return AddressWordArray.clone(words);
        }
        if (wordsLen > 1) {
            boolean containsTypeSeparator = false;
            ArrayList<AddressWord> filteredWordList = new ArrayList<AddressWord>(wordsLen);
            if (noMultipleStreetTypeFiltering && this.getTypeWordCount(words) > 1) {
                includeMask |= 0x200;
            }
            for (int wordNdx = 0; wordNdx < wordsLen; ++wordNdx) {
                boolean include;
                AddressWord addrWord = words[wordNdx];
                short wordAttribs = addrWord.getAttributes();
                if (CodedWord.isDelimiter(wordAttribs)) {
                    if (!"%".equals(addrWord.getWord())) continue;
                    containsTypeSeparator = true;
                    continue;
                }
                boolean bl = include = (wordAttribs & includeMask) > 0;
                if (!include && includeNormalWords) {
                    boolean bl2 = include = (wordAttribs & 0x73C) == 0;
                }
                if (!include) continue;
                filteredWordList.add(addrWord);
            }
            if (containsTypeSeparator) {
                this.combinedWordsDelimitedByTypeSeparator(words, filteredWordList);
            }
            if (combineAlphaNumeric) {
                this.combineAlphaNumericWords(words, filteredWordList);
            }
            return filteredWordList.size() > 0 ? filteredWordList.toArray(new AddressWord[filteredWordList.size()]) : null;
        }
        return null;
    }

    protected List<DictionaryAddressWord> filterSearchWords(List<DictionaryAddressWord> searchWordList, boolean perfectMatches, int filterMask) {
        int listSize = searchWordList == null ? 0 : searchWordList.size();
        ArrayList<DictionaryAddressWord> filteredList = null;
        if (listSize > 0) {
            filteredList = new ArrayList<DictionaryAddressWord>(listSize);
            for (DictionaryAddressWord searchWord : searchWordList) {
                short wordAttribs;
                if (perfectMatches ^ searchWord.getMatchQuality() >= 1.0 || ((wordAttribs = searchWord.getSearchWord().getAttributes()) & filterMask) > 0) continue;
                filteredList.add(searchWord);
            }
            if (filteredList.size() == 0) {
                filteredList = null;
            }
        }
        return filteredList;
    }

    private void combineAlphaNumericWords(AddressWord[] words, List<AddressWord> list) {
        int len = words.length;
        ICGGESoundex soundex = this.getHelperSoundex();
        ICGGEParser parser = this.getHelperParser();
        for (int wordNdx = 1; wordNdx < len; ++wordNdx) {
            AddressWord preWord;
            AddressWord word = words[wordNdx];
            if (!CodedWord.isNumber(word.getAttributes()) || CodedWord.isNumber((preWord = words[wordNdx - 1]).getAttributes()) || CodedWord.isDelimiter(preWord.getAttributes())) continue;
            list.add(this.combinedAndFormNewAddressWord(preWord, word, parser, soundex));
            ++wordNdx;
        }
    }

    private void combinedWordsDelimitedByTypeSeparator(AddressWord[] words, List<AddressWord> list) {
        int len = words.length;
        ICGGESoundex soundex = this.getHelperSoundex();
        ICGGEParser parser = this.getHelperParser();
        for (int ndx = 1; ndx < len - 1; ++ndx) {
            AddressWord checkWord = words[ndx];
            if (!CodedWord.isDelimiter(checkWord.getAttributes()) || !"%".equals(checkWord.getWord())) continue;
            list.add(this.combinedAndFormNewAddressWord(words[ndx - 1], words[ndx + 1], parser, soundex));
        }
    }

    private AddressWord combinedAndFormNewAddressWord(AddressWord word1, AddressWord word2, ICGGEParser parser, ICGGESoundex soundex) {
        StringBuilder sb = new StringBuilder();
        sb.append(word1.getWordChars());
        sb.append(word2.getWordChars());
        return parser.convertToAddressWord(sb.toString(), soundex);
    }

    protected List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType areaType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        return dataManager.findAreaTerms(this.getGeocodeType(), searchWords, areaType, minQuality, options);
    }

    protected List<DictionaryAreaTermItem> findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, double minQuality, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        FieldType pcType = FieldType.POST_CODE_FIELD_TYPE;
        AddressWord[] pcWords = (AddressWord[])parsedAddr.getField(pcType);
        if (pcWords != null) {
            return this.findAreaList(pcWords, pcType, minQuality, dataManager, options);
        }
        List<DictionaryAreaTermItem> pcAreaList = null;
        List<PostCode> pcProbables = parsedAddr.getProbablePostcodes();
        if (pcProbables != null) {
            for (PostCode pc : pcProbables) {
                pcAreaList = ListUtils.addToList(pcAreaList, this.findAreaList(pc.getWords(), pcType, minQuality, dataManager, options));
            }
        }
        return pcAreaList;
    }

    public AddressWord[] getSplitWords(AddressWord[] inWords) {
        if (inWords != null) {
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            StringBuilder sb = new StringBuilder(15);
            ArrayList<AddressWord> splitWords = new ArrayList<AddressWord>(5);
            for (AddressWord addrWord : inWords) {
                if (!AddressWord.isSignificantWord(addrWord)) continue;
                char[] ch = addrWord.getWordChars();
                int len = ch.length;
                sb.append(ch);
                for (int i = 1; i < len - 1; ++i) {
                    AddressWord splitWord2;
                    AddressWord splitWord1 = parser.convertToAddressWord(sb.substring(0, i + 1), soundex);
                    if (AddressWord.isSignificantWord(splitWord1)) {
                        splitWords.add(splitWord1);
                    }
                    if (!AddressWord.isSignificantWord(splitWord2 = parser.convertToAddressWord(sb.substring(i), soundex))) break;
                    splitWords.add(splitWord2);
                }
                sb.delete(0, len);
            }
            if (splitWords.size() > 0) {
                return splitWords.toArray(new AddressWord[splitWords.size()]);
            }
        }
        return null;
    }

    public AddressWord[] getCombinedPossibles(AddressWord[] words) {
        int wordsLen;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 1) {
            ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(wordsLen * 3);
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            for (int wordNdx = 0; wordNdx < wordsLen - 1; ++wordNdx) {
                AddressWord word1;
                short wordAttribs1;
                AddressWord word = words[wordNdx];
                short wordAttribs = word.getAttributes();
                if (CodedWord.isDelimiter(wordAttribs) || CodedWord.isNumber(wordAttribs)) continue;
                CharArray charArray = new CharArray();
                charArray.add(word.getWordChars());
                for (int wordNdx1 = wordNdx + 1; wordNdx1 < wordsLen && !CodedWord.isNumber(wordAttribs1 = (word1 = words[wordNdx1]).getAttributes()); ++wordNdx1) {
                    if (CodedWord.isDelimiter(wordAttribs1)) continue;
                    charArray.add(word1.getWordChars());
                    AddressWord combinedWord = parser.convertToAddressWord(charArray.toString(), soundex);
                    addrWordList.add(combinedWord);
                }
            }
            if (addrWordList.size() > 0) {
                return addrWordList.toArray(new AddressWord[addrWordList.size()]);
            }
        }
        return null;
    }

    public List<DictionaryAddressWord> getSearchableWordsOnSplitInputWords(AddressWord[] inWords, FieldType searchType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (inWords != null) {
            AddressWord[] newSearchWords = this.getSplitWords(inWords);
            return this.getSearchableWords(newSearchWords, searchType, dataManager, minQuality, options);
        }
        return null;
    }

    private class SearchedSacs
    extends AbstractDictionaryItem
    implements Comparable<SearchedSacs> {
        int m_sac;
        Set<DictionaryAddressWord> m_searchedWords;

        SearchedSacs(DataSetInfo dataSetInfo, int sac) {
            this.setDataSetInfo(dataSetInfo);
            this.m_sac = sac;
        }

        boolean contains(DictionaryAddressWord daw) {
            return this.m_searchedWords != null && this.m_searchedWords.contains(daw);
        }

        void addSeachedWord(DictionaryAddressWord daw) {
            if (this.m_searchedWords == null) {
                this.m_searchedWords = new HashSet<DictionaryAddressWord>(5);
            }
            this.m_searchedWords.add(daw);
        }

        @Override
        public int compareTo(SearchedSacs o) {
            int c = this.getDataSetInfo().compareTo(o.getDataSetInfo());
            if (c == 0) {
                c = this.m_sac - o.m_sac;
            }
            return c;
        }

        @Override
        public int hashCode() {
            return super.hashCode() ^ this.m_sac * 31;
        }

        @Override
        public boolean equals(Object obj) {
            return this.compareTo((SearchedSacs)obj) == 0;
        }
    }

    private class AreaTermSearchWordCombo
    extends AbstractDictionaryItem
    implements Comparable<AreaTermSearchWordCombo> {
        int m_areaIndex = -1;
        long m_wordCode = -1L;

        AreaTermSearchWordCombo(DataSetInfo dataSetInfo, int areaIndex, long wordCode, FieldType wordType) {
            this.setDataSetInfo(dataSetInfo);
            this.setFieldType(wordType);
            this.m_areaIndex = areaIndex;
            this.m_wordCode = wordCode;
        }

        @Override
        public int compareTo(AreaTermSearchWordCombo o) {
            int n = AbstractGeocodingHelper.this.m_dictFieldItemComp.compare(this, o);
            if (n == 0 && (n = this.m_areaIndex - o.m_areaIndex) == 0) {
                n = MMUtils.compareLongValues(this.m_wordCode, o.m_wordCode);
            }
            return n;
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * super.hashCode();
            result = 31 * result + this.m_areaIndex;
            result = 31 * result + (int)(this.m_wordCode ^ this.m_wordCode >>> 32);
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            return this.compareTo((AreaTermSearchWordCombo)obj) == 0;
        }
    }
}

