/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractGeocodingHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public abstract class AbstractStreetGeocodingHelper
extends AbstractGeocodingHelper {
    protected int m_tryCount;
    protected int m_streetSubTryCount;
    protected int m_areaSubTryCount;
    protected double m_minimumSearchAreaQuality = 0.75;
    protected double m_minimimSearchWordQuality = 0.8;
    protected List<FieldType> m_areaSacIntersectionFieldList;

    @Override
    public boolean init(String country, String language) {
        if (super.init(country, language)) {
            this.setGeocodeType(1);
            this.m_tryCount = 0;
            this.m_streetSubTryCount = 0;
            this.m_areaSubTryCount = 0;
            return true;
        }
        return false;
    }

    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                if (this.getSacSearchFields() == null || this.getSacSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                this.generateAreaSubTries(dataManager, parsedAddr, options, candidateList);
                this.generateStreetSubTries(dataManager, parsedAddr, options, candidateList);
                return true;
            }
            case 1: {
                boolean canTry = false;
                do {
                    if (this.generateStreetSubTries(dataManager, parsedAddr, options, candidateList)) {
                        canTry = true;
                    }
                    if (canTry) break;
                    this.m_streetSubTryCount = 0;
                } while (this.generateAreaSubTries(dataManager, parsedAddr, options, candidateList));
                if (canTry) {
                    return true;
                }
                ++this.m_tryCount;
            }
        }
        return false;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.continueRetrying(parsedAddress, curCandList)) {
            if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
                return this.retrieveCandidates(dataManager, parsedAddress, this.getSearchAreaList(), this.getSearchWordList(), options);
            }
            this.finishRetries();
        } else {
            this.finishRetries();
        }
        return null;
    }

    protected List<DictionaryAreaSacs> findSACIntersection(IDataManager dataManager, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        List<DictionaryAreaSacs> areaSacList = null;
        Object candList = null;
        if (areaList != null && searchWordList != null) {
            areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
            this.filterSearchedAreaItemAndSearchWord(areaList, searchWordList);
            areaSacList = dataManager.getSacsForAreas(1, areaList, options);
            if (areaSacList != null && this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() > 0) {
                this.filterSacsForAreaIntersection(areaSacList, this.m_areaSacIntersectionFieldList);
            }
        }
        return areaSacList;
    }

    protected InternalCandidateList filterCandidates(IDataManager dataManager, List<DictionaryAreaTermItem> areaList, List<DictionaryAreaSacs> areaSacList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        if (areaList != null && searchWordList != null) {
            Collection<InternalScoringAddress> cands;
            if (areaSacList != null && areaSacList.size() > 0) {
                this.filterSearchedSacs(areaSacList, searchWordList);
            }
            if (areaSacList != null && (cands = dataManager.findCandidates(this.getGeocodeType(), areaSacList, searchWordList, options)) != null) {
                candList = new InternalCandidateList();
                candList.addCandidates(cands);
            }
        }
        return candList;
    }

    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        Object candList = null;
        List<DictionaryAreaSacs> areaSacList = this.findSACIntersection(dataManager, areaList, searchWordList, options);
        return this.filterCandidates(dataManager, areaList, areaSacList, searchWordList, options);
    }

    public void setAreaSacIntersectionFieldList(List<FieldType> list) {
        this.m_areaSacIntersectionFieldList = list;
    }

    public List<FieldType> getAreaSacIntersectionFieldList() {
        return this.m_areaSacIntersectionFieldList;
    }

    protected double getMinimumSearchAreaQuality() {
        return this.m_minimumSearchAreaQuality;
    }

    protected void setMinimumSearchAreaQuality(double q) {
        this.m_minimumSearchAreaQuality = q;
    }

    protected double getMinimumSearchWordQuality() {
        return this.m_minimimSearchWordQuality;
    }

    protected void setMinimumSearchWordQuality(double q) {
        this.m_minimimSearchWordQuality = q;
    }

    protected abstract boolean generateStreetSubTries(IDataManager var1, ParsedAddress var2, GeocodeOptions var3, InternalCandidateList var4) throws DataFetchException, CGGEInternalException, DataNotInitialisedException;

    protected abstract boolean generateAreaSubTries(IDataManager var1, ParsedAddress var2, GeocodeOptions var3, InternalCandidateList var4) throws DataFetchException, CGGEInternalException, DataNotInitialisedException;

    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        int closeMatchCount;
        int n = closeMatchCount = currentList == null ? 0 : currentList.getNumberOfCloseMatches();
        if (pAddr.isIntersectionCase()) {
            if (closeMatchCount > 1) {
                for (int candNdx = 0; candNdx < closeMatchCount - 1; ++candNdx) {
                    InternalScoringAddress cand1 = currentList.getIndexedCandidate(candNdx);
                    FieldScore streetScore1 = cand1.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                    if (streetScore1 == null || streetScore1.m_matchedInputWords == null) continue;
                    int firstMatchedWord1 = streetScore1.m_matchedInputWords.min();
                    int lastMatchedWord1 = streetScore1.m_matchedInputWords.max();
                    for (int candNdx1 = candNdx + 1; candNdx1 < closeMatchCount; ++candNdx1) {
                        InternalScoringAddress cand2 = currentList.getIndexedCandidate(candNdx1);
                        FieldScore streetScore2 = cand2.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                        if (streetScore2 == null || streetScore2.m_matchedInputWords == null) continue;
                        int firstMatchedWord2 = streetScore2.m_matchedInputWords.min();
                        int lastMatchedWord2 = streetScore2.m_matchedInputWords.max();
                        if (lastMatchedWord2 >= firstMatchedWord1 && firstMatchedWord2 <= lastMatchedWord1) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        if (closeMatchCount > 0) {
            InternalScoringAddress cand = currentList.getIndexedCandidate(0);
            if (!pAddr.isSeperatePostAddressFields() && this.m_areaSubTryCount < 5 && this.m_streetSubTryCount < 4) {
                FieldScore score = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                if (score != null && score.m_value < 0.8) {
                    return true;
                }
                List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
                if (this.containsAreaType(areaList, FieldType.POST_CODE_FIELD_TYPE) && ((score = cand.getFieldScore(FieldType.POST_CODE_FIELD_TYPE)) == null || score.m_value < 0.8)) {
                    return true;
                }
                if (this.containsAreaType(areaList, FieldType.AREA_NAME_3_FIELD_TYPE) && ((score = cand.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE)) == null || score.m_value < 0.8)) {
                    return true;
                }
            }
            List<AddressWord> searchWords = cand.getSearchWords();
            for (AddressWord searchWord : searchWords) {
                if (!AddressWord.isSignificantWord(searchWord)) {
                    FieldScore score = cand.getFieldScore(searchWord.m_wordType);
                    if (score == null || !(score.m_value > 0.9)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    protected boolean doesBestCandidateHasPerfectField(InternalCandidateList candList, FieldType type) {
        InternalScoringAddress candAddr;
        FieldScore score;
        return candList != null && candList.getCandidateCount() > 0 && (score = (candAddr = candList.getIndexedCandidate(0)).getFieldScore(type)) != null && score.m_value >= 1.0;
    }

    private boolean containsAreaType(List<DictionaryAreaTermItem> areaList, FieldType type) {
        if (areaList != null) {
            for (DictionaryAreaTermItem areaItem : areaList) {
                if (areaItem.getFieldType() != type) continue;
                return true;
            }
        }
        return false;
    }
}

