/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.cgge.helper;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.AbstractGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.List;

public class CGGEGeographicGeocodingHelper
extends AbstractGeocodingHelper {
    private int m_tryCount;
    private boolean m_area1SacKeyAllowed = false;
    private boolean m_area2SacKeyAllowed = false;
    private boolean m_area3SacKeyAllowed = false;
    private boolean m_area4SacKeyAllowed = false;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.m_tryCount = 0;
        this.setGeocodeType(3);
        return true;
    }

    private void setSearchableFields(IDataManager dataManager) throws CGGEInternalException {
        this.initSacAndStreetSearchFields(dataManager);
        List<FieldType> sacSearchFields = this.getSacSearchFields();
        if (sacSearchFields != null) {
            if (!this.m_area1SacKeyAllowed) {
                this.m_area1SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_1_FIELD_TYPE);
            }
            if (!this.m_area2SacKeyAllowed) {
                this.m_area2SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_2_FIELD_TYPE);
            }
            if (!this.m_area3SacKeyAllowed) {
                this.m_area3SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_3_FIELD_TYPE);
            }
            if (!this.m_area4SacKeyAllowed) {
                this.m_area4SacKeyAllowed = sacSearchFields.contains(FieldType.AREA_NAME_4_FIELD_TYPE);
            }
        }
    }

    protected AddressWord[] getAreaWords(AddressWord[] areaWords) {
        int wordCount;
        AddressWord[] resultWords = null;
        int n = wordCount = areaWords == null ? 0 : areaWords.length;
        if (wordCount > 0) {
            ArrayList<AddressWord> areaWordList = new ArrayList<AddressWord>(wordCount);
            for (int wordNdx = 0; wordNdx < wordCount; ++wordNdx) {
                AddressWord areaWord = areaWords[wordNdx];
                if (CodedWord.isDelimiter(areaWord.getAttributes())) {
                    AddressWord combinedWord;
                    int areaListSize;
                    if (areaWord.getWordChars()[0] != '%' || (areaListSize = areaWordList.size()) <= 0) continue;
                    StringBuilder builder = new StringBuilder();
                    builder.append(((AddressWord)areaWordList.get(areaListSize - 1)).getWordChars());
                    builder.append(areaWords[wordNdx + 1].getWordChars());
                    areaWord = combinedWord = this.getHelperParser().convertToAddressWord(builder.toString(), this.getHelperSoundex());
                    areaWordList.set(areaWordList.size() - 1, combinedWord);
                    ++wordNdx;
                    continue;
                }
                areaWordList.add(areaWord);
            }
            if (areaWordList.size() > 0) {
                resultWords = areaWordList.toArray(new AddressWord[areaWordList.size()]);
            }
        }
        return resultWords;
    }

    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean separateAreaFields = parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) != null || parsedAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) != null;
        AddressWord[] lookUpAreaWords = null;
        List<DictionaryAreaTermItem> areaList = null;
        List<DictionaryAddressWord> searchWordList = null;
        switch (this.m_tryCount) {
            case 0: {
                this.setSearchableFields(dataManager);
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, true, options);
                    break;
                }
            }
            case 1: {
                ++this.m_tryCount;
                if (this.m_area4SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, true, options);
                    break;
                }
            }
            case 2: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && !options.isMustMatchAreaName3() && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 3: {
                ++this.m_tryCount;
                if (this.m_area4SacKeyAllowed && !options.isMustMatchAreaName4() && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 4: {
                ++this.m_tryCount;
                if (this.m_area2SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_2_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 5: {
                ++this.m_tryCount;
                if (this.m_area1SacKeyAllowed && (lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) : this.getAreaWords((AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE))) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_1_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 6: {
                if (this.m_area4SacKeyAllowed) {
                    ++this.m_tryCount;
                    if (separateAreaFields && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options))) {
                        searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                        break;
                    }
                }
            }
            case 7: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && separateAreaFields && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            case 8: {
                if (this.m_area4SacKeyAllowed) {
                    ++this.m_tryCount;
                    if (separateAreaFields && !options.isMustMatchAreaName4() && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.8, dataManager, options))) {
                        searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                        break;
                    }
                }
            }
            case 9: {
                ++this.m_tryCount;
                if (this.m_area3SacKeyAllowed && separateAreaFields && !options.isMustMatchAreaName3() && (lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE)) != null && !ListUtils.isEmpty(areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.8, dataManager, options))) {
                    searchWordList = this.getSearchableWords(lookUpAreaWords, dataManager, false, options);
                    break;
                }
            }
            default: {
                return false;
            }
        }
        if (areaList != null && searchWordList != null) {
            this.setSearchAreaList(areaList);
            this.setSearchWordList(searchWordList);
        }
        return true;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            return this.retrieveCandidates(dataManager, parsedAddress, options);
        }
        this.finishRetries();
        return null;
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, FieldType type, IDataManager dataManager, boolean perfectWordsOnly, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        double minQuality = perfectWordsOnly ? 1.0 : 0.8;
        return super.getSearchableWords(searchWords, type, dataManager, minQuality, options);
    }

    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] inputWords, IDataManager dataManager, boolean perfectWordsOnly, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> retWordList = null;
        if (inputWords != null) {
            double minQuality = perfectWordsOnly ? 1.0 : 0.8;
            List<FieldType> searchableFields = this.getAddressSearchFields();
            if (searchableFields != null && !searchableFields.isEmpty()) {
                for (FieldType searchType : searchableFields) {
                    List<DictionaryAddressWord> curList = this.getSearchableWords(inputWords, searchType, dataManager, minQuality, options);
                    retWordList = ListUtils.addToList(retWordList, curList);
                }
            }
        }
        return retWordList;
    }

    protected void setAreaList(List<DictionaryAreaTermItem> areaList) {
        this.setSearchAreaList(areaList);
    }

    protected List<DictionaryAreaTermItem> getAreaList() {
        return this.getSearchAreaList();
    }
}

